/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bull.javamelody.Action;
import net.bull.javamelody.CacheInformations;
import net.bull.javamelody.Collector;
import net.bull.javamelody.Counter;
import net.bull.javamelody.CounterRequestContext;
import net.bull.javamelody.DatabaseInformations;
import net.bull.javamelody.HeapHistogram;
import net.bull.javamelody.HtmlCacheInformationsReport;
import net.bull.javamelody.HtmlCounterReport;
import net.bull.javamelody.HtmlCounterRequestContextReport;
import net.bull.javamelody.HtmlDatabaseInformationsReport;
import net.bull.javamelody.HtmlHeapHistogramReport;
import net.bull.javamelody.HtmlJavaInformationsReport;
import net.bull.javamelody.HtmlProcessInformationsReport;
import net.bull.javamelody.HtmlSessionInformationsReport;
import net.bull.javamelody.HtmlThreadInformationsReport;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JRobin;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.Period;
import net.bull.javamelody.ProcessInformations;
import net.bull.javamelody.SessionInformations;
import net.bull.javamelody.ThreadInformations;
import net.bull.javamelody.VirtualMachine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HtmlReport {
    private static final String SCRIPT_BEGIN = "<script type='text/javascript'>";
    private static final String SCRIPT_END = "</script>";
    private static final boolean PDF_ENABLED = HtmlReport.isPdfEnabled();
    private final Collector collector;
    private final List<JavaInformations> javaInformationsList;
    private final Period period;
    private final Writer writer;
    private final boolean collectorServer;

    HtmlReport(Collector collector, boolean collectorServer, List<JavaInformations> javaInformationsList, Period period, Writer writer) {
        assert (collector != null);
        assert (javaInformationsList != null && !javaInformationsList.isEmpty());
        assert (period != null);
        assert (writer != null);
        this.collector = collector;
        this.collectorServer = collectorServer;
        this.javaInformationsList = javaInformationsList;
        this.period = period;
        this.writer = writer;
    }

    private static boolean isPdfEnabled() {
        try {
            Class.forName("com.lowagie.text.Document");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    void toHtml(String message) throws IOException {
        long start = System.currentTimeMillis();
        this.writeHtmlHeader(false);
        if (this.collectorServer) {
            this.writeln("<div align='center'>");
            this.writeApplicationsLinks(this.buildPeriodParameter());
            HtmlReport.writeAddAndRemoveApplicationLinks(this.collector.getApplication(), this.period, this.writer);
            this.writeln("</div>\n");
        }
        this.writeln("<h3><img width='24' height='24' src='?resource=systemmonitor.png' alt='#Stats#'/>");
        String javaMelodyUrl = "<a href='http://javamelody.googlecode.com' target='_blank'>JavaMelody</a>";
        String startDate = I18N.createDateAndTimeFormat().format(this.collector.getCounters().get(0).getStartDate());
        this.writeln(I18N.getFormattedString("Statistiques", "<a href='http://javamelody.googlecode.com' target='_blank'>JavaMelody</a>", I18N.getCurrentDateAndTime(), startDate, this.collector.getApplication()));
        if (this.javaInformationsList.get(0).getContextDisplayName() != null) {
            this.writeln(" (" + this.javaInformationsList.get(0).getContextDisplayName() + ')');
        }
        this.writeln("</h3>");
        this.writeln("<div align='center'>");
        this.writeRefreshAndPeriodLinks(null);
        this.writeGraphs();
        this.writeln("</div>");
        Map<String, HtmlCounterReport> counterReportsByCounterName = this.writeCounters();
        if (this.period == Period.TOUT) {
            this.writeln("<div align='right'>");
            this.writeln("<a href='?period=tout&amp;action=clear_counter&amp;counter=all' title='#Vider_toutes_stats#'");
            this.writeln("class='noPrint' onclick=\"javascript:return confirm('" + I18N.javascriptEncode(I18N.getString("confirm_vider_toutes_stats")) + "');\">#Reinitialiser_toutes_stats#</a>");
            this.writeln("</div>");
        }
        if (!this.collectorServer) {
            this.writeln("<h3><img width='24' height='24' src='?resource=hourglass.png' alt='#Requetes_en_cours#'/>#Requetes_en_cours#</h3>");
            this.writeCurrentRequests(this.javaInformationsList.get(0), counterReportsByCounterName);
        }
        this.writeln("<h3><img width='24' height='24' src='?resource=systeminfo.png' alt='#Informations_systemes#'/>");
        this.writeln("#Informations_systemes#</h3>");
        if (this.collectorServer) {
            this.writeln("<div align='center' class='noPrint'><a href='?part=currentRequests" + this.buildPeriodParameter() + "'>");
            this.writeln("<img src='?resource=hourglass.png' width='20' height='20' alt=\"#Voir_requetes_en_cours#\" /> #Voir_requetes_en_cours#</a>");
            this.writeln("</div><br/>");
        }
        if (Boolean.parseBoolean(Parameters.getParameter(Parameter.SYSTEM_ACTIONS_ENABLED))) {
            this.writeSystemActionsLinks();
        }
        new HtmlJavaInformationsReport(this.javaInformationsList, this.period, this.writer).toHtml();
        this.writeln("<h3 style='clear:both;'><img width='24' height='24' src='?resource=threads.png' alt='#Threads#'/>");
        this.writeln("#Threads#</h3>");
        this.writeThreads();
        if (this.isCacheEnabled()) {
            this.writeln("<h3><img width='24' height='24' src='?resource=caches.png' alt='#Caches#'/>");
            this.writeln("#Caches#</h3>");
            this.writeCaches();
        }
        this.writeMessageIfNotNull(message, null);
        this.writePoweredBy();
        long displayDuration = System.currentTimeMillis() - start;
        this.writeln("<div style='font-size:10pt;'>#temps_derniere_collecte#: " + this.collector.getLastCollectDuration() + " #ms#<br/>#temps_affichage#: " + displayDuration + " #ms#</div>");
        this.writeHtmlFooter();
    }

    private Map<String, HtmlCounterReport> writeCounters() throws IOException {
        HashMap<String, HtmlCounterReport> counterReportsByCounterName = new HashMap<String, HtmlCounterReport>();
        for (Counter counter : this.collector.getPeriodCountersToBeDisplayed(this.period)) {
            this.writeln("<h3><img width='24' height='24' src='?resource=" + counter.getIconName() + "' alt='" + counter.getName() + "'/>");
            String counterLabel = I18N.getString(counter.getName() + "Label");
            this.writeln(I18N.getFormattedString("Statistiques_compteur", counterLabel));
            this.writeln(" - " + this.period.getLabel() + "</h3>");
            HtmlCounterReport htmlCounterReport = new HtmlCounterReport(counter, this.period, this.writer);
            htmlCounterReport.toHtml();
            counterReportsByCounterName.put(counter.getName(), htmlCounterReport);
        }
        return counterReportsByCounterName;
    }

    static void writeAddAndRemoveApplicationLinks(String currentApplication, Period period, Writer writer) throws IOException {
        new HtmlAddAndRemoveApplications(writer).writeAddAndRemoveApplicationLinks(currentApplication, period);
    }

    void writeMessageIfNotNull(String message, String partToRedirectTo) throws IOException {
        if (message != null) {
            this.writeln(SCRIPT_BEGIN);
            this.writeln("alert(\"" + I18N.javascriptEncode(message) + "\");");
            if (partToRedirectTo == null) {
                this.writeln("location.href = '?period=" + this.period.getCode() + '\'');
            } else {
                this.writeln("location.href = '?part=" + partToRedirectTo + "&period=" + this.period.getCode() + '\'');
            }
            this.writeln(SCRIPT_END);
        }
    }

    private String buildPeriodParameter() {
        return "&amp;period=" + this.period.getCode();
    }

    private void writeGraphs() throws IOException {
        String periodParameter = this.buildPeriodParameter();
        for (JRobin jrobin : this.collector.getCounterJRobins()) {
            String jrobinName = jrobin.getName();
            if (jrobinName.endsWith("HitsRate")) {
                this.writeln("<br/>");
            }
            if (this.isJRobinDisplayed(jrobinName)) {
                this.writeln("<a href='?part=graph&amp;graph=" + jrobinName + periodParameter + "'><img class='synthese' src='?width=200&amp;height=" + 50 + "&amp;graph=" + jrobinName + periodParameter + "' alt=\"" + jrobin.getLabel() + "\" title=\"" + jrobin.getLabel() + "\"/></a>");
            }
            if (!"httpSessions".equals(jrobinName) && !"fileDescriptors".equals(jrobinName)) continue;
            this.writeln("<br/>");
        }
    }

    private void writeCurrentRequests(JavaInformations javaInformations, Map<String, HtmlCounterReport> counterReportsByCounterName) throws IOException {
        List<ThreadInformations> threadInformationsList = javaInformations.getThreadInformationsList();
        boolean stackTraceEnabled = javaInformations.isStackTraceEnabled();
        this.writeCurrentRequests(threadInformationsList, stackTraceEnabled, counterReportsByCounterName);
    }

    void writeCurrentRequests(List<ThreadInformations> threadInformationsList, boolean stackTraceEnabled, Map<String, HtmlCounterReport> counterReportsByCounterName) throws IOException {
        List<CounterRequestContext> rootCurrentContexts = this.collector.getRootCurrentContexts();
        if (rootCurrentContexts.isEmpty()) {
            this.writeln("#Aucune_requete_en_cours#");
        } else {
            new HtmlCounterRequestContextReport(rootCurrentContexts, counterReportsByCounterName, threadInformationsList, stackTraceEnabled, this.period, this.writer).toHtml();
        }
    }

    private void writeThreads() throws IOException {
        int i = 0;
        for (JavaInformations javaInformations : this.javaInformationsList) {
            this.writeln("<b>#Threads_sur# " + javaInformations.getHost() + ": </b>");
            this.writeln(I18N.getFormattedString("thread_count", javaInformations.getThreadCount(), javaInformations.getPeakThreadCount(), javaInformations.getTotalStartedThreadCount()));
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            String id = "threads_" + i;
            this.writeShowHideLink(id, "#Details#");
            HtmlThreadInformationsReport htmlThreadInformationsReport = new HtmlThreadInformationsReport(javaInformations.getThreadInformationsList(), javaInformations.isStackTraceEnabled(), this.writer);
            htmlThreadInformationsReport.writeDeadlocks();
            this.writeln("<br/><br/>");
            this.writeln("<div id='" + id + "' style='display: none;'>");
            htmlThreadInformationsReport.toHtml();
            this.writeln("</div><br/>");
            ++i;
        }
    }

    private boolean isDatabaseEnabled() {
        return !this.javaInformationsList.isEmpty() && this.javaInformationsList.get(0).getDataBaseVersion() != null && !this.javaInformationsList.get(0).getDataBaseVersion().contains("Exception");
    }

    private boolean doesWebXmlExists() {
        return !this.javaInformationsList.isEmpty() && this.javaInformationsList.get(0).doesWebXmlExists();
    }

    private boolean isCacheEnabled() {
        for (JavaInformations javaInformations : this.javaInformationsList) {
            if (!javaInformations.isCacheEnabled()) continue;
            return true;
        }
        return false;
    }

    private boolean isJRobinDisplayed(String jrobinName) {
        for (Counter counter : this.collector.getCounters()) {
            if (!jrobinName.startsWith(counter.getName())) continue;
            return counter.isDisplayed();
        }
        return true;
    }

    private void writeCaches() throws IOException {
        int i = 0;
        for (JavaInformations javaInformations : this.javaInformationsList) {
            if (!javaInformations.isCacheEnabled()) continue;
            List<CacheInformations> cacheInformationsList = javaInformations.getCacheInformationsList();
            this.writeln("<b>" + cacheInformationsList.size() + " #caches_sur# " + javaInformations.getHost() + "</b>");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            String id = "caches_" + i;
            this.writeShowHideLink(id, "#Details#");
            this.writeln("<br/><br/>");
            this.writeln("<div id='" + id + "' style='display: none;'>");
            new HtmlCacheInformationsReport(javaInformations.getCacheInformationsList(), this.writer).toHtml();
            this.writeln("</div><br/>");
            ++i;
        }
    }

    private void writeSystemActionsLinks() throws IOException {
        String periodParameter = this.buildPeriodParameter();
        this.writeln("<div align='center' class='noPrint'>");
        String separator = "&nbsp;&nbsp;&nbsp;&nbsp;";
        if (Action.GC_ENABLED || this.collectorServer) {
            this.writeln("<a href='?action=gc" + periodParameter + "' onclick=\"javascript:return confirm('" + I18N.getStringForJavascript("confirm_ramasse_miette") + "');\">");
            this.writeln("<img src='?resource=broom.png' width='20' height='20' alt='#ramasse_miette#' /> #ramasse_miette#</a>");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
        } else {
            this.writeln("<a href='_' onclick=\"javascript:alert('" + I18N.getStringForJavascript("ramasse_miette_desactive") + "');return false;\">");
            this.writeln("<img src='?resource=broom.png' width='20' height='20' alt='#ramasse_miette#' /> #ramasse_miette#</a>");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
        }
        if (Action.HEAP_DUMP_ENABLED || this.collectorServer) {
            this.writeln("<a href='?action=heap_dump" + periodParameter + "' onclick=\"javascript:return confirm('" + I18N.getStringForJavascript("confirm_heap_dump") + "');\">");
            this.writeln("<img src='?resource=heapdump.png' width='20' height='20' alt=\"#heap_dump#\" /> #heap_dump#</a>");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
        }
        this.writeln("<a href='?action=invalidate_sessions" + periodParameter + "' onclick=\"javascript:return confirm('" + I18N.getStringForJavascript("confirm_invalidate_sessions") + "');\">");
        this.writeln("<img src='?resource=user-trash.png' width='18' height='18' alt=\"#invalidate_sessions#\" /> #invalidate_sessions#</a>");
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeln("<a href='?part=sessions" + periodParameter + "'>");
        this.writeln("<img src='?resource=system-users.png' width='20' height='20' alt=\"#sessions#\" /> #sessions#</a>");
        this.writeln("<br />");
        if (this.collectorServer || VirtualMachine.isEnabled()) {
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
            this.writeln("<a href='?part=heaphisto" + periodParameter + "'>");
            this.writeln("<img src='?resource=memory.png' width='20' height='20' alt=\"#heaphisto#\" /> #heaphisto#</a>");
        }
        if (this.doesWebXmlExists()) {
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
            this.writeln("<a href='?part=web.xml" + periodParameter + "'>");
            this.writeln("<img src='?resource=xml.png' width='20' height='20' alt=\"#web.xml#\" /> #web.xml#</a>");
        }
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeln("<a href='?part=processes" + periodParameter + "'>");
        this.writeln("<img src='?resource=threads.png' width='20' height='20' alt=\"#processes#\" /> #processes#</a>");
        if (this.isDatabaseEnabled()) {
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
            this.writeln("<a href='?part=database" + periodParameter + "'>");
            this.writeln("<img src='?resource=db.png' width='20' height='20' alt=\"#database#\" /> #database#</a>");
        }
        this.writeln("<br/></div>");
    }

    private void writeApplicationsLinks(String periodParameter) throws IOException {
        Set<String> applications = Parameters.getCollectorUrlsByApplications().keySet();
        if (applications.size() > 1) {
            this.writeln("&nbsp;&nbsp;&nbsp;#Choix_application# :&nbsp;&nbsp;&nbsp;");
            for (String application : applications) {
                this.writeln("<a href='?application=" + application + periodParameter + "'>");
                this.writeln(application + "</a>&nbsp;&nbsp;&nbsp;");
            }
        }
    }

    private void writeRefreshAndPeriodLinks(String graphName) throws IOException {
        String start;
        this.writeln("<div class='noPrint'>");
        String separator = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        if (graphName == null) {
            start = "<a href='?period=";
        } else {
            this.writeln("<a href='javascript:history.back()'><img src='?resource=action_back.png' alt='#Retour#'/> #Retour#</a>");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            start = "<a href='?part=graph&amp;graph=" + graphName + "&amp;period=";
        }
        this.writeln(start + this.period.getCode() + "' title='#Rafraichir#'>");
        this.writeln("<img src='?resource=action_refresh.png' alt='#Actualiser#'/> #Actualiser#</a>");
        if (graphName == null && PDF_ENABLED) {
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            this.writeln(start + this.period.getCode() + "&amp;format=pdf' title='#afficher_PDF#'>");
            this.writeln("<img src='?resource=pdf.png' alt='#PDF#'/> #PDF#</a>");
        }
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeln("<a href='?resource=#help_url#' target='_blank'");
        this.writeln(" title=\"#Afficher_aide_en_ligne#\"><img src='?resource=action_help.png' alt='#Aide_en_ligne#'/> #Aide_en_ligne#</a>");
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeln("#Choix_periode# :&nbsp;&nbsp;&nbsp;");
        for (Period myPeriod : Period.values()) {
            this.writeln(start + myPeriod.getCode() + "' ");
            this.writeln("title='" + I18N.getFormattedString("Choisir_periode", myPeriod.getLinkLabel()) + "'>");
            this.writeln("<img src='?resource=" + myPeriod.getIconName() + "' alt='" + myPeriod.getLinkLabel() + "' /> ");
            this.writeln(myPeriod.getLinkLabel() + "</a>&nbsp;&nbsp;&nbsp;");
        }
        this.writeln("</div>");
    }

    void writeHtmlHeader(boolean includeSlider) throws IOException {
        this.writeln("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        this.writeln("<html><head><title>#Monitoring_sur# " + this.collector.getApplication() + "</title>");
        this.writeln("<link rel='stylesheet' href='?resource=monitoring.css' type='text/css'/>");
        this.writeln("<link type='image/png' rel='shortcut icon' href='?resource=systemmonitor.png' />");
        this.writeln("<script type='text/javascript' src='?resource=resizable_tables.js'></script>");
        this.writeln("<script type='text/javascript' src='?resource=sorttable.js'></script>");
        if (includeSlider) {
            this.writeln("<script type='text/javascript' src='?resource=prototype.js'></script>");
            this.writeln("<script type='text/javascript' src='?resource=slider.js'></script>");
        }
        this.writeJavaScript();
        this.writeln("</head><body>");
    }

    void writeHtmlFooter() throws IOException {
        String analyticsId = Parameters.getParameter(Parameter.ANALYTICS_ID);
        if (analyticsId != null) {
            this.writer.write(SCRIPT_BEGIN);
            this.writer.write("var gaJsHost = (('https:' == document.location.protocol) ? 'https://ssl.' : 'http://www.');\n");
            this.writer.write("document.write(unescape(\"%3Cscript src='\" + gaJsHost + \"google-analytics.com/ga.js' type='text/javascript'%3E%3C/script%3E\"));\n");
            this.writer.write(SCRIPT_END);
            this.writer.write(SCRIPT_BEGIN);
            this.writer.write(" try{\n");
            this.writer.write("var pageTracker = _gat._getTracker('" + analyticsId + "');\n");
            this.writer.write("pageTracker._trackPageview();\n");
            this.writer.write("} catch(err) {}\n");
            this.writer.write(SCRIPT_END);
            this.writer.write(10);
        }
        this.writeln("</body></html>");
    }

    private void writeJavaScript() throws IOException {
        this.writeln(SCRIPT_BEGIN);
        this.writeln("function showHide(id){");
        this.writeln("  if (document.getElementById(id).style.display=='none') {");
        this.writeln("    if (document.getElementById(id + 'Img') != null) {");
        this.writeln("      document.getElementById(id + 'Img').src='?resource=bullets/minus.png';");
        this.writeln("    }");
        this.writeln("    document.getElementById(id).style.display='inline';");
        this.writeln("  } else {");
        this.writeln("    if (document.getElementById(id + 'Img') != null) {");
        this.writeln("      document.getElementById(id + 'Img').src='?resource=bullets/plus.png';");
        this.writeln("    }");
        this.writeln("    document.getElementById(id).style.display='none';");
        this.writeln("  }");
        this.writeln("}");
        this.writeln(SCRIPT_END);
    }

    private void writePoweredBy() throws IOException {
        this.writeln("");
    }

    void writeRequestAndGraphDetail(String graphName) throws IOException {
        this.writeHtmlHeader(true);
        this.writeln("<div align='center'>");
        this.writeRefreshAndPeriodLinks(graphName);
        this.writeln("</div>");
        new HtmlCounterReport.HtmlCounterRequestGraphReport(this.period, this.writer).writeRequestAndGraphDetail(this.collector, graphName);
        this.writeHtmlFooter();
    }

    void writeSessions(List<SessionInformations> sessionsInformations, String message, String sessionsPart) throws IOException {
        assert (sessionsInformations != null);
        this.writeHtmlHeader(false);
        this.writeMessageIfNotNull(message, sessionsPart);
        new HtmlSessionInformationsReport(this.writer).toHtml(sessionsInformations);
        this.writeHtmlFooter();
    }

    void writeSessionDetail(String sessionId, SessionInformations sessionInformations) throws IOException {
        assert (sessionId != null);
        this.writeHtmlHeader(false);
        new HtmlSessionInformationsReport(this.writer).writeSessionDetails(sessionId, sessionInformations);
        this.writeHtmlFooter();
    }

    void writeHeapHistogram(HeapHistogram heapHistogram, String message, String heapHistoPart) throws IOException {
        assert (heapHistogram != null);
        this.writeHtmlHeader(false);
        this.writeMessageIfNotNull(message, heapHistoPart);
        new HtmlHeapHistogramReport(this.writer).toHtml(heapHistogram);
        this.writeHtmlFooter();
    }

    void writeProcesses(List<ProcessInformations> processInformationsList) throws IOException {
        assert (processInformationsList != null);
        this.writeHtmlHeader(false);
        new HtmlProcessInformationsReport(processInformationsList, this.writer).toHtml();
        this.writeHtmlFooter();
    }

    void writeDatabase(DatabaseInformations databaseInformations) throws IOException {
        assert (databaseInformations != null);
        this.writeHtmlHeader(false);
        new HtmlDatabaseInformationsReport(databaseInformations, this.writer).toHtml();
        this.writeHtmlFooter();
    }

    private void writeShowHideLink(String idToShow, String label) throws IOException {
        this.writeln("<a href=\"javascript:showHide('" + idToShow + "');\" class='noPrint'><img id='" + idToShow + "Img' src='?resource=bullets/plus.png' alt=''/> " + label + "</a>");
    }

    private void writeln(String html) throws IOException {
        I18N.writelnTo(html, this.writer);
    }

    private static class HtmlAddAndRemoveApplications {
        private final Writer writer;

        HtmlAddAndRemoveApplications(Writer writer) {
            this.writer = writer;
        }

        void writeAddAndRemoveApplicationLinks(String currentApplication, Period period) throws IOException {
            if (currentApplication == null) {
                this.writeln("<div align='center'><h3>#add_application#</h3>");
            } else {
                String separator = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
                this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                this.writeln("<a href=\"javascript:showHide('addApplication');document.appForm.appName.focus();\"");
                this.writeln(" class='noPrint'><img src='?resource=action_add.png' alt='#add_application#'/> #add_application#</a>");
                this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                this.writeln("<a href='?action=remove_application&amp;application=" + currentApplication + "&amp;period=" + period.getCode() + "' class='noPrint' ");
                String messageConfirmation = I18N.getFormattedString("confirm_remove_application", currentApplication);
                this.writeln("onclick=\"javascript:return confirm('" + I18N.javascriptEncode(messageConfirmation) + "');\">");
                String removeApplicationLabel = I18N.getFormattedString("remove_application", currentApplication);
                this.writeln("<img src='?resource=action_delete.png' alt=\"" + removeApplicationLabel + "\"/> " + removeApplicationLabel + "</a>");
                this.writeln("<div id='addApplication' style='display: none;'>");
            }
            this.writeln(HtmlReport.SCRIPT_BEGIN);
            this.writeln("function validateAppForm() {");
            this.writeln("   if (document.appForm.appName.value.length == 0) {");
            this.writeln("      alert('" + I18N.getStringForJavascript("app_name_mandatory") + "');");
            this.writeln("      document.appForm.appName.focus();");
            this.writeln("      return false;");
            this.writeln("   }");
            this.writeln("   if (document.appForm.appUrls.value.length == 0) {");
            this.writeln("      alert('" + I18N.getStringForJavascript("app_urls_mandatory") + "');");
            this.writeln("      document.appForm.appUrls.focus();");
            this.writeln("      return false;");
            this.writeln("   }");
            this.writeln("   return true;");
            this.writeln("}");
            this.writeln(HtmlReport.SCRIPT_END);
            this.writeln("<br/> <br/>");
            this.writeln("<form name='appForm' method='post' action='?period=" + period.getCode() + "' onsubmit='return validateAppForm();'>");
            this.writeln("<br/><b>#app_name_to_monitor# :</b>&nbsp;&nbsp;<input type='text' size='15' name='appName'/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            this.writeln("<b>#app_urls# :</b>&nbsp;&nbsp;<input type='text' size='50' name='appUrls'/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            this.writeln("<input type='submit' value='#add#'/><br/>");
            this.writeln("#urls_sample# : <i>http://myhost/myapp/</i> #or# <i>http://host1/myapp/,http://host2/myapp/</i>");
            this.writeln("<br/> <br/>");
            this.writeln("</form>");
            this.writeln("</div>\n");
        }

        private void writeln(String html) throws IOException {
            I18N.writelnTo(html, this.writer);
        }
    }
}

