/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.bull.javamelody.TransportFormat;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LabradorRetriever {
    private static final Logger LOGGER = Logger.getLogger((String)"javamelody");
    private static final int CONNECTION_TIMEOUT = 20000;
    private static final int READ_TIMEOUT = 60000;
    private final URL url;

    LabradorRetriever(URL url) {
        assert (url != null);
        this.url = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T call() throws IOException, ClassNotFoundException {
        long start = System.currentTimeMillis();
        try {
            URLConnection connection = LabradorRetriever.openConnection(this.url);
            connection.connect();
            Serializable result = LabradorRetriever.read(connection);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("lu sur " + this.url + " : " + result));
            }
            if (result instanceof RuntimeException) {
                throw (RuntimeException)result;
            }
            if (result instanceof Error) {
                throw (Error)result;
            }
            if (result instanceof IOException) {
                throw (IOException)result;
            }
            if (result instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)result;
            }
            if (result instanceof Exception) {
                Exception e = (Exception)result;
                IOException ex = new IOException(e.getMessage());
                ex.initCause(e);
                throw ex;
            }
            Serializable serializable = result;
            return (T)serializable;
        }
        finally {
            LOGGER.info((Object)("appel http effectu\u00e9 en " + (System.currentTimeMillis() - start) + " ms pour " + this.url));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyTo(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        assert (httpResponse != null);
        long start = System.currentTimeMillis();
        try {
            URLConnection connection = LabradorRetriever.openConnection(this.url);
            connection.setRequestProperty("Accept-Language", httpRequest.getHeader("Accept-Language"));
            connection.connect();
            try {
                InputStream input = connection.getInputStream();
                if ("gzip".equals(connection.getContentEncoding())) {
                    input = new GZIPInputStream(input);
                }
                httpResponse.setContentType(connection.getContentType());
                TransportFormat.pump(input, (OutputStream)httpResponse.getOutputStream());
            }
            finally {
                LabradorRetriever.close(connection);
            }
        }
        finally {
            LOGGER.info((Object)("r\u00e9cup\u00e9ration donn\u00e9es effectu\u00e9e en " + (System.currentTimeMillis() - start) + "ms pour " + this.url));
        }
    }

    private static URLConnection openConnection(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        connection.setConnectTimeout(20000);
        connection.setReadTimeout(60000);
        connection.setRequestProperty("Accept-Encoding", "gzip");
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Serializable read(URLConnection connection) throws IOException, ClassNotFoundException {
        InputStream input = connection.getInputStream();
        try {
            String contentType;
            if ("gzip".equals(connection.getContentEncoding())) {
                input = new GZIPInputStream(input);
            }
            TransportFormat transportFormat = (contentType = connection.getContentType()) != null && contentType.startsWith("text/xml") ? TransportFormat.XML : TransportFormat.SERIALIZED;
            Serializable serializable = transportFormat.readSerializableFrom(input);
            return serializable;
        }
        finally {
            LabradorRetriever.close(connection);
        }
    }

    private static void close(URLConnection connection) throws IOException {
        InputStream error;
        connection.getInputStream().close();
        if (connection instanceof HttpURLConnection && (error = ((HttpURLConnection)connection).getErrorStream()) != null) {
            error.close();
        }
    }
}

