/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.bull.javamelody.Collector;
import net.bull.javamelody.Counter;
import net.bull.javamelody.CounterError;
import net.bull.javamelody.CounterServletResponseWrapper;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.JdbcDriver;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.Log4JAppender;
import net.bull.javamelody.LoggingHandler;
import net.bull.javamelody.MailReport;
import net.bull.javamelody.MonitoringController;
import net.bull.javamelody.MonitoringInitialContextFactory;
import net.bull.javamelody.MonitoringInterceptor;
import net.bull.javamelody.MonitoringProxy;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.ThreadInformations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitoringFilter
implements Filter {
    private Collector collector;
    private Counter httpCounter;
    private Counter errorCounter;
    private boolean monitoringDisabled;
    private boolean logEnabled;
    private boolean log4jEnabled;
    private boolean contextFactoryEnabled;
    private Pattern urlExcludePattern;
    private Pattern allowedAddrPattern;
    private FilterConfig filterConfig;
    private String monitoringUrl;
    private Timer timer;

    public void init(FilterConfig config) throws ServletException {
        this.filterConfig = config;
        Parameters.initialize(config);
        this.monitoringDisabled = Boolean.parseBoolean(Parameters.getParameter(Parameter.DISABLED));
        if (this.monitoringDisabled) {
            return;
        }
        this.timer = new Timer("javamelody" + Parameters.getContextPath(config.getServletContext()).replace('/', ' '), true);
        this.logEnabled = Boolean.parseBoolean(Parameters.getParameter(Parameter.LOG));
        LoggingHandler.getSingleton().register();
        try {
            Class.forName("org.apache.log4j.Logger");
            this.log4jEnabled = true;
            Log4JAppender.getSingleton().register();
        }
        catch (ClassNotFoundException e) {
            this.log4jEnabled = false;
        }
        boolean bl = this.contextFactoryEnabled = !this.monitoringDisabled && Boolean.parseBoolean(Parameters.getParameter(Parameter.CONTEXT_FACTORY_ENABLED));
        if (this.contextFactoryEnabled) {
            MonitoringInitialContextFactory.init();
        }
        JdbcWrapper jdbcWrapper = JdbcDriver.SINGLETON.getJdbcWrapper();
        Counter sqlCounter = jdbcWrapper.getSqlCounter();
        jdbcWrapper.initServletContext(config.getServletContext());
        jdbcWrapper.rebindDataSources();
        this.httpCounter = new Counter("http", "dbweb.png", sqlCounter);
        this.errorCounter = new Counter("error", "error.png");
        this.errorCounter.setMaxRequestsCount(250);
        String application = Parameters.getCurrentApplication();
        Counter ejbCounter = MonitoringInterceptor.getEjbCounter();
        Counter springCounter = MonitoringInterceptor.getSpringCounter();
        Counter servicesCounter = MonitoringProxy.getServicesCounter();
        Counter logCounter = LoggingHandler.getLogCounter();
        List<Counter> counters = Arrays.asList(this.httpCounter, sqlCounter, ejbCounter, springCounter, servicesCounter, this.errorCounter, logCounter);
        MonitoringFilter.setRequestTransformPatterns(counters);
        String displayedCounters = Parameters.getParameter(Parameter.DISPLAYED_COUNTERS);
        if (displayedCounters == null) {
            this.httpCounter.setDisplayed(true);
            sqlCounter.setDisplayed(true);
            this.errorCounter.setDisplayed(true);
            logCounter.setDisplayed(true);
            ejbCounter.setDisplayed(false);
            springCounter.setDisplayed(false);
            servicesCounter.setDisplayed(false);
        } else {
            MonitoringFilter.setDisplayedCounters(counters, displayedCounters);
        }
        this.collector = new Collector(application, counters, this.timer);
        if (Parameters.getParameter(Parameter.URL_EXCLUDE_PATTERN) != null) {
            this.urlExcludePattern = Pattern.compile(Parameters.getParameter(Parameter.URL_EXCLUDE_PATTERN));
        }
        if (Parameters.getParameter(Parameter.ALLOWED_ADDR_PATTERN) != null) {
            this.allowedAddrPattern = Pattern.compile(Parameters.getParameter(Parameter.ALLOWED_ADDR_PATTERN));
        }
        this.initCollect();
    }

    private static void setRequestTransformPatterns(List<Counter> counters) {
        for (Counter counter : counters) {
            Parameter parameter = Parameter.valueOfIgnoreCase(counter.getName() + "_TRANSFORM_PATTERN");
            if (Parameters.getParameter(parameter) == null) continue;
            Pattern pattern = Pattern.compile(Parameters.getParameter(parameter));
            counter.setRequestTransformPattern(pattern);
        }
    }

    private static void setDisplayedCounters(List<Counter> counters, String displayedCounters) {
        for (Counter counter : counters) {
            counter.setDisplayed(false);
        }
        block1: for (String displayedCounter : displayedCounters.split(",")) {
            String displayedCounterName = displayedCounter.trim();
            for (Counter counter : counters) {
                if (!displayedCounterName.equalsIgnoreCase(counter.getName())) continue;
                counter.setDisplayed(true);
                continue block1;
            }
        }
    }

    private void initCollect() {
        try {
            Class.forName("org.jrobin.core.RrdDb");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        int periodMillis = Parameters.getResolutionSeconds() * 1000;
        CollectTimerTask task = new CollectTimerTask(this.collector);
        this.timer.schedule((TimerTask)task, periodMillis, (long)periodMillis);
        this.collector.collectLocalContextWithoutErrors();
        if (Parameters.getParameter(Parameter.MAIL_SESSION) != null && Parameters.getParameter(Parameter.ADMIN_EMAILS) != null) {
            MailReport.scheduleReportMailForLocalServer(this.collector, this.timer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        block13: {
            if (this.monitoringDisabled) {
                return;
            }
            try {
                try {
                    if (this.collector != null) {
                        new MonitoringController(this.collector, false).writeHtmlToLastShutdownFile();
                    }
                    Object var2_1 = null;
                    JdbcDriver.SINGLETON.getJdbcWrapper().stop();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    JdbcDriver.SINGLETON.getJdbcWrapper().stop();
                    JdbcDriver.SINGLETON.deregister();
                    if (this.log4jEnabled) {
                        Log4JAppender.getSingleton().deregister();
                    }
                    LoggingHandler.getSingleton().deregister();
                    throw throwable;
                }
                JdbcDriver.SINGLETON.deregister();
                if (this.log4jEnabled) {
                    Log4JAppender.getSingleton().deregister();
                }
                LoggingHandler.getSingleton().deregister();
                Object var4_4 = null;
                if (!this.contextFactoryEnabled) break block13;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (this.contextFactoryEnabled) {
                    MonitoringInitialContextFactory.stop();
                }
                if (this.timer != null) {
                    this.timer.cancel();
                }
                if (this.collector != null) {
                    this.collector.stop();
                }
                Collector.stopJRobin();
                Collector.detachVirtualMachine();
                this.collector = null;
                this.httpCounter = null;
                this.errorCounter = null;
                this.urlExcludePattern = null;
                this.allowedAddrPattern = null;
                this.filterConfig = null;
                this.timer = null;
                throw throwable;
            }
            MonitoringInitialContextFactory.stop();
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (this.collector != null) {
            this.collector.stop();
        }
        Collector.stopJRobin();
        Collector.detachVirtualMachine();
        this.collector = null;
        this.httpCounter = null;
        this.errorCounter = null;
        this.urlExcludePattern = null;
        this.allowedAddrPattern = null;
        this.filterConfig = null;
        this.timer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse) || this.isHttpMonitoringDisabled()) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (this.isRequestExcluded(httpRequest)) {
            chain.doFilter(request, response);
            return;
        }
        if (httpRequest.getRequestURI().equals(this.getMonitoringUrl(httpRequest))) {
            this.doMonitoring(httpRequest, httpResponse);
            return;
        }
        CounterServletResponseWrapper wrappedResponse = new CounterServletResponseWrapper(httpResponse);
        long start = System.currentTimeMillis();
        long startCpuTime = ThreadInformations.getCurrentThreadCpuTime();
        boolean systemError = false;
        Throwable systemException = null;
        try {
            try {
                JdbcWrapper.ACTIVE_THREAD_COUNT.incrementAndGet();
                String requestName = MonitoringFilter.getCompleteRequestName(httpRequest, false);
                String completeRequestName = MonitoringFilter.getCompleteRequestName(httpRequest, true);
                this.httpCounter.bindContext(requestName, completeRequestName, httpRequest.getRemoteUser(), startCpuTime);
                httpRequest.setAttribute("javamelody.request", (Object)completeRequestName);
                CounterError.bindRequest(httpRequest);
                chain.doFilter(request, (ServletResponse)wrappedResponse);
                wrappedResponse.flushBuffer();
            }
            catch (Throwable t) {
                systemException = t;
                MonitoringFilter.throwException(t);
                Object var16_15 = null;
                try {}
                catch (Throwable throwable) {
                    Object var24_35 = null;
                    this.httpCounter.unbindContext();
                    CounterError.unbindRequest();
                    throw throwable;
                }
                long duration = Math.max(System.currentTimeMillis() - start, 0L);
                long cpuUsedMillis = (ThreadInformations.getCurrentThreadCpuTime() - startCpuTime) / 1000000L;
                JdbcWrapper.ACTIVE_THREAD_COUNT.decrementAndGet();
                this.putUserInfoInSession(httpRequest);
                if (systemException != null) {
                    systemError = true;
                    StringWriter stackTrace = new StringWriter(200);
                    systemException.printStackTrace(new PrintWriter(stackTrace));
                    this.errorCounter.addRequestForSystemError(systemException.toString(), duration, cpuUsedMillis, stackTrace.toString());
                } else if (wrappedResponse.getStatus() >= 400) {
                    systemError = true;
                    this.errorCounter.addRequestForSystemError("Error" + wrappedResponse.getStatus(), duration, cpuUsedMillis, null);
                }
                int responseSize = wrappedResponse.getDataLength();
                String requestName2 = MonitoringFilter.getRequestName(httpRequest, wrappedResponse);
                this.httpCounter.addRequest(requestName2, duration, cpuUsedMillis, systemError, responseSize);
                this.log(httpRequest, requestName2, duration, systemError, responseSize);
                Object var24_34 = null;
                this.httpCounter.unbindContext();
                CounterError.unbindRequest();
                return;
            }
            Object var16_14 = null;
            try {
                long duration = Math.max(System.currentTimeMillis() - start, 0L);
                long cpuUsedMillis = (ThreadInformations.getCurrentThreadCpuTime() - startCpuTime) / 1000000L;
                JdbcWrapper.ACTIVE_THREAD_COUNT.decrementAndGet();
                this.putUserInfoInSession(httpRequest);
                if (systemException != null) {
                    systemError = true;
                    StringWriter stackTrace = new StringWriter(200);
                    systemException.printStackTrace(new PrintWriter(stackTrace));
                    this.errorCounter.addRequestForSystemError(systemException.toString(), duration, cpuUsedMillis, stackTrace.toString());
                } else if (wrappedResponse.getStatus() >= 400) {
                    systemError = true;
                    this.errorCounter.addRequestForSystemError("Error" + wrappedResponse.getStatus(), duration, cpuUsedMillis, null);
                }
                int responseSize = wrappedResponse.getDataLength();
                String requestName2 = MonitoringFilter.getRequestName(httpRequest, wrappedResponse);
                this.httpCounter.addRequest(requestName2, duration, cpuUsedMillis, systemError, responseSize);
                this.log(httpRequest, requestName2, duration, systemError, responseSize);
                Object var24_32 = null;
                this.httpCounter.unbindContext();
                CounterError.unbindRequest();
                return;
            }
            catch (Throwable throwable) {
                Object var24_33 = null;
                this.httpCounter.unbindContext();
                CounterError.unbindRequest();
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            try {}
            catch (Throwable throwable2) {
                Object var24_37 = null;
                this.httpCounter.unbindContext();
                CounterError.unbindRequest();
                throw throwable2;
            }
            long duration = Math.max(System.currentTimeMillis() - start, 0L);
            long cpuUsedMillis = (ThreadInformations.getCurrentThreadCpuTime() - startCpuTime) / 1000000L;
            JdbcWrapper.ACTIVE_THREAD_COUNT.decrementAndGet();
            this.putUserInfoInSession(httpRequest);
            if (systemException != null) {
                systemError = true;
                StringWriter stackTrace = new StringWriter(200);
                systemException.printStackTrace(new PrintWriter(stackTrace));
                this.errorCounter.addRequestForSystemError(systemException.toString(), duration, cpuUsedMillis, stackTrace.toString());
            } else if (wrappedResponse.getStatus() >= 400) {
                systemError = true;
                this.errorCounter.addRequestForSystemError("Error" + wrappedResponse.getStatus(), duration, cpuUsedMillis, null);
            }
            int responseSize = wrappedResponse.getDataLength();
            String requestName2 = MonitoringFilter.getRequestName(httpRequest, wrappedResponse);
            this.httpCounter.addRequest(requestName2, duration, cpuUsedMillis, systemError, responseSize);
            this.log(httpRequest, requestName2, duration, systemError, responseSize);
            Object var24_36 = null;
            this.httpCounter.unbindContext();
            CounterError.unbindRequest();
            throw throwable;
        }
    }

    private String getMonitoringUrl(HttpServletRequest httpRequest) {
        if (this.monitoringUrl == null) {
            this.monitoringUrl = httpRequest.getContextPath() + "/monitoring";
        }
        return this.monitoringUrl;
    }

    private void putUserInfoInSession(HttpServletRequest httpRequest) {
        String remoteUser;
        HttpSession session = httpRequest.getSession(false);
        if (session == null) {
            return;
        }
        if (session.getAttribute("javamelody.country") == null) {
            Locale locale = httpRequest.getLocale();
            if (locale.getCountry().length() > 0) {
                session.setAttribute("javamelody.country", (Object)locale.getCountry());
            } else {
                session.setAttribute("javamelody.country", (Object)locale.getLanguage());
            }
        }
        if (session.getAttribute("javamelody.remoteAddr") == null) {
            session.setAttribute("javamelody.remoteAddr", (Object)httpRequest.getRemoteAddr());
        }
        if (session.getAttribute("javamelody.remoteUser") == null && (remoteUser = httpRequest.getRemoteUser()) != null) {
            session.setAttribute("javamelody.remoteUser", (Object)remoteUser);
        }
    }

    private void doMonitoring(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        if (this.isRequestNotAllowed(httpRequest)) {
            httpResponse.sendError(403, "Acc\u00e8s interdit");
            return;
        }
        MonitoringController monitoringController = new MonitoringController(this.collector, false);
        monitoringController.executeActionIfNeeded(httpRequest);
        JavaInformations javaInformations = monitoringController.isJavaInformationsNeeded(httpRequest) ? new JavaInformations(this.filterConfig.getServletContext(), true) : null;
        monitoringController.doReport(httpRequest, httpResponse, Collections.singletonList(javaInformations));
    }

    private static String getCompleteRequestName(HttpServletRequest httpRequest, boolean includeQueryString) {
        String tmp = httpRequest.getRequestURI().substring(httpRequest.getContextPath().length());
        if (!includeQueryString) {
            return tmp + ' ' + httpRequest.getMethod();
        }
        String queryString = httpRequest.getQueryString();
        if (queryString == null) {
            return tmp + ' ' + httpRequest.getMethod();
        }
        return tmp + '?' + queryString + ' ' + httpRequest.getMethod();
    }

    private static String getRequestName(HttpServletRequest httpRequest, CounterServletResponseWrapper wrappedResponse) {
        if (wrappedResponse.getStatus() != 404) {
            return MonitoringFilter.getCompleteRequestName(httpRequest, false);
        }
        String requestName = "Error404";
        return requestName;
    }

    private boolean isHttpMonitoringDisabled() {
        return this.monitoringDisabled || !this.httpCounter.isDisplayed();
    }

    private boolean isRequestExcluded(HttpServletRequest httpRequest) {
        return this.urlExcludePattern != null && this.urlExcludePattern.matcher(httpRequest.getRequestURI().substring(httpRequest.getContextPath().length())).matches();
    }

    private boolean isRequestNotAllowed(HttpServletRequest httpRequest) {
        return this.allowedAddrPattern != null && !this.allowedAddrPattern.matcher(httpRequest.getRemoteAddr()).matches();
    }

    protected void log(HttpServletRequest httpRequest, String requestName, long duration, boolean systemError, int responseSize) {
        if (!this.logEnabled) {
            return;
        }
        String filterName = this.filterConfig.getFilterName();
        if (this.log4jEnabled) {
            MonitoringFilter.log4j(httpRequest, duration, systemError, responseSize, filterName);
        } else {
            Logger logger = Logger.getLogger(filterName);
            if (logger.isLoggable(Level.INFO)) {
                logger.info(MonitoringFilter.buildLogMessage(httpRequest, duration, systemError, responseSize));
            }
        }
    }

    private static void log4j(HttpServletRequest httpRequest, long duration, boolean systemError, int responseSize, String filterName) {
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)filterName);
        if (logger.isInfoEnabled()) {
            logger.info((Object)MonitoringFilter.buildLogMessage(httpRequest, duration, systemError, responseSize));
        }
    }

    private static String buildLogMessage(HttpServletRequest httpRequest, long duration, boolean systemError, int responseSize) {
        StringBuilder msg = new StringBuilder();
        msg.append("remoteAddr = ").append(httpRequest.getRemoteAddr());
        msg.append(", request = ").append(httpRequest.getRequestURI().substring(httpRequest.getContextPath().length()));
        if (httpRequest.getQueryString() != null) {
            msg.append('?').append(httpRequest.getQueryString());
        }
        msg.append(' ').append(httpRequest.getMethod());
        msg.append(": ").append(duration).append(" ms");
        if (systemError) {
            msg.append(", erreur");
        }
        msg.append(", ").append(responseSize / 1024).append(" Ko");
        return msg.toString();
    }

    private static void throwException(Throwable t) throws IOException, ServletException {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (t instanceof ServletException) {
            throw (ServletException)t;
        }
        throw new ServletException(t.getMessage(), t);
    }

    private static final class CollectTimerTask
    extends TimerTask {
        private final Collector collector;

        CollectTimerTask(Collector collector) {
            this.collector = collector;
        }

        public void run() {
            this.collector.collectLocalContextWithoutErrors();
        }
    }
}

