/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import net.bull.javamelody.JdbcDriver;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.SessionInformations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionListener
implements HttpSessionListener,
HttpSessionActivationListener,
ServletContextListener,
Serializable {
    private static final String SESSION_ACTIVATION_KEY = "javamelody.sessionActivation";
    private static final long serialVersionUID = -1624944319058843901L;
    private static final AtomicInteger SESSION_COUNT = new AtomicInteger();
    private static final ConcurrentMap<String, HttpSession> SESSION_MAP_BY_ID = new ConcurrentHashMap<String, HttpSession>();

    static int getSessionCount() {
        return SESSION_COUNT.get();
    }

    static void invalidateAllSessions() {
        for (HttpSession session : SESSION_MAP_BY_ID.values()) {
            session.invalidate();
        }
    }

    static void invalidateSession(String sessionId) {
        HttpSession session = (HttpSession)SESSION_MAP_BY_ID.get(sessionId);
        if (session != null) {
            session.invalidate();
        }
    }

    static List<SessionInformations> getAllSessionsInformations() {
        Collection sessions = SESSION_MAP_BY_ID.values();
        ArrayList<SessionInformations> sessionsInformations = new ArrayList<SessionInformations>(sessions.size());
        for (HttpSession session : SESSION_MAP_BY_ID.values()) {
            sessionsInformations.add(new SessionInformations(session, false));
        }
        SessionListener.sortSessions(sessionsInformations);
        return Collections.unmodifiableList(sessionsInformations);
    }

    static List<SessionInformations> sortSessions(List<SessionInformations> sessionsInformations) {
        if (sessionsInformations.size() > 1) {
            Collections.sort(sessionsInformations, Collections.reverseOrder(new SessionInformationsComparator()));
        }
        return sessionsInformations;
    }

    static SessionInformations getSessionInformationsBySessionId(String sessionId) {
        HttpSession session = (HttpSession)SESSION_MAP_BY_ID.get(sessionId);
        if (session == null) {
            return null;
        }
        return new SessionInformations(session, true);
    }

    public void contextInitialized(ServletContextEvent event) {
        Parameters.initialize(event.getServletContext());
        JdbcWrapper jdbcWrapper = JdbcDriver.SINGLETON.getJdbcWrapper();
        jdbcWrapper.initServletContext(event.getServletContext());
        jdbcWrapper.rebindDataSources();
    }

    public void contextDestroyed(ServletContextEvent event) {
        SESSION_MAP_BY_ID.clear();
        SESSION_COUNT.set(0);
    }

    public void sessionCreated(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        session.setAttribute(SESSION_ACTIVATION_KEY, (Object)this);
        SESSION_COUNT.incrementAndGet();
        SESSION_MAP_BY_ID.put(session.getId(), session);
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        session.removeAttribute(SESSION_ACTIVATION_KEY);
        SESSION_COUNT.decrementAndGet();
        SESSION_MAP_BY_ID.remove(session.getId());
    }

    public void sessionDidActivate(HttpSessionEvent event) {
        SESSION_COUNT.incrementAndGet();
        SESSION_MAP_BY_ID.put(event.getSession().getId(), event.getSession());
    }

    public void sessionWillPassivate(HttpSessionEvent event) {
        SESSION_COUNT.decrementAndGet();
        SESSION_MAP_BY_ID.remove(event.getSession().getId());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[sessionCount=" + SessionListener.getSessionCount() + ']';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class SessionInformationsComparator
    implements Comparator<SessionInformations>,
    Serializable {
        private static final long serialVersionUID = 1L;

        SessionInformationsComparator() {
        }

        @Override
        public int compare(SessionInformations session1, SessionInformations session2) {
            if (session1.getLastAccess().before(session2.getLastAccess())) {
                return 1;
            }
            if (session1.getLastAccess().after(session2.getLastAccess())) {
                return -1;
            }
            return 0;
        }
    }
}

