/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.util.ArrayList;
import net.bull.javamelody.SpringRestTemplateInterceptor;
import net.bull.javamelody.internal.common.LOG;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.PriorityOrdered;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.web.client.RestTemplate;

public class SpringRestTemplateBeanPostProcessor
implements BeanPostProcessor,
PriorityOrdered {
    private static final boolean REST_TEMPLATE_INTERCEPTOR_AVAILABLE = SpringRestTemplateBeanPostProcessor.isRestTemplateInterceptorAvailable();
    private int order = Integer.MAX_VALUE;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (REST_TEMPLATE_INTERCEPTOR_AVAILABLE && bean instanceof RestTemplate) {
            RestTemplate restTemplate = (RestTemplate)bean;
            ArrayList<ClientHttpRequestInterceptor> interceptors = new ArrayList<ClientHttpRequestInterceptor>(restTemplate.getInterceptors());
            for (ClientHttpRequestInterceptor interceptor : interceptors) {
                if (!(interceptor instanceof SpringRestTemplateInterceptor)) continue;
                return bean;
            }
            interceptors.add(SpringRestTemplateInterceptor.SINGLETON);
            restTemplate.setInterceptors(interceptors);
            LOG.debug("rest template interceptor initialized");
        }
        return bean;
    }

    private static boolean isRestTemplateInterceptorAvailable() {
        try {
            Class<?> clazz = Class.forName("org.springframework.web.client.RestTemplate");
            clazz.getMethod("getInterceptors", new Class[0]);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }
}

