/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

abstract class FilterServletResponseWrapper
extends HttpServletResponseWrapper {
    private ServletOutputStream stream;
    private PrintWriter writer;
    private int status;

    FilterServletResponseWrapper(HttpServletResponse response) {
        super(response);
        assert (response != null);
    }

    HttpServletResponse getHttpServletResponse() {
        return (HttpServletResponse)this.getResponse();
    }

    ServletOutputStream getStream() {
        return this.stream;
    }

    public void reset() {
        super.reset();
        this.status = 0;
        this.stream = null;
        this.writer = null;
    }

    public int getCurrentStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        super.setStatus(status);
        this.status = status;
    }

    public void sendError(int error) throws IOException {
        super.sendError(error);
        this.status = error;
    }

    public void sendError(int error, String message) throws IOException {
        super.sendError(error, message);
        this.status = error;
    }

    protected abstract ServletOutputStream createOutputStream() throws IOException;

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("getWriter() has already been called for this response");
        }
        if (this.stream == null) {
            this.stream = this.createOutputStream();
            assert (this.stream != null);
        }
        return this.stream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            if (this.stream != null) {
                throw new IllegalStateException("getOutputStream() has already been called for this response");
            }
            try {
                this.getOutputStream();
            }
            catch (IllegalStateException e) {
                this.writer = super.getWriter();
                return this.writer;
            }
            ServletOutputStream outputStream = this.getOutputStream();
            String charEnc = this.getHttpServletResponse().getCharacterEncoding();
            PrintWriter result = charEnc == null ? new PrintWriter((OutputStream)outputStream) : new PrintWriter(new OutputStreamWriter((OutputStream)outputStream, charEnc));
            this.writer = result;
        }
        return this.writer;
    }

    public void flushBuffer() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        } else if (this.stream != null) {
            this.stream.flush();
        } else {
            super.flushBuffer();
        }
    }

    public void flushStream() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        } else if (this.stream != null) {
            this.stream.flush();
        }
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        } else if (this.stream != null) {
            this.stream.close();
        }
    }
}

