/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.SessionListener;
import net.bull.javamelody.internal.common.HttpParameter;
import net.bull.javamelody.internal.common.HttpPart;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.common.LOG;
import net.bull.javamelody.internal.common.Parameters;
import net.bull.javamelody.internal.model.Action;
import net.bull.javamelody.internal.model.CacheInformations;
import net.bull.javamelody.internal.model.Collector;
import net.bull.javamelody.internal.model.CollectorServer;
import net.bull.javamelody.internal.model.DatabaseInformations;
import net.bull.javamelody.internal.model.HeapHistogram;
import net.bull.javamelody.internal.model.JCacheInformations;
import net.bull.javamelody.internal.model.JavaInformations;
import net.bull.javamelody.internal.model.JndiBinding;
import net.bull.javamelody.internal.model.MBeanNode;
import net.bull.javamelody.internal.model.MBeans;
import net.bull.javamelody.internal.model.Period;
import net.bull.javamelody.internal.model.ProcessInformations;
import net.bull.javamelody.internal.model.Range;
import net.bull.javamelody.internal.model.SamplingProfiler;
import net.bull.javamelody.internal.model.SessionInformations;
import net.bull.javamelody.internal.model.VirtualMachine;
import net.bull.javamelody.internal.web.HttpCookieManager;
import net.bull.javamelody.internal.web.RequestToMethodMapper;
import net.bull.javamelody.internal.web.html.HtmlReport;

public class HtmlController {
    static final String HTML_BODY_FORMAT = "htmlbody";
    private static final String X_FRAME_OPTIONS = Parameter.X_FRAME_OPTIONS.getValue();
    private static final RequestToMethodMapper<HtmlController> REQUEST_TO_METHOD_MAPPER = new RequestToMethodMapper<HtmlController>(HtmlController.class);
    private final HttpCookieManager httpCookieManager = new HttpCookieManager();
    private final Collector collector;
    private final CollectorServer collectorServer;
    private final String messageForReport;
    private final String anchorNameForRedirect;
    private HtmlReport htmlReport;

    HtmlController(Collector collector, CollectorServer collectorServer, String messageForReport, String anchorNameForRedirect) {
        assert (collector != null);
        this.collector = collector;
        this.collectorServer = collectorServer;
        this.messageForReport = messageForReport;
        this.anchorNameForRedirect = anchorNameForRedirect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doHtml(HttpServletRequest httpRequest, HttpServletResponse httpResponse, List<JavaInformations> javaInformationsList) throws IOException {
        String part = HttpParameter.PART.getParameterFrom(httpRequest);
        if (!this.isFromCollectorServer() && HtmlController.isLocalCollectNeeded(part) && !this.collector.isStopped()) {
            this.collector.collectLocalContextWithoutErrors();
        }
        BufferedWriter writer = HtmlController.getWriter(httpResponse);
        try {
            Range range = this.httpCookieManager.getRange(httpRequest, httpResponse);
            this.htmlReport = new HtmlReport(this.collector, this.collectorServer, javaInformationsList, range, (Writer)writer);
            if (part == null) {
                this.htmlReport.toHtml(this.messageForReport, this.anchorNameForRedirect);
            } else if (HttpPart.THREADS_DUMP.isPart(httpRequest)) {
                httpResponse.setContentType("text/plain; charset=UTF-8");
                this.htmlReport.writeThreadsDump();
            } else {
                REQUEST_TO_METHOD_MAPPER.invoke(httpRequest, this);
            }
        }
        finally {
            writer.close();
        }
    }

    static boolean isLocalCollectNeeded(String part) {
        return part == null || HttpPart.CURRENT_REQUESTS.getName().equals(part) || HttpPart.GRAPH.getName().equals(part) || HttpPart.COUNTER_SUMMARY_PER_CLASS.getName().equals(part);
    }

    public static BufferedWriter getWriter(HttpServletResponse httpResponse) throws IOException {
        httpResponse.setContentType("text/html; charset=UTF-8");
        if (X_FRAME_OPTIONS == null) {
            httpResponse.setHeader("X-Frame-Options", "SAMEORIGIN");
        } else if (!"ALLOWALL".equals(X_FRAME_OPTIONS)) {
            httpResponse.setHeader("X-Frame-Options", X_FRAME_OPTIONS);
        }
        try {
            return new BufferedWriter(new OutputStreamWriter((OutputStream)httpResponse.getOutputStream(), "UTF-8"));
        }
        catch (IllegalStateException e) {
            return new BufferedWriter(httpResponse.getWriter());
        }
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.GRAPH)
    void doRequestGraphAndDetail(@RequestToMethodMapper.RequestParameter(value=HttpParameter.GRAPH) String graphName) throws IOException {
        this.htmlReport.writeRequestAndGraphDetail(graphName);
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.USAGES)
    void doRequestUsages(@RequestToMethodMapper.RequestParameter(value=HttpParameter.GRAPH) String graphName) throws IOException {
        this.htmlReport.writeRequestUsages(graphName);
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.CURRENT_REQUESTS)
    void doAllCurrentRequestsAsPart() throws IOException {
        this.htmlReport.writeAllCurrentRequestsAsPart();
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.THREADS)
    void doAllThreadsAsPart() throws IOException {
        this.htmlReport.writeAllThreadsAsPart();
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.COUNTER_SUMMARY_PER_CLASS)
    void doCounterSummaryPerClass(@RequestToMethodMapper.RequestParameter(value=HttpParameter.COUNTER) String counterName, @RequestToMethodMapper.RequestParameter(value=HttpParameter.GRAPH) String requestId) throws IOException {
        this.htmlReport.writeCounterSummaryPerClass(counterName, requestId);
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.SOURCE)
    void doSource(@RequestToMethodMapper.RequestParameter(value=HttpParameter.CLASS) String className) throws IOException {
        this.htmlReport.writeSource(className);
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.DEPENDENCIES)
    void doDependencies() throws IOException {
        this.htmlReport.writeDependencies();
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.SESSIONS)
    void doSessions(@RequestToMethodMapper.RequestParameter(value=HttpParameter.SESSION_ID) String sessionId) throws IOException {
        Action.checkSystemActionsEnabled();
        List<SessionInformations> sessionsInformations = !this.isFromCollectorServer() ? (sessionId == null ? SessionListener.getAllSessionsInformations() : Collections.singletonList(SessionListener.getSessionInformationsBySessionId(sessionId))) : this.collectorServer.collectSessionInformations(this.getApplication(), sessionId);
        if (sessionId == null || sessionsInformations.isEmpty()) {
            this.htmlReport.writeSessions(sessionsInformations, this.messageForReport, HttpPart.SESSIONS.getName());
        } else {
            SessionInformations sessionInformation = sessionsInformations.get(0);
            this.htmlReport.writeSessionDetail(sessionId, sessionInformation);
        }
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.HOTSPOTS)
    void doHotspots() throws IOException {
        Action.checkSystemActionsEnabled();
        if (!this.isFromCollectorServer()) {
            List<SamplingProfiler.SampledMethod> hotspots = this.collector.getHotspots();
            this.htmlReport.writeHotspots(hotspots);
        } else {
            List<SamplingProfiler.SampledMethod> hotspots = this.collectorServer.collectHotspots(this.getApplication());
            this.htmlReport.writeHotspots(hotspots);
        }
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.HEAP_HISTO)
    void doHeapHisto() throws IOException {
        HeapHistogram heapHistogram;
        Action.checkSystemActionsEnabled();
        try {
            heapHistogram = !this.isFromCollectorServer() ? VirtualMachine.createHeapHistogram() : this.collectorServer.collectHeapHistogram(this.getApplication());
        }
        catch (Exception e) {
            LOG.warn("heaphisto report failed", e);
            this.htmlReport.writeMessageIfNotNull(String.valueOf(e.getMessage()), null);
            return;
        }
        this.htmlReport.writeHeapHistogram(heapHistogram, this.messageForReport, HttpPart.HEAP_HISTO.getName());
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.PROCESSES)
    void doProcesses() throws IOException {
        Action.checkSystemActionsEnabled();
        try {
            if (!this.isFromCollectorServer()) {
                List<ProcessInformations> processInformationsList = ProcessInformations.buildProcessInformations();
                this.htmlReport.writeProcesses(processInformationsList);
            } else {
                Map<String, List<ProcessInformations>> processInformationsByTitle = this.collectorServer.collectProcessInformations(this.getApplication());
                this.htmlReport.writeProcesses(processInformationsByTitle);
            }
        }
        catch (Exception e) {
            LOG.warn("processes report failed", e);
            this.htmlReport.writeMessageIfNotNull(String.valueOf(e.getMessage()), null);
        }
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.DATABASE)
    void doDatabase(@RequestToMethodMapper.RequestParameter(value=HttpParameter.REQUEST) String requestIndex) throws IOException {
        Action.checkSystemActionsEnabled();
        try {
            int index = DatabaseInformations.parseRequestIndex(requestIndex);
            DatabaseInformations databaseInformations = !this.isFromCollectorServer() ? new DatabaseInformations(index) : this.collectorServer.collectDatabaseInformations(this.getApplication(), index);
            this.htmlReport.writeDatabase(databaseInformations);
        }
        catch (Exception e) {
            LOG.warn("database report failed", e);
            this.htmlReport.writeMessageIfNotNull(String.valueOf(e.getMessage()), null);
        }
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.CONNECTIONS)
    void doConnections(@RequestToMethodMapper.RequestParameter(value=HttpParameter.FORMAT) String format) throws IOException {
        assert (!this.isFromCollectorServer());
        Action.checkSystemActionsEnabled();
        boolean withoutHeaders = HTML_BODY_FORMAT.equalsIgnoreCase(format);
        this.htmlReport.writeConnections(JdbcWrapper.getConnectionInformationsList(), withoutHeaders);
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.JNDI)
    void doJndi(@RequestToMethodMapper.RequestParameter(value=HttpParameter.PATH) String path) throws IOException {
        Action.checkSystemActionsEnabled();
        try {
            List<JndiBinding> jndiBindings = !this.isFromCollectorServer() ? JndiBinding.listBindings(path) : this.collectorServer.collectJndiBindings(this.getApplication(), path);
            this.htmlReport.writeJndi(jndiBindings, path);
        }
        catch (Exception e) {
            LOG.warn("jndi report failed", e);
            this.htmlReport.writeMessageIfNotNull(String.valueOf(e.getMessage()), null);
        }
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.MBEANS)
    void doMBeans() throws IOException {
        Action.checkSystemActionsEnabled();
        try {
            if (!this.isFromCollectorServer()) {
                List<MBeanNode> nodes = MBeans.getAllMBeanNodes();
                this.htmlReport.writeMBeans(nodes);
            } else {
                Map<String, List<MBeanNode>> allMBeans = this.collectorServer.collectMBeans(this.getApplication());
                this.htmlReport.writeMBeans(allMBeans);
            }
        }
        catch (Exception e) {
            LOG.warn("mbeans report failed", e);
            this.htmlReport.writeMessageIfNotNull(String.valueOf(e.getMessage()), null);
        }
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.CRASHES)
    void doCrashes() throws IOException {
        Action.checkSystemActionsEnabled();
        this.htmlReport.writeCrashes();
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.SPRING_BEANS)
    void doSpringBeans() throws IOException {
        this.htmlReport.writeSpringContext();
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.CACHE_KEYS)
    void doCacheKeys(@RequestToMethodMapper.RequestParameter(value=HttpParameter.CACHE_ID) String cacheId, @RequestToMethodMapper.RequestParameter(value=HttpParameter.FORMAT) String format) throws IOException {
        assert (!this.isFromCollectorServer());
        CacheInformations cacheInfo = CacheInformations.buildCacheInformationsWithKeys(cacheId);
        boolean withoutHeaders = HTML_BODY_FORMAT.equalsIgnoreCase(format);
        String cacheKeysPart = HttpPart.CACHE_KEYS.toString() + '&' + (Object)((Object)HttpParameter.CACHE_ID) + '=' + I18N.urlEncode(cacheId);
        this.htmlReport.writeCacheWithKeys(cacheId, cacheInfo, this.messageForReport, cacheKeysPart, withoutHeaders);
    }

    @RequestToMethodMapper.RequestPart(value=HttpPart.JCACHE_KEYS)
    void doJCacheKeys(@RequestToMethodMapper.RequestParameter(value=HttpParameter.CACHE_ID) String cacheId, @RequestToMethodMapper.RequestParameter(value=HttpParameter.FORMAT) String format) throws IOException {
        assert (!this.isFromCollectorServer());
        JCacheInformations cacheInfo = JCacheInformations.buildJCacheInformationsWithKeys(cacheId);
        boolean withoutHeaders = HTML_BODY_FORMAT.equalsIgnoreCase(format);
        String jcacheKeysPart = HttpPart.JCACHE_KEYS.toString() + '&' + (Object)((Object)HttpParameter.CACHE_ID) + '=' + I18N.urlEncode(cacheId);
        this.htmlReport.writeJCacheWithKeys(cacheId, cacheInfo, this.messageForReport, jcacheKeysPart, withoutHeaders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeHtmlToLastShutdownFile() {
        try {
            File dir = Parameters.getStorageDirectory(this.getApplication());
            if (!dir.mkdirs() && !dir.exists()) {
                throw new IOException("JavaMelody directory can't be created: " + dir.getPath());
            }
            File lastShutdownFile = new File(dir, "last_shutdown.html");
            BufferedWriter writer = new BufferedWriter(new FileWriter(lastShutdownFile));
            try {
                JavaInformations javaInformations = new JavaInformations(Parameters.getServletContext(), true);
                HtmlReport myHtmlReport = new HtmlReport(this.collector, this.collectorServer, Collections.singletonList(javaInformations), Period.JOUR, (Writer)writer);
                myHtmlReport.writeLastShutdown();
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            LOG.warn("exception while writing the last shutdown report", e);
        }
    }

    private String getApplication() {
        return this.collector.getApplication();
    }

    private boolean isFromCollectorServer() {
        return this.collectorServer != null;
    }
}

