/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.internal.model.TransportFormat;

public final class Parameters {
    public static final String PARAMETER_SYSTEM_PREFIX = "javamelody.";
    public static final File TEMPORARY_DIRECTORY = new File(System.getProperty("java.io.tmpdir"));
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final String JAVAMELODY_VERSION = Parameters.getJavaMelodyVersion();
    private static final String DEFAULT_MONITORING_PATH = "/monitoring";
    private static final int DEFAULT_RESOLUTION_SECONDS = 60;
    private static final String DEFAULT_DIRECTORY = "javamelody";
    private static final String COLLECTOR_APPLICATIONS_FILENAME = "applications.properties";
    private static final boolean PDF_ENABLED = Parameters.computePdfEnabled();
    private static Map<String, List<URL>> urlsByApplications;
    private static Map<String, List<String>> applicationsByAggregationApplications;
    private static FilterConfig filterConfig;
    private static ServletContext servletContext;
    private static String lastConnectUrl;
    private static Properties lastConnectInfo;
    private static boolean dnsLookupsDisabled;

    private Parameters() {
    }

    public static void initialize(FilterConfig config) {
        filterConfig = config;
        if (config != null) {
            ServletContext context = config.getServletContext();
            Parameters.initialize(context);
        }
    }

    public static void initialize(ServletContext context) {
        if ("1.6".compareTo(JAVA_VERSION) > 0) {
            throw new IllegalStateException("La version java doit \u00eatre 1.6 au minimum et non " + JAVA_VERSION);
        }
        servletContext = context;
        dnsLookupsDisabled = Parameter.DNS_LOOKUPS_DISABLED.getValueAsBoolean();
    }

    public static void initJdbcDriverParameters(String connectUrl, Properties connectInfo) {
        lastConnectUrl = connectUrl;
        lastConnectInfo = connectInfo;
    }

    public static ServletContext getServletContext() {
        assert (servletContext != null);
        return servletContext;
    }

    public static String getLastConnectUrl() {
        return lastConnectUrl;
    }

    public static Properties getLastConnectInfo() {
        return lastConnectInfo;
    }

    public static Map<String, List<URL>> getCollectorUrlsByApplications() throws IOException {
        if (urlsByApplications == null) {
            Parameters.readCollectorApplications();
        }
        return Collections.unmodifiableMap(urlsByApplications);
    }

    public static Map<String, List<String>> getApplicationsByAggregationApplication() throws IOException {
        if (applicationsByAggregationApplications == null) {
            Parameters.readCollectorApplications();
        }
        return Collections.unmodifiableMap(applicationsByAggregationApplications);
    }

    public static void addCollectorApplication(String application, List<URL> urls) throws IOException {
        assert (application != null);
        assert (urls != null && !urls.isEmpty());
        Parameters.getCollectorUrlsByApplications();
        urlsByApplications.put(application, urls);
        Parameters.writeCollectorApplications();
    }

    public static void addCollectorAggregationApplication(String aggregationApplication, List<String> aggregatedApplications) throws IOException {
        assert (aggregationApplication != null);
        assert (aggregatedApplications != null && !aggregatedApplications.isEmpty());
        Parameters.getCollectorUrlsByApplications();
        applicationsByAggregationApplications.put(aggregationApplication, aggregatedApplications);
        Parameters.writeCollectorApplications();
    }

    public static void removeCollectorApplication(String application) throws IOException {
        assert (application != null);
        Parameters.getCollectorUrlsByApplications();
        if (urlsByApplications.containsKey(application)) {
            urlsByApplications.remove(application);
        } else {
            applicationsByAggregationApplications.remove(application);
        }
        Parameters.synchronizeAggregationApplications();
        Parameters.writeCollectorApplications();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeCollectorApplications() throws IOException {
        StringBuilder sb;
        Properties properties = new Properties();
        String monitoringPath = Parameters.getMonitoringPath();
        for (Map.Entry<String, List<URL>> entry : urlsByApplications.entrySet()) {
            List<URL> urls = entry.getValue();
            assert (urls != null && !urls.isEmpty());
            sb = new StringBuilder();
            for (URL uRL : urls) {
                String urlString = uRL.toString();
                String webappUrl = urlString.substring(0, urlString.lastIndexOf(monitoringPath));
                if (webappUrl.indexOf(44) != -1) {
                    throw new IOException("The URL should not contain a comma.");
                }
                sb.append(webappUrl).append(',');
            }
            sb.delete(sb.length() - 1, sb.length());
            properties.put(entry.getKey(), sb.toString());
        }
        for (Map.Entry<String, List<Object>> entry : applicationsByAggregationApplications.entrySet()) {
            List<Object> applications = entry.getValue();
            sb = new StringBuilder();
            for (String string : applications) {
                if (string.indexOf(44) != -1) {
                    throw new IOException("The application name should not contain a comma.");
                }
                sb.append(string).append(',');
            }
            sb.delete(sb.length() - 1, sb.length());
            properties.put(entry.getKey(), sb.toString());
        }
        File collectorApplicationsFile = Parameters.getCollectorApplicationsFile();
        File file = collectorApplicationsFile.getParentFile();
        if (!file.mkdirs() && !file.exists()) {
            throw new IOException("JavaMelody directory can't be created: " + file.getPath());
        }
        FileOutputStream output = new FileOutputStream(collectorApplicationsFile);
        try {
            properties.store(output, "urls of the applications to monitor");
        }
        finally {
            output.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readCollectorApplications() throws IOException {
        TreeMap<String, List<URL>> applications = new TreeMap<String, List<URL>>();
        TreeMap<String, List<String>> aggregationApplications = new TreeMap<String, List<String>>();
        File file = Parameters.getCollectorApplicationsFile();
        if (file.exists()) {
            Properties properties = new Properties();
            FileInputStream input = new FileInputStream(file);
            try {
                properties.load(input);
            }
            finally {
                input.close();
            }
            ArrayList<String> propertyNames = Collections.list(properties.propertyNames());
            for (String property : propertyNames) {
                String value = String.valueOf(properties.get(property));
                if (value.startsWith("http")) {
                    applications.put(property, Parameters.parseUrls(value));
                    continue;
                }
                aggregationApplications.put(property, new ArrayList<String>(Arrays.asList(value.split(","))));
            }
        }
        urlsByApplications = applications;
        applicationsByAggregationApplications = aggregationApplications;
        Parameters.synchronizeAggregationApplications();
    }

    private static void synchronizeAggregationApplications() {
        Iterator<List<String>> it1 = applicationsByAggregationApplications.values().iterator();
        while (it1.hasNext()) {
            List<String> aggregatedApplications = it1.next();
            Iterator<String> it2 = aggregatedApplications.iterator();
            while (it2.hasNext()) {
                String aggregatedApplication = it2.next();
                if (urlsByApplications.containsKey(aggregatedApplication) || applicationsByAggregationApplications.containsKey(aggregatedApplication)) continue;
                it2.remove();
            }
            if (!aggregatedApplications.isEmpty()) continue;
            it1.remove();
        }
    }

    public static File getCollectorApplicationsFile() {
        return new File(Parameters.getStorageDirectory(""), COLLECTOR_APPLICATIONS_FILENAME);
    }

    public static List<URL> parseUrls(String value) throws MalformedURLException {
        TransportFormat transportFormat = Parameter.TRANSPORT_FORMAT.getValue() == null ? TransportFormat.SERIALIZED : TransportFormat.valueOfIgnoreCase(Parameter.TRANSPORT_FORMAT.getValue());
        String suffix = Parameters.getMonitoringPath() + "?collector=stop&format=" + transportFormat.getCode();
        String[] urlsArray = value.split(",");
        ArrayList<URL> urls = new ArrayList<URL>(urlsArray.length);
        for (String s : urlsArray) {
            String s2 = s.trim();
            while (s2.endsWith("/")) {
                s2 = s2.substring(0, s2.length() - 1);
            }
            URL url = new URL(s2 + suffix);
            urls.add(url);
        }
        return urls;
    }

    public static String getMonitoringPath() {
        String parameterValue = Parameter.MONITORING_PATH.getValue();
        if (parameterValue == null) {
            return DEFAULT_MONITORING_PATH;
        }
        return parameterValue;
    }

    public static String getHostName() {
        if (dnsLookupsDisabled) {
            return "localhost";
        }
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            return "unknown";
        }
    }

    public static String getHostAddress() {
        if (dnsLookupsDisabled) {
            return "127.0.0.1";
        }
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException ex) {
            return "unknown";
        }
    }

    public static String getResourcePath(String fileName) {
        return "/net/bull/javamelody/resource/" + fileName;
    }

    public static int getResolutionSeconds() {
        String param = Parameter.RESOLUTION_SECONDS.getValue();
        if (param != null) {
            int result = Integer.parseInt(param);
            if (result <= 0) {
                throw new IllegalStateException("The parameter resolution-seconds should be > 0 (between 60 and 600 recommended)");
            }
            return result;
        }
        return 60;
    }

    public static File getStorageDirectory(String application) {
        String param = Parameter.STORAGE_DIRECTORY.getValue();
        String dir = param == null ? DEFAULT_DIRECTORY : param;
        String directory = !dir.isEmpty() && new File(dir).isAbsolute() ? dir : TEMPORARY_DIRECTORY.getPath() + '/' + dir;
        if (servletContext != null) {
            return new File(directory + '/' + application);
        }
        return new File(directory);
    }

    public static boolean isNoDatabase() {
        return Parameter.NO_DATABASE.getValueAsBoolean();
    }

    public static boolean isSystemActionsEnabled() {
        String parameter = Parameter.SYSTEM_ACTIONS_ENABLED.getValue();
        return parameter == null || Boolean.parseBoolean(parameter);
    }

    public static boolean isPdfEnabled() {
        return PDF_ENABLED;
    }

    private static boolean computePdfEnabled() {
        try {
            Class.forName("com.lowagie.text.Document");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isCounterHidden(String counterName) {
        String displayedCounters = Parameter.DISPLAYED_COUNTERS.getValue();
        if (displayedCounters == null) {
            return false;
        }
        for (String displayedCounter : displayedCounters.split(",")) {
            String displayedCounterName = displayedCounter.trim();
            if (!counterName.equalsIgnoreCase(displayedCounterName)) continue;
            return false;
        }
        return true;
    }

    public static String getCurrentApplication() {
        String applicationName = Parameter.APPLICATION_NAME.getValue();
        if (applicationName != null) {
            return applicationName;
        }
        if (servletContext != null) {
            return Parameters.getContextPath(servletContext) + '_' + Parameters.getHostName();
        }
        return null;
    }

    public static String getContextPath(ServletContext context) {
        int lastIndexOfSlash;
        URL webXmlUrl;
        if (context.getMajorVersion() == 2 && context.getMinorVersion() >= 5 || context.getMajorVersion() > 2) {
            return context.getContextPath();
        }
        try {
            webXmlUrl = context.getResource("/WEB-INF/web.xml");
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        String contextPath = webXmlUrl.toExternalForm();
        contextPath = contextPath.substring(0, contextPath.indexOf("/WEB-INF/web.xml"));
        int indexOfWar = contextPath.indexOf(".war");
        if (indexOfWar > 0) {
            contextPath = contextPath.substring(0, indexOfWar);
        }
        if (contextPath.startsWith("jndi:/localhost")) {
            contextPath = contextPath.substring("jndi:/localhost".length());
        }
        if ((lastIndexOfSlash = contextPath.lastIndexOf(47)) != -1) {
            contextPath = contextPath.substring(lastIndexOfSlash);
        }
        return contextPath;
    }

    private static String getJavaMelodyVersion() {
        String string;
        InputStream inputStream = Parameters.class.getResourceAsStream("/JAVAMELODY-VERSION.properties");
        if (inputStream == null) {
            return null;
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            string = properties.getProperty("version");
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException e) {
                return e.toString();
            }
        }
        inputStream.close();
        return string;
    }

    public static String getParameterValue(Parameter parameter) {
        assert (parameter != null);
        String name = parameter.getCode();
        return Parameters.getParameterValueByName(name);
    }

    public static String getParameterValueByName(String parameterName) {
        assert (parameterName != null);
        String globalName = PARAMETER_SYSTEM_PREFIX + parameterName;
        String result = System.getProperty(globalName);
        if (result != null) {
            return result;
        }
        if (servletContext != null) {
            result = servletContext.getInitParameter(globalName);
            if (result != null) {
                return result;
            }
            Object attribute = servletContext.getAttribute(globalName);
            if (attribute instanceof String) {
                return (String)attribute;
            }
        }
        if (filterConfig != null) {
            return filterConfig.getInitParameter(parameterName);
        }
        return null;
    }
}

