/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.internal.common.InputOutput;
import net.bull.javamelody.internal.common.LOG;
import net.bull.javamelody.internal.common.Parameters;
import net.bull.javamelody.internal.model.LabradorRetriever;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class MavenArtifact
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String MAVEN_CENTRAL = "https://repo1.maven.org/maven2";
    private static final File LOCAL_REPO = new File(System.getProperty("user.home") + "/.m2/repository");
    private static final String TOMCAT_ARCHIVES = "https://archive.apache.org/dist/tomcat/";
    private static Map<String, String> sourceFilePathsByJarFileNames;
    private static String webappVersion;
    private String name;
    private String url;
    private String groupId;
    private String artifactId;
    private String version;
    private MavenArtifact parent;
    private final Map<String, String> licenseUrlsByName = new LinkedHashMap<String, String>();
    private Map<String, String> properties;
    private final List<MavenArtifact> dependencies = new ArrayList<MavenArtifact>();
    private final List<MavenArtifact> managedDependencies = new ArrayList<MavenArtifact>();
    private boolean updated;

    private MavenArtifact() {
    }

    private static MavenArtifact parseDependency(URL jarFileLocation) throws IOException {
        byte[] pomXml = MavenArtifact.readMavenFileFromJarFile(jarFileLocation, "pom.xml");
        if (pomXml != null) {
            MavenArtifact dependency = new MavenArtifact();
            dependency.parsePomXml(new ByteArrayInputStream(pomXml));
            return dependency;
        }
        return null;
    }

    private void parsePomXml(InputStream pomXml) throws IOException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(pomXml);
            Node projectNode = doc.getElementsByTagName("project").item(0);
            NodeList childNodes = projectNode.getChildNodes();
            this.properties = new HashMap<String, String>();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node node = childNodes.item(i);
                this.parseNode(node);
            }
            this.properties.put("project.groupId", this.groupId);
            this.properties.put("pom.groupId", this.groupId);
            this.properties.put("groupId", this.groupId);
            this.properties.put("project.version", this.version);
            this.properties.put("pom.version", this.version);
            this.properties.put("version", this.version);
            for (MavenArtifact dependency : this.dependencies) {
                dependency.groupId = MavenArtifact.replaceProperty(dependency.groupId, this.properties);
                dependency.version = MavenArtifact.replaceProperty(dependency.version, this.properties);
            }
            for (MavenArtifact dependency : this.managedDependencies) {
                dependency.groupId = MavenArtifact.replaceProperty(dependency.groupId, this.properties);
                dependency.version = MavenArtifact.replaceProperty(dependency.version, this.properties);
            }
            this.properties = null;
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException(e.getMessage(), e);
        }
        this.updated = true;
    }

    private void parseNode(Node node) {
        String nodeName = node.getNodeName();
        if ("name".equals(nodeName)) {
            this.name = node.getTextContent();
        } else if ("description".equals(nodeName) && this.name == null) {
            this.name = node.getTextContent();
        } else if ("url".equals(nodeName)) {
            this.url = node.getTextContent();
        } else if ("groupId".equals(nodeName) && !node.getTextContent().startsWith("${")) {
            this.groupId = node.getTextContent();
        } else if ("artifactId".equals(nodeName)) {
            this.artifactId = node.getTextContent();
        } else if ("version".equals(nodeName) && !node.getTextContent().startsWith("${")) {
            this.version = node.getTextContent();
        } else if ("parent".equals(nodeName)) {
            this.parseParentNode(node);
        } else if ("properties".equals(nodeName)) {
            this.properties.putAll(this.parsePropertiesNode(node));
        } else if ("licenses".equals(nodeName)) {
            this.parseLicensesNode(node);
        } else if ("dependencies".equals(nodeName)) {
            this.dependencies.addAll(this.parseDependenciesNode(node));
        } else if ("dependencyManagement".equals(nodeName)) {
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                if (!"dependencies".equals(childNode.getNodeName())) continue;
                this.managedDependencies.addAll(this.parseDependenciesNode(childNode));
            }
        }
    }

    private void parseParentNode(Node node) {
        NodeList parentNodes = node.getChildNodes();
        String parentGroupId = null;
        String parentArtifactId = null;
        String parentVersion = null;
        for (int k = 0; k < parentNodes.getLength(); ++k) {
            Node childParentNode = parentNodes.item(k);
            String nodeName = childParentNode.getNodeName();
            if ("groupId".equals(nodeName)) {
                parentGroupId = childParentNode.getTextContent();
                continue;
            }
            if ("artifactId".equals(nodeName)) {
                parentArtifactId = childParentNode.getTextContent();
                continue;
            }
            if (!"version".equals(nodeName)) continue;
            parentVersion = childParentNode.getTextContent();
        }
        if (this.groupId == null) {
            this.groupId = parentGroupId;
        }
        if (this.version == null) {
            this.version = parentVersion;
        }
        this.parent = new MavenArtifact();
        this.parent.groupId = parentGroupId;
        this.parent.artifactId = parentArtifactId;
        this.parent.version = parentVersion;
    }

    private Map<String, String> parsePropertiesNode(Node propertiesNode) {
        HashMap<String, String> props = new HashMap<String, String>();
        NodeList propertiesNodes = propertiesNode.getChildNodes();
        for (int j = 0; j < propertiesNodes.getLength(); ++j) {
            Node propertyNode = propertiesNodes.item(j);
            String nodeName = propertyNode.getNodeName();
            if (nodeName == null) continue;
            props.put(nodeName, propertyNode.getTextContent());
        }
        return props;
    }

    private void parseLicensesNode(Node licensesNode) {
        NodeList licenseNodes = licensesNode.getChildNodes();
        for (int j = 0; j < licenseNodes.getLength(); ++j) {
            Node licenseNode = licenseNodes.item(j);
            if (!"license".equals(licenseNode.getNodeName())) continue;
            String licenseName = null;
            String licenseUrl = null;
            NodeList childLicenseNodes = licenseNode.getChildNodes();
            for (int k = 0; k < childLicenseNodes.getLength(); ++k) {
                Node childLicenseNode = childLicenseNodes.item(k);
                String nodeName = childLicenseNode.getNodeName();
                if ("name".equals(nodeName)) {
                    licenseName = childLicenseNode.getTextContent();
                    continue;
                }
                if (!"url".equals(nodeName)) continue;
                licenseUrl = childLicenseNode.getTextContent();
            }
            if (licenseName != null) {
                this.licenseUrlsByName.put(licenseName, licenseUrl);
                continue;
            }
            if (licenseUrl == null) continue;
            if (licenseUrl.startsWith("http")) {
                this.licenseUrlsByName.put("LICENSE", licenseUrl);
                continue;
            }
            this.licenseUrlsByName.put(licenseUrl, licenseUrl);
        }
    }

    private List<MavenArtifact> parseDependenciesNode(Node dependenciesNode) {
        ArrayList<MavenArtifact> deps = new ArrayList<MavenArtifact>();
        NodeList dependencyNodes = dependenciesNode.getChildNodes();
        for (int j = 0; j < dependencyNodes.getLength(); ++j) {
            Node dependencyNode = dependencyNodes.item(j);
            if (!"dependency".equals(dependencyNode.getNodeName())) continue;
            NodeList childDependencyNodes = dependencyNode.getChildNodes();
            MavenArtifact dependency = new MavenArtifact();
            String scope = null;
            String optional = null;
            for (int k = 0; k < childDependencyNodes.getLength(); ++k) {
                Node childDependencyNode = childDependencyNodes.item(k);
                String nodeName = childDependencyNode.getNodeName();
                if ("groupId".equals(nodeName)) {
                    dependency.groupId = childDependencyNode.getTextContent();
                    continue;
                }
                if ("artifactId".equals(nodeName)) {
                    dependency.artifactId = childDependencyNode.getTextContent();
                    continue;
                }
                if ("version".equals(nodeName)) {
                    dependency.version = childDependencyNode.getTextContent();
                    continue;
                }
                if ("scope".equals(nodeName)) {
                    scope = childDependencyNode.getTextContent();
                    continue;
                }
                if (!"optional".equals(nodeName)) continue;
                optional = childDependencyNode.getTextContent();
            }
            if (scope != null && !"compile".equals(scope) || "true".equals(optional)) continue;
            deps.add(dependency);
        }
        return deps;
    }

    private void update() throws IOException {
        if (!this.updated && this.version != null) {
            this.updated = true;
            String filePath = this.getPath(".pom");
            File pomXml = MavenArtifact.getMavenArtifact(filePath);
            if (pomXml != null) {
                try (FileInputStream input = new FileInputStream(pomXml);){
                    this.parsePomXml(input);
                }
            }
        }
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() throws IOException {
        if (this.name == null && this.parent != null) {
            this.parent.update();
            return this.parent.getName();
        }
        return this.name;
    }

    public String getUrl() throws IOException {
        if (this.url == null && this.parent != null) {
            this.parent.update();
            return this.parent.getUrl();
        }
        return this.url;
    }

    public Map<String, String> getLicenseUrlsByName() throws IOException {
        if (this.licenseUrlsByName.isEmpty() && this.parent != null) {
            this.parent.update();
            return this.parent.getLicenseUrlsByName();
        }
        return this.licenseUrlsByName;
    }

    private List<MavenArtifact> getAllManagedDependencies() throws IOException {
        this.update();
        ArrayList<MavenArtifact> allManagedDependencies = new ArrayList<MavenArtifact>(this.managedDependencies);
        if (this.parent != null) {
            allManagedDependencies.addAll(this.parent.getAllManagedDependencies());
        }
        return allManagedDependencies;
    }

    List<MavenArtifact> getAllDependencies() throws IOException {
        return this.getAllDependencies(1);
    }

    private List<MavenArtifact> getAllDependencies(int level) throws IOException {
        if (level > 10) {
            return Collections.emptyList();
        }
        this.update();
        ArrayList<MavenArtifact> transitiveDependencies = new ArrayList<MavenArtifact>();
        List<MavenArtifact> allManagedDependencies = this.getAllManagedDependencies();
        for (MavenArtifact dependency : this.dependencies) {
            if (dependency.version == null) {
                for (MavenArtifact managedDependency : allManagedDependencies) {
                    if (!dependency.isSame(managedDependency)) continue;
                    dependency.version = managedDependency.version;
                    break;
                }
            }
            transitiveDependencies.addAll(dependency.getAllDependencies(level + 1));
        }
        if (this.parent != null) {
            transitiveDependencies.addAll(this.parent.getAllDependencies(level + 1));
        }
        ArrayList<MavenArtifact> allDependencies = new ArrayList<MavenArtifact>(this.dependencies);
        for (MavenArtifact transitiveDependency : transitiveDependencies) {
            if (transitiveDependency.isContained(allDependencies)) continue;
            allDependencies.add(transitiveDependency);
        }
        return allDependencies;
    }

    private boolean isContained(List<MavenArtifact> artifacts) {
        for (MavenArtifact artifact : artifacts) {
            if (!this.isSame(artifact)) continue;
            return true;
        }
        return false;
    }

    private boolean isSame(MavenArtifact artifact) {
        return this.groupId.equals(artifact.groupId) && this.artifactId.equals(artifact.artifactId);
    }

    private String getPath(String extension) {
        return this.groupId.replace('.', '/') + '/' + this.artifactId + '/' + this.version + '/' + this.artifactId + '-' + this.version + extension;
    }

    public static Map<String, MavenArtifact> getWebappDependencies() throws IOException {
        Map<String, MavenArtifact> webappDependencies = MavenArtifact.getWebappDependenciesFromWebInfLib();
        ArrayList<MavenArtifact> allDependencies = new ArrayList<MavenArtifact>(MavenArtifact.getWebappDependenciesFromPomXml());
        for (MavenArtifact mavenArtifact : webappDependencies.values()) {
            if (mavenArtifact == null || mavenArtifact.isContained(allDependencies)) continue;
            allDependencies.add(mavenArtifact);
            for (MavenArtifact transitiveDependency : mavenArtifact.getAllDependencies()) {
                if (transitiveDependency.isContained(allDependencies)) continue;
                allDependencies.add(transitiveDependency);
            }
        }
        block2: for (Map.Entry entry : webappDependencies.entrySet()) {
            if (entry.getValue() != null) continue;
            String jarFileName = (String)entry.getKey();
            for (MavenArtifact dependency : allDependencies) {
                if (!jarFileName.startsWith(dependency.getArtifactId() + '-' + dependency.getVersion())) continue;
                entry.setValue(dependency);
                continue block2;
            }
        }
        return webappDependencies;
    }

    private static List<MavenArtifact> getWebappDependenciesFromPomXml() throws IOException {
        InputStream webappPomXmlAsStream = MavenArtifact.getWebappPomXmlAsStream();
        if (webappPomXmlAsStream != null) {
            try {
                MavenArtifact webappArtifact = new MavenArtifact();
                webappArtifact.parsePomXml(webappPomXmlAsStream);
                List<MavenArtifact> list = webappArtifact.getAllDependencies();
                return list;
            }
            finally {
                webappPomXmlAsStream.close();
            }
        }
        return Collections.emptyList();
    }

    private static Map<String, MavenArtifact> getWebappDependenciesFromWebInfLib() throws IOException {
        ServletContext servletContext = Parameters.getServletContext();
        String directory = "/WEB-INF/lib/";
        Set dependencies = servletContext.getResourcePaths("/WEB-INF/lib/");
        if (dependencies == null || dependencies.isEmpty()) {
            return Collections.emptyMap();
        }
        TreeMap<String, MavenArtifact> result = new TreeMap<String, MavenArtifact>();
        for (String dependency : dependencies) {
            if (!dependency.endsWith(".jar") && !dependency.endsWith(".JAR")) continue;
            String fileName = dependency.substring("/WEB-INF/lib/".length());
            URL jarFileLocation = servletContext.getResource(dependency);
            if (jarFileLocation != null) {
                result.put(fileName, MavenArtifact.parseDependency(jarFileLocation));
                continue;
            }
            result.put(fileName, null);
        }
        return result;
    }

    public static InputStream getWebappPomXmlAsStream() {
        return MavenArtifact.getWebappPomFile("pom.xml");
    }

    public static synchronized String getWebappVersion() {
        if (webappVersion == null && (webappVersion = Parameter.APPLICATION_VERSION.getValue()) == null) {
            InputStream input = MavenArtifact.getWebappPomFile("pom.properties");
            if (input != null) {
                try {
                    try {
                        Properties properties = new Properties();
                        properties.load(input);
                        webappVersion = properties.getProperty("version");
                    }
                    finally {
                        input.close();
                    }
                }
                catch (IOException e) {
                    LOG.debug(e.toString(), e);
                }
            }
            if (webappVersion == null) {
                webappVersion = "";
            }
        }
        if (webappVersion.isEmpty()) {
            return null;
        }
        return webappVersion;
    }

    private static InputStream getWebappPomFile(String pomFilename) {
        Set mavenDir = Parameters.getServletContext().getResourcePaths("/META-INF/maven/");
        if (mavenDir == null || mavenDir.isEmpty()) {
            return null;
        }
        Set groupDir = Parameters.getServletContext().getResourcePaths((String)mavenDir.iterator().next());
        if (groupDir == null || groupDir.isEmpty()) {
            return null;
        }
        InputStream pomXml = Parameters.getServletContext().getResourceAsStream(groupDir.iterator().next() + pomFilename);
        if (pomXml == null) {
            return null;
        }
        return new BufferedInputStream(pomXml);
    }

    public static File getSourceJarFile(URL classesJarFileUrl) throws IOException {
        File sources;
        String file = classesJarFileUrl.getFile();
        if (file.endsWith(".jar") && (sources = new File(file.replace(".jar", "-sources.jar"))).exists()) {
            return sources;
        }
        byte[] pomProperties = MavenArtifact.readMavenFileFromJarFile(classesJarFileUrl, "pom.properties");
        if (pomProperties == null) {
            String sourceFilePath;
            Map<String, String> sourceFilePaths = MavenArtifact.getSourceFilePathsByJarFileNames();
            String jarFileName = file;
            if (jarFileName.endsWith("!/")) {
                jarFileName = jarFileName.substring(0, jarFileName.length() - "!/".length());
            }
            if ((sourceFilePath = sourceFilePaths.get(jarFileName = jarFileName.substring(jarFileName.lastIndexOf(47) + 1))) != null) {
                return MavenArtifact.getMavenArtifact(sourceFilePath);
            }
            return null;
        }
        Properties properties = new Properties();
        properties.load(new ByteArrayInputStream(pomProperties));
        MavenArtifact mavenArtifact = new MavenArtifact();
        mavenArtifact.groupId = properties.getProperty("groupId");
        mavenArtifact.artifactId = properties.getProperty("artifactId");
        mavenArtifact.version = properties.getProperty("version");
        String filePath = mavenArtifact.getPath("-sources.jar");
        return MavenArtifact.getMavenArtifact(filePath);
    }

    private static synchronized Map<String, String> getSourceFilePathsByJarFileNames() throws IOException {
        if (sourceFilePathsByJarFileNames == null) {
            Map<String, MavenArtifact> webappDependencies = MavenArtifact.getWebappDependencies();
            HashMap<String, String> sourceFilePaths = new HashMap<String, String>();
            for (Map.Entry<String, MavenArtifact> entry : webappDependencies.entrySet()) {
                String jarFileName = entry.getKey();
                MavenArtifact dependency = entry.getValue();
                if (dependency == null) continue;
                String filePath = dependency.getPath("-sources.jar");
                sourceFilePaths.put(jarFileName, filePath);
            }
            sourceFilePathsByJarFileNames = sourceFilePaths;
        }
        return sourceFilePathsByJarFileNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getMavenArtifact(String filePath) throws IOException {
        String subDirectory;
        if (filePath.contains("${")) {
            return null;
        }
        File storageDirectory = Parameters.getStorageDirectory(Parameters.getCurrentApplication());
        File file = new File(storageDirectory, (subDirectory = filePath.endsWith(".pom") ? "poms" : "sources") + '/' + filePath.substring(filePath.lastIndexOf(47) + 1));
        if (!file.exists() || file.length() == 0L) {
            for (String mavenRepository : MavenArtifact.getMavenRepositories()) {
                String url = mavenRepository + '/' + filePath;
                if (!url.startsWith("http")) {
                    if (!new File(url).exists()) continue;
                    return new File(url);
                }
                MavenArtifact.mkdirs(file.getParentFile());
                try (FileOutputStream output = new FileOutputStream(file);){
                    LabradorRetriever labradorRetriever = new LabradorRetriever(new URL(url));
                    labradorRetriever.downloadTo(output);
                    break;
                }
            }
        }
        if (file.exists()) {
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getTomcatSrcZipFile() throws IOException {
        String serverInfo = Parameters.getServletContext().getServerInfo();
        if (!serverInfo.matches("Apache Tomcat/\\d+\\.\\d+\\.\\d+")) {
            return null;
        }
        String version = serverInfo.substring(serverInfo.lastIndexOf(47) + 1);
        String fileName = "apache-tomcat-" + version + "-src.zip";
        File storageDirectory = Parameters.getStorageDirectory(Parameters.getCurrentApplication());
        String subDirectory = "sources";
        File file = new File(storageDirectory, "sources/" + fileName);
        if (!file.exists() || file.length() == 0L) {
            String majorVersion = version.substring(0, version.indexOf(46));
            String url = "https://archive.apache.org/dist/tomcat/tomcat-" + majorVersion + "/v" + version + "/src/" + fileName;
            MavenArtifact.mkdirs(file.getParentFile());
            try (FileOutputStream output = new FileOutputStream(file);){
                LabradorRetriever labradorRetriever = new LabradorRetriever(new URL(url));
                labradorRetriever.downloadTo(output);
            }
        }
        if (file.exists()) {
            return file;
        }
        return null;
    }

    private static void mkdirs(File directory) {
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IllegalStateException("Can't create directory " + directory.getPath());
        }
    }

    private static byte[] readMavenFileFromJarFile(URL jarFileLocation, String pomFileName) throws IOException {
        try (ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(jarFileLocation.openStream(), 4096));){
            ZipEntry entry = zipInputStream.getNextEntry();
            while (entry != null) {
                if (entry.getName().startsWith("META-INF/maven/") && entry.getName().endsWith("/" + pomFileName)) {
                    byte[] byArray = InputOutput.pumpToByteArray(zipInputStream);
                    return byArray;
                }
                zipInputStream.closeEntry();
                entry = zipInputStream.getNextEntry();
            }
        }
        return null;
    }

    private static List<String> getMavenRepositories() {
        String parameter = Parameter.MAVEN_REPOSITORIES.getValue();
        if (parameter != null) {
            ArrayList<String> result = new ArrayList<String>();
            for (String repo : parameter.split(",")) {
                result.add(repo.trim());
            }
            return result;
        }
        return Arrays.asList(LOCAL_REPO.getPath(), MAVEN_CENTRAL);
    }

    private static String replaceProperty(String value, Map<String, String> properties) {
        String propertyName;
        String propertyValue;
        if (value != null && value.startsWith("${") && value.endsWith("}") && (propertyValue = properties.get(propertyName = value.substring("${".length(), value.length() - "}".length()))) != null) {
            return propertyValue;
        }
        return value;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.groupId + ':' + this.artifactId + ':' + this.version + ']';
    }
}

