/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web.html;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.common.Parameters;
import net.bull.javamelody.internal.model.JavaInformations;
import net.bull.javamelody.internal.model.MemoryInformations;
import net.bull.javamelody.internal.model.TomcatInformations;
import net.bull.javamelody.internal.web.html.HtmlAbstractReport;

public class HtmlJavaInformationsReport
extends HtmlAbstractReport {
    private static final String[] OS = new String[]{"linux", "windows", "mac", "solaris", "hp", "ibm"};
    private static final String[] APPLICATION_SERVERS = new String[]{"tomcat", "glassfish", "jetty", "oracle", "bea", "ibm", "jboss", "wildfly"};
    private static final double MIN_VALUE = 0.0;
    private static final double MAX_VALUE = 100.0;
    private static final int PARTIAL_BLOCKS = 5;
    private static final int FULL_BLOCKS = 10;
    private static final double UNIT_SIZE = 2.0;
    private final boolean noDatabase = Parameters.isNoDatabase();
    private final DecimalFormat integerFormat = I18N.createIntegerFormat();
    private final DecimalFormat decimalFormat = I18N.createPercentFormat();
    private final List<JavaInformations> javaInformationsList;

    HtmlJavaInformationsReport(List<JavaInformations> javaInformationsList, Writer writer) {
        super(writer);
        assert (javaInformationsList != null && !javaInformationsList.isEmpty());
        this.javaInformationsList = javaInformationsList;
    }

    @Override
    void toHtml() throws IOException {
        for (JavaInformations javaInformations : this.javaInformationsList) {
            this.writeSummary(javaInformations);
        }
        if (!this.noDatabase) {
            this.write("<br/><br/>");
        }
        String br = "<br/>";
        if (this.javaInformationsList.get(0).getSessionCount() >= 0) {
            this.write("<br/>");
        }
        if (this.javaInformationsList.get(0).getSystemLoadAverage() >= 0.0) {
            this.write("<br/>");
        }
        this.writeln("<br/><br/><br/><br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeShowHideLink("detailsJava", "#Details#");
        this.writeln("<br/><br/><br/>");
        this.writeln("<div id='detailsJava' class='displayNone'><div>");
        boolean repeatHost = this.javaInformationsList.size() > 1;
        for (JavaInformations javaInformations : this.javaInformationsList) {
            this.writeDetails(javaInformations, repeatHost);
        }
        this.writeln("</div></div>");
    }

    private void writeSummary(JavaInformations javaInformations) throws IOException {
        String lineEnd = "</td> </tr>";
        String columnAndLineEnd = "</td><td></td> </tr>";
        this.writeln("<table align='left' border='0' summary='#Informations_systemes#'>");
        this.writeln("<tr><td>#Host#: </td><td><b>" + javaInformations.getHost() + "</b>" + "</td> </tr>");
        MemoryInformations memoryInformations = javaInformations.getMemoryInformations();
        long usedMemory = memoryInformations.getUsedMemory();
        long maxMemory = memoryInformations.getMaxMemory();
        this.write("<tr><td>#memoire_utilisee#: </td><td>");
        this.writeGraph("usedMemory", this.integerFormat.format(usedMemory / 1024L / 1024L));
        this.writeln(" #Mo# / " + this.integerFormat.format(maxMemory / 1024L / 1024L) + " #Mo#&nbsp;&nbsp;&nbsp;</td><td>");
        this.writeln(HtmlJavaInformationsReport.toBarWithAlert(memoryInformations.getUsedMemoryPercentage(), "-Xmx"));
        this.writeln("</td> </tr>");
        if (javaInformations.getSessionCount() >= 0) {
            this.write("<tr><td>#nb_sessions_http#: </td><td>");
            this.writeGraph("httpSessions", this.integerFormat.format(javaInformations.getSessionCount()));
            this.writeln("</td><td></td> </tr>");
        }
        this.write("<tr><td>#nb_threads_actifs#<br/>(#Requetes_http_en_cours#): </td><td>");
        this.writeGraph("activeThreads", this.integerFormat.format(javaInformations.getActiveThreadCount()));
        this.writeln("</td><td></td> </tr>");
        if (!this.noDatabase) {
            this.write("<tr><td>#nb_connexions_actives#: </td><td>");
            this.writeGraph("activeConnections", this.integerFormat.format(javaInformations.getActiveConnectionCount()));
            this.writeln("</td><td></td> </tr>");
            int usedConnectionCount = javaInformations.getUsedConnectionCount();
            int maxConnectionCount = javaInformations.getMaxConnectionCount();
            this.write("<tr><td>#nb_connexions_utilisees#<br/>(#ouvertes#): </td><td>");
            this.writeGraph("usedConnections", this.integerFormat.format(usedConnectionCount));
            if (maxConnectionCount > 0) {
                this.writeln(" / " + this.integerFormat.format(maxConnectionCount) + "&nbsp;&nbsp;&nbsp;</td><td>");
                this.writeln(HtmlJavaInformationsReport.toBarWithAlert(javaInformations.getUsedConnectionPercentage(), null));
            }
            this.writeln("</td> </tr>");
        }
        if (javaInformations.getSystemLoadAverage() >= 0.0) {
            this.write("<tr><td>#Charge_systeme#</td><td>");
            this.writeGraph("systemLoad", this.decimalFormat.format(javaInformations.getSystemLoadAverage()));
            this.writeln("</td><td></td> </tr>");
        }
        if (javaInformations.getSystemCpuLoad() >= 0.0) {
            this.write("<tr><td>#systemCpuLoad#</td><td>");
            this.writeGraph("systemCpuLoad", this.decimalFormat.format(javaInformations.getSystemCpuLoad()));
            this.writeln("&nbsp;&nbsp;&nbsp;</td><td>");
            this.writeln(HtmlJavaInformationsReport.toBarWithAlert(javaInformations.getSystemCpuLoad(), null));
            this.writeln("</td> </tr>");
        }
        this.writeln("</table>");
    }

    private void writeDetails(JavaInformations javaInformations, boolean repeatHost) throws IOException {
        String columnEnd = "</td></tr>";
        this.writeln("<table align='left' border='0' summary='#Details_systeme#'>");
        if (repeatHost) {
            this.writeln("<tr><td>#Host#: </td><td><b>" + javaInformations.getHost() + "</b>" + "</td></tr>");
        }
        this.writeln("<tr><td>#OS#: </td><td>");
        String osIconName = HtmlJavaInformationsReport.getOSIconName(javaInformations.getOS());
        if (osIconName != null) {
            this.writeln("<img src='?resource=servers/" + osIconName + "' alt='#OS#'/>");
        }
        this.writeln(javaInformations.getOS() + " (" + javaInformations.getAvailableProcessors() + " #coeurs#)" + "</td></tr>");
        this.writeln("<tr><td>#Java#: </td><td>" + javaInformations.getJavaVersion() + "</td></tr>");
        this.write("<tr><td>#JVM#: </td><td>" + javaInformations.getJvmVersion());
        if (javaInformations.getJvmVersion().contains("Client")) {
            this.write("&nbsp;&nbsp;&nbsp;<img src='?resource=alert.png' alt=\"#Client_JVM#\" title=\"#Client_JVM#\"/>");
        }
        this.writeln("</td></tr>");
        this.writeln("<tr><td>#PID#: </td><td>" + javaInformations.getPID() + "</td></tr>");
        long unixOpenFileDescriptorCount = javaInformations.getUnixOpenFileDescriptorCount();
        if (unixOpenFileDescriptorCount >= 0L) {
            long unixMaxFileDescriptorCount = javaInformations.getUnixMaxFileDescriptorCount();
            this.write("<tr><td>#nb_fichiers#</td><td>");
            this.writeGraph("fileDescriptors", this.integerFormat.format(unixOpenFileDescriptorCount));
            this.writeln(" / " + this.integerFormat.format(unixMaxFileDescriptorCount) + "&nbsp;&nbsp;&nbsp;");
            this.writeln(HtmlJavaInformationsReport.toBarWithAlert(javaInformations.getUnixOpenFileDescriptorPercentage(), null));
            this.writeln("</td></tr>");
        }
        this.writeServerInfoAndContextPath(javaInformations);
        this.writeln("<tr><td>#Demarrage#: </td><td>" + I18N.createDateAndTimeFormat().format(javaInformations.getStartDate()) + "</td></tr>");
        this.write("<tr><td valign='top'>#Arguments_JVM#: </td><td>");
        this.writeDirectly(HtmlJavaInformationsReport.htmlEncodeButNotSpace(javaInformations.getJvmArguments()) + "</td></tr>");
        this.writeln("");
        if (javaInformations.getSessionCount() >= 0) {
            this.write("<tr><td>#httpSessionsMeanAge#: </td><td>");
            this.writeGraph("httpSessionsMeanAge", this.integerFormat.format(javaInformations.getSessionMeanAgeInMinutes()));
            this.writeln("</td></tr>");
        }
        this.writeTomcatInformations(javaInformations.getTomcatInformationsList());
        this.writeMemoryInformations(javaInformations.getMemoryInformations());
        this.writeln("<tr><td>#Free_disk_space#: </td><td>" + this.integerFormat.format(javaInformations.getFreeDiskSpaceInTemp() / 1024L / 1024L) + " #Mo# " + "</td></tr>");
        this.writeln("<tr><td>#Usable_disk_space#: </td><td>" + this.integerFormat.format(javaInformations.getUsableDiskSpaceInTemp() / 1024L / 1024L) + " #Mo# " + "</td></tr>");
        this.writeDatabaseVersionAndDataSourceDetails(javaInformations);
        this.writeln("<tr><td valign='top'><div class='noPrint'>#Dependencies#: </div></td><td>");
        this.writeDependencies(javaInformations);
        this.writeln("</td></tr>");
        this.writeln("</table>");
    }

    private void writeServerInfoAndContextPath(JavaInformations javaInformations) throws IOException {
        String serverInfo = javaInformations.getServerInfo();
        if (serverInfo != null) {
            String columnEnd = " </td></tr>";
            this.writeln("<tr><td>#Serveur#: </td><td>");
            String applicationServerIconName = HtmlJavaInformationsReport.getApplicationServerIconName(serverInfo);
            if (applicationServerIconName != null) {
                this.writeln("<img src='?resource=servers/" + applicationServerIconName + "' alt='#Serveur#'/>");
            }
            this.writeDirectly(serverInfo + " </td></tr>");
            this.writeln("<tr><td>#Contexte_webapp#: </td><td>" + javaInformations.getContextPath() + " </td></tr>");
        }
    }

    private void writeDatabaseVersionAndDataSourceDetails(JavaInformations javaInformations) throws IOException {
        String columnEnd = "</td></tr>";
        if (!this.noDatabase && javaInformations.getDataBaseVersion() != null) {
            this.writeln("<tr><td valign='top'>#Base_de_donnees#: </td><td>");
            this.writeDirectly(HtmlJavaInformationsReport.htmlEncodeButNotSpace(javaInformations.getDataBaseVersion()));
            this.writeln("</td></tr>");
        }
        if (javaInformations.getDataSourceDetails() != null) {
            this.writeln("<tr><td valign='top'>#DataSource_jdbc#: </td><td>");
            this.writeDirectly(HtmlJavaInformationsReport.htmlEncodeButNotSpace(javaInformations.getDataSourceDetails()));
            this.writeDirectly("<a href='http://commons.apache.org/proper/commons-dbcp/configuration.html' class='noPrint' target='_blank'>DataSource reference</a>");
            this.writeln("</td></tr>");
        }
    }

    public static String getOSIconName(String os) {
        String tmp = os.toLowerCase(Locale.ENGLISH);
        for (String anOS : OS) {
            if (!tmp.contains(anOS)) continue;
            return anOS + ".png";
        }
        return null;
    }

    public static String getApplicationServerIconName(String appServer) {
        String tmp = appServer.toLowerCase(Locale.ENGLISH);
        for (String applicationServer : APPLICATION_SERVERS) {
            if (!tmp.contains(applicationServer)) continue;
            return applicationServer + ".png";
        }
        return null;
    }

    private void writeTomcatInformations(List<TomcatInformations> tomcatInformationsList) throws IOException {
        ArrayList<TomcatInformations> list = new ArrayList<TomcatInformations>();
        for (TomcatInformations tomcatInformations : tomcatInformationsList) {
            if (tomcatInformations.getRequestCount() <= 0) continue;
            list.add(tomcatInformations);
        }
        boolean onlyOne = list.size() == 1;
        for (TomcatInformations tomcatInformations : list) {
            this.writeDirectly("<tr><td valign='top'>Tomcat " + HtmlJavaInformationsReport.htmlEncodeButNotSpace(tomcatInformations.getName()) + ": </td><td>");
            int currentThreadsBusy = tomcatInformations.getCurrentThreadsBusy();
            this.writeln("#busyThreads# = ");
            if (onlyOne) {
                this.writeGraph("tomcatBusyThreads", this.integerFormat.format(currentThreadsBusy));
            } else {
                this.writeln(this.integerFormat.format(currentThreadsBusy));
            }
            this.writeln(" /  " + this.integerFormat.format(tomcatInformations.getMaxThreads()));
            this.writeln("&nbsp;&nbsp;&nbsp;");
            this.writeln(HtmlJavaInformationsReport.toBarWithAlert(100.0 * (double)currentThreadsBusy / (double)tomcatInformations.getMaxThreads(), null));
            this.writeln("<br/>#bytesReceived# = ");
            if (onlyOne) {
                this.writeGraph("tomcatBytesReceived", this.integerFormat.format(tomcatInformations.getBytesReceived()));
            } else {
                this.writeln(this.integerFormat.format(tomcatInformations.getBytesReceived()));
            }
            this.writeln("<br/>#bytesSent# = ");
            if (onlyOne) {
                this.writeGraph("tomcatBytesSent", this.integerFormat.format(tomcatInformations.getBytesSent()));
            } else {
                this.writeln(this.integerFormat.format(tomcatInformations.getBytesSent()));
            }
            this.writeln("<br/>#requestCount# = ");
            this.writeln(this.integerFormat.format(tomcatInformations.getRequestCount()));
            this.writeln("<br/>#errorCount# = ");
            this.writeln(this.integerFormat.format(tomcatInformations.getErrorCount()));
            this.writeln("<br/>#processingTime# = ");
            this.writeln(this.integerFormat.format(tomcatInformations.getProcessingTime()));
            this.writeln("<br/>#maxProcessingTime# = ");
            this.writeln(this.integerFormat.format(tomcatInformations.getMaxTime()));
            this.writeln("</td> </tr>");
        }
    }

    private void writeMemoryInformations(MemoryInformations memoryInformations) throws IOException {
        String columnEnd = "</td></tr>";
        String memoryDetails = memoryInformations.getMemoryDetails();
        this.writeln("<tr><td valign='top'>#Gestion_memoire#: </td><td>" + HtmlJavaInformationsReport.htmlEncodeButNotSpace(memoryDetails).replace(" Mo", " #Mo#") + "</td></tr>");
        long usedPermGen = memoryInformations.getUsedPermGen();
        if (usedPermGen > 0L) {
            long maxPermGen = memoryInformations.getMaxPermGen();
            this.writeln("<tr><td>#Memoire_Perm_Gen#: </td><td>" + this.integerFormat.format(usedPermGen / 1024L / 1024L) + " #Mo#");
            if (maxPermGen > 0L) {
                this.writeln(" / " + this.integerFormat.format(maxPermGen / 1024L / 1024L) + " #Mo#&nbsp;&nbsp;&nbsp;");
                this.writeln(HtmlJavaInformationsReport.toBarWithAlert(memoryInformations.getUsedPermGenPercentage(), "-XX:MaxPermSize"));
            }
            this.writeln("</td></tr>");
        }
    }

    private void writeDependencies(JavaInformations javaInformations) throws IOException {
        this.writeln("<a href='?part=dependencies' class='noPrint'>");
        this.writeln("<img src='?resource=beans.png' width='14' height='14' alt='#Dependencies#'/> #Dependencies#</a>");
        if (javaInformations.doesPomXmlExists() && Parameters.isSystemActionsEnabled()) {
            this.writeln("&nbsp;&nbsp;&nbsp;");
            this.writeln("<a href='?part=pom.xml' class='noPrint'>");
            this.writeln("<img src='?resource=xml.png' width='14' height='14' alt=\"#pom.xml#\"/> #pom.xml#</a>");
        }
    }

    private void writeGraph(String graph, String value) throws IOException {
        if (this.javaInformationsList.size() > 1) {
            this.write(value);
            return;
        }
        String id = "id" + graph;
        this.write("<a class='tooltip replaceImage' href='?part=graph&amp;graph=");
        this.write(graph);
        this.write("' data-img-id='");
        this.write(id);
        this.write("' data-img-src='?graph=");
        this.write(graph);
        this.write("&amp;width=100&amp;height=50'>");
        this.write("<em><img src='?resource=systeminfo.png' id='");
        this.write(id);
        this.write("' alt='graph'/></em>");
        this.writeDirectly(value);
        this.write("</a>");
    }

    static String toBar(double percentValue) {
        double myPercent = Math.max(Math.min(percentValue, 100.0), 0.0);
        StringBuilder sb = new StringBuilder();
        String body = "<img src=''?resource=bar/rb_{0}.gif'' alt=''+'' title=''" + I18N.createPercentFormat().format(myPercent) + "%'' />";
        int fullBlockCount = (int)Math.floor(myPercent / 10.0);
        int partialBlockIndex = (int)Math.floor((myPercent - (double)fullBlockCount * 2.0 * 5.0) / 2.0);
        sb.append(MessageFormat.format(body, fullBlockCount > 0 || partialBlockIndex > 0 ? "a" : "a0"));
        String fullBody = MessageFormat.format(body, 5);
        for (int i = 0; i < fullBlockCount; ++i) {
            sb.append(fullBody);
        }
        if (partialBlockIndex > 0) {
            String partialBody = MessageFormat.format(body, partialBlockIndex);
            sb.append(partialBody);
        }
        int emptyBlocks = 10 - fullBlockCount - (partialBlockIndex > 0 ? 1 : 0);
        String emptyBody = MessageFormat.format(body, 0);
        for (int i = 0; i < emptyBlocks; ++i) {
            sb.append(emptyBody);
        }
        sb.append(MessageFormat.format(body, fullBlockCount == 10 ? "b" : "b0"));
        return sb.toString();
    }

    static String toBarWithAlert(double percentValue, String configurationDetail) {
        String result = HtmlJavaInformationsReport.toBar(percentValue);
        if (percentValue >= 95.0) {
            String message = HtmlJavaInformationsReport.getString("High_usage");
            if (configurationDetail != null) {
                message = message + " (" + configurationDetail + ')';
            }
            result = result + "&nbsp;&nbsp;&nbsp;<img src='?resource=alert.png' alt=\"" + message + "\" title=\"" + message + "\"/>";
        }
        return result;
    }
}

