/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.model.HeapHistogram;
import net.bull.javamelody.internal.web.pdf.PdfAbstractTableReport;
import net.bull.javamelody.internal.web.pdf.PdfFonts;

class PdfHeapHistogramReport
extends PdfAbstractTableReport {
    private final HeapHistogram heapHistogram;
    private final DecimalFormat integerFormat = I18N.createIntegerFormat();
    private final Font cellFont = PdfFonts.TABLE_CELL.getFont();
    private final Font boldFont = PdfFonts.BOLD_CELL.getFont();

    PdfHeapHistogramReport(HeapHistogram heapHistogram, Document document) {
        super(document);
        assert (heapHistogram != null);
        this.heapHistogram = heapHistogram;
    }

    @Override
    void toPdf() throws DocumentException {
        this.addToDocument((Element)new Phrase(PdfHeapHistogramReport.getString("Heap"), this.boldFont));
        List<HeapHistogram.ClassInfo> heap = this.heapHistogram.getHeapHistogram();
        long totalHeapInstances = this.heapHistogram.getTotalHeapInstances();
        long totalHeapBytes = this.heapHistogram.getTotalHeapBytes();
        String separator = ",   ";
        this.addToDocument((Element)new Phrase("     " + PdfHeapHistogramReport.getString("Classes") + ": " + this.integerFormat.format(heap.size()) + ",   " + PdfHeapHistogramReport.getString("Instances") + ": " + this.integerFormat.format(totalHeapInstances) + ",   " + PdfHeapHistogramReport.getString("Kilo-Octets") + ": " + this.integerFormat.format(totalHeapBytes / 1024L), this.cellFont));
        this.writeHeader(this.heapHistogram.isSourceDisplayed());
        this.writeClassInfo(heap, totalHeapInstances, totalHeapBytes, this.heapHistogram.isSourceDisplayed());
        List<HeapHistogram.ClassInfo> permGen = this.heapHistogram.getPermGenHistogram();
        if (!permGen.isEmpty()) {
            this.addToDocument((Element)new Phrase("\n\n" + PdfHeapHistogramReport.getString("PermGen"), this.boldFont));
            long totalPermGenInstances = this.heapHistogram.getTotalPermGenInstances();
            long totalPermGenBytes = this.heapHistogram.getTotalPermGenBytes();
            this.addToDocument((Element)new Phrase("     " + PdfHeapHistogramReport.getString("Classes") + ": " + this.integerFormat.format(permGen.size()) + ",   " + PdfHeapHistogramReport.getString("Instances") + ": " + this.integerFormat.format(totalPermGenInstances) + ",   " + PdfHeapHistogramReport.getString("Kilo-Octets") + ": " + this.integerFormat.format(totalPermGenBytes / 1024L), this.cellFont));
            this.writeHeader(false);
            this.writeClassInfo(permGen, totalPermGenInstances, totalPermGenBytes, false);
        }
    }

    private void writeHeader(boolean sourceDisplayed) throws DocumentException {
        List<String> headers = this.createHeaders(sourceDisplayed);
        int[] relativeWidths = new int[headers.size()];
        Arrays.fill(relativeWidths, 0, headers.size(), 1);
        relativeWidths[0] = 6;
        if (sourceDisplayed) {
            relativeWidths[headers.size() - 1] = 6;
        }
        this.initTable(headers, relativeWidths);
    }

    private List<String> createHeaders(boolean sourceDisplayed) {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(PdfHeapHistogramReport.getString("Classe"));
        headers.add(PdfHeapHistogramReport.getString("Taille"));
        headers.add(PdfHeapHistogramReport.getString("pct_taille"));
        headers.add(PdfHeapHistogramReport.getString("Instances"));
        headers.add(PdfHeapHistogramReport.getString("pct_instances"));
        if (sourceDisplayed) {
            headers.add(PdfHeapHistogramReport.getString("Source"));
        }
        return headers;
    }

    private void writeClassInfo(List<HeapHistogram.ClassInfo> classHistogram, long totalInstances, long totalBytes, boolean sourceDisplayed) throws DocumentException {
        for (HeapHistogram.ClassInfo classInfo : classHistogram) {
            this.nextRow();
            this.writeClassInfoRow(classInfo, totalInstances, totalBytes, sourceDisplayed);
        }
        this.addTableToDocument();
    }

    private void writeClassInfoRow(HeapHistogram.ClassInfo classInfo, long totalInstances, long totalBytes, boolean sourceDisplayed) {
        PdfPCell defaultCell = this.getDefaultCell();
        defaultCell.setHorizontalAlignment(0);
        this.addCell(classInfo.getName());
        defaultCell.setHorizontalAlignment(2);
        long bytes = classInfo.getBytes();
        long instancesCount = classInfo.getInstancesCount();
        this.addCell(this.integerFormat.format(bytes / 1024L));
        this.addCell(this.integerFormat.format(bytes * 100L / totalBytes));
        this.addCell(this.integerFormat.format(instancesCount));
        this.addCell(this.integerFormat.format(instancesCount * 100L / totalInstances));
        defaultCell.setHorizontalAlignment(0);
        if (sourceDisplayed) {
            String source = classInfo.getSource();
            if (source == null) {
                this.addCell("");
            } else {
                this.addCell(source);
            }
        }
    }
}

