/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.lowagie.text.Anchor;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.bull.javamelody.CacheInformations;
import net.bull.javamelody.HtmlCacheInformationsReport;
import net.bull.javamelody.I18N;
import net.bull.javamelody.PdfDocumentFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PdfCacheInformationsReport {
    private final List<CacheInformations> cacheInformationsList;
    private final Document document;
    private final DecimalFormat integerFormat = I18N.createIntegerFormat();
    private final Font cellFont = PdfDocumentFactory.TABLE_CELL_FONT;
    private PdfPTable currentTable;
    private final boolean hitsRatioEnabled;
    private final boolean configurationEnabled;

    PdfCacheInformationsReport(List<CacheInformations> cacheInformationsList, Document document) {
        assert (cacheInformationsList != null);
        assert (document != null);
        this.cacheInformationsList = cacheInformationsList;
        this.document = document;
        this.hitsRatioEnabled = HtmlCacheInformationsReport.isHitsRatioEnabled(cacheInformationsList);
        this.configurationEnabled = HtmlCacheInformationsReport.isConfigurationEnabled(cacheInformationsList);
    }

    void toPdf() throws DocumentException {
        this.writeHeader();
        PdfPCell defaultCell = this.getDefaultCell();
        boolean odd = false;
        for (CacheInformations cacheInformations : this.cacheInformationsList) {
            if (odd) {
                defaultCell.setGrayFill(0.97f);
            } else {
                defaultCell.setGrayFill(1.0f);
            }
            odd = !odd;
            this.writeCacheInformations(cacheInformations);
        }
        this.document.add((Element)this.currentTable);
        Anchor anchor = new Anchor("Configuration reference", PdfDocumentFactory.BLUE_FONT);
        anchor.setName("Ehcache configuration reference");
        anchor.setReference("http://ehcache.sourceforge.net/apidocs/net/sf/ehcache/config/CacheConfiguration.html#field_summary");
        anchor.setFont(PdfDocumentFactory.BLUE_FONT);
        Paragraph paragraph = new Paragraph();
        paragraph.add((Object)anchor);
        paragraph.setAlignment(2);
        this.document.add((Element)paragraph);
    }

    private void writeHeader() throws DocumentException {
        List<String> headers = this.createHeaders();
        int[] relativeWidths = new int[headers.size()];
        Arrays.fill(relativeWidths, 0, headers.size(), 1);
        if (this.configurationEnabled) {
            relativeWidths[headers.size() - 1] = 4;
        }
        this.currentTable = PdfDocumentFactory.createPdfPTable(headers, relativeWidths);
    }

    private List<String> createHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(PdfCacheInformationsReport.getI18nString("Cache"));
        headers.add(PdfCacheInformationsReport.getI18nString("Nb_objets_en_memoire"));
        headers.add(PdfCacheInformationsReport.getI18nString("Nb_objets_sur_disque"));
        if (this.hitsRatioEnabled) {
            headers.add(PdfCacheInformationsReport.getI18nString("Efficacite_cache_memoire"));
            headers.add(PdfCacheInformationsReport.getI18nString("Efficacite_cache"));
        }
        if (this.configurationEnabled) {
            headers.add(PdfCacheInformationsReport.getI18nString("Configuration"));
        }
        return headers;
    }

    private void writeCacheInformations(CacheInformations cacheInformations) {
        PdfPCell defaultCell = this.getDefaultCell();
        defaultCell.setHorizontalAlignment(0);
        this.addCell(cacheInformations.getName());
        defaultCell.setHorizontalAlignment(2);
        this.addCell(this.integerFormat.format(cacheInformations.getInMemoryObjectCount()));
        this.addCell(this.integerFormat.format(cacheInformations.getOnDiskObjectCount()));
        if (this.hitsRatioEnabled) {
            this.addCell(this.integerFormat.format(cacheInformations.getInMemoryHitsRatio()));
            this.addCell(this.integerFormat.format(cacheInformations.getHitsRatio()));
        }
        if (this.configurationEnabled) {
            defaultCell.setHorizontalAlignment(0);
            this.addCell(cacheInformations.getConfiguration());
        }
    }

    private static String getI18nString(String key) {
        return I18N.getString(key);
    }

    private PdfPCell getDefaultCell() {
        return this.currentTable.getDefaultCell();
    }

    private void addCell(String string) {
        this.currentTable.addCell(new Phrase(string, this.cellFont));
    }
}

