/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import net.bull.javamelody.Counter;
import net.bull.javamelody.CounterStorage;
import net.bull.javamelody.Parameters;

class PeriodCounterFactory {
    private final Counter currentDayCounter;

    PeriodCounterFactory(Counter currentDayCounter) {
        assert (currentDayCounter != null);
        this.currentDayCounter = currentDayCounter;
    }

    Counter buildNewDayCounter() throws IOException {
        PeriodCounterFactory.deleteObsoleteCounterFiles(this.currentDayCounter.getApplication());
        Calendar start = Calendar.getInstance();
        start.setTime(this.currentDayCounter.getStartDate());
        if (start.get(2) != Calendar.getInstance().get(2)) {
            this.getMonthCounterAtDate(this.currentDayCounter.getStartDate());
        }
        return this.createDayCounterAtDate(new Date());
    }

    private Counter getDayCounterAtDate(Date day) {
        Counter dayCounter = this.createDayCounterAtDate(day);
        try {
            dayCounter.readFromFile();
        }
        catch (IOException e) {
            PeriodCounterFactory.printStackTrace(e);
        }
        return dayCounter;
    }

    Counter getWeekCounter() {
        Counter weekCounter = this.createPeriodCounter("yyyyWW", this.currentDayCounter.getStartDate());
        weekCounter.addRequestsAndErrors(this.currentDayCounter);
        Calendar dayCalendar = Calendar.getInstance();
        dayCalendar.setTime(this.currentDayCounter.getStartDate());
        for (int i = 1; i < 7; ++i) {
            dayCalendar.add(6, -1);
            weekCounter.addRequestsAndErrors(this.getDayCounterAtDate(dayCalendar.getTime()));
        }
        weekCounter.setStartDate(dayCalendar.getTime());
        return weekCounter;
    }

    Counter getMonthCounter() {
        Counter monthCounter = this.createMonthCounterAtDate(this.currentDayCounter.getStartDate());
        monthCounter.addRequestsAndErrors(this.currentDayCounter);
        Calendar dayCalendar = Calendar.getInstance();
        dayCalendar.setTime(this.currentDayCounter.getStartDate());
        for (int i = 1; i < 31; ++i) {
            dayCalendar.add(6, -1);
            monthCounter.addRequestsAndErrors(this.getDayCounterAtDate(dayCalendar.getTime()));
        }
        monthCounter.setStartDate(dayCalendar.getTime());
        return monthCounter;
    }

    Counter getYearCounter() throws IOException {
        Counter yearCounter = this.createPeriodCounter("yyyy", this.currentDayCounter.getStartDate());
        yearCounter.addRequestsAndErrors(this.currentDayCounter);
        Calendar dayCalendar = Calendar.getInstance();
        int currentMonth = dayCalendar.get(2);
        dayCalendar.setTime(this.currentDayCounter.getStartDate());
        dayCalendar.add(6, -365);
        yearCounter.setStartDate(dayCalendar.getTime());
        for (int i = 1; i < 366; ++i) {
            if (dayCalendar.get(5) == 1 && dayCalendar.get(2) != currentMonth) {
                yearCounter.addRequestsAndErrors(this.getMonthCounterAtDate(dayCalendar.getTime()));
                int nbDaysInMonth = dayCalendar.getActualMaximum(5);
                dayCalendar.add(6, nbDaysInMonth - 1);
                i += nbDaysInMonth - 1;
            } else {
                yearCounter.addRequestsAndErrors(this.getDayCounterAtDate(dayCalendar.getTime()));
            }
            dayCalendar.add(6, 1);
        }
        return yearCounter;
    }

    private Counter getMonthCounterAtDate(Date day) throws IOException {
        Counter monthCounter = this.createMonthCounterAtDate(day);
        try {
            Counter readCounter = new CounterStorage(monthCounter).readFromFile();
            if (readCounter != null) {
                return readCounter;
            }
        }
        catch (IOException e) {
            PeriodCounterFactory.printStackTrace(e);
        }
        Calendar dayCalendar = Calendar.getInstance();
        dayCalendar.setTime(day);
        int nbDaysInMonth = dayCalendar.getActualMaximum(5);
        for (int i = 1; i <= nbDaysInMonth; ++i) {
            dayCalendar.set(5, i);
            monthCounter.addRequestsAndErrors(this.getDayCounterAtDate(dayCalendar.getTime()));
        }
        monthCounter.writeToFile();
        return monthCounter;
    }

    Counter createDayCounterAtDate(Date day) {
        return this.createPeriodCounter("yyyyMMdd", day);
    }

    private Counter createMonthCounterAtDate(Date day) {
        return this.createPeriodCounter("yyyyMM", day);
    }

    private Counter createPeriodCounter(String dateFormatPattern, Date date) {
        String storageName = this.currentDayCounter.getName() + '_' + new SimpleDateFormat(dateFormatPattern, Locale.getDefault()).format(date);
        Counter result = new Counter(this.currentDayCounter.getName(), storageName, this.currentDayCounter.getIconName(), this.currentDayCounter.getChildCounterName());
        result.setApplication(this.currentDayCounter.getApplication());
        result.setDisplayed(this.currentDayCounter.isDisplayed());
        result.setRequestTransformPattern(this.currentDayCounter.getRequestTransformPattern());
        result.setMaxRequestsCount(this.currentDayCounter.getMaxRequestsCount());
        return result;
    }

    private static boolean deleteObsoleteCounterFiles(String application) {
        File storageDir = Parameters.getStorageDirectory(application);
        Calendar nowMinusOneYearAndADay = Calendar.getInstance();
        nowMinusOneYearAndADay.add(1, -1);
        nowMinusOneYearAndADay.add(6, -1);
        boolean result = true;
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".ser.gz");
            }
        };
        for (File file : storageDir.listFiles(filenameFilter)) {
            if (file.lastModified() >= nowMinusOneYearAndADay.getTimeInMillis()) continue;
            result = result && file.delete();
        }
        return result;
    }

    private static void printStackTrace(Throwable t) {
        t.printStackTrace(System.err);
    }
}

