/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.bull.javamelody.FilterContext;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.JspWrapper;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.PayloadNameRequestWrapper;
import net.bull.javamelody.internal.common.HttpParameter;
import net.bull.javamelody.internal.common.HttpPart;
import net.bull.javamelody.internal.common.LOG;
import net.bull.javamelody.internal.common.Parameters;
import net.bull.javamelody.internal.model.Collector;
import net.bull.javamelody.internal.model.Counter;
import net.bull.javamelody.internal.model.CounterError;
import net.bull.javamelody.internal.model.CounterRequestContext;
import net.bull.javamelody.internal.model.LabradorRetriever;
import net.bull.javamelody.internal.model.ThreadInformations;
import net.bull.javamelody.internal.web.CounterServletResponseWrapper;
import net.bull.javamelody.internal.web.HttpAuth;
import net.bull.javamelody.internal.web.MonitoringController;
import net.bull.javamelody.internal.web.RumInjector;

public class MonitoringFilter
implements Filter {
    private static boolean instanceCreated;
    private static final List<String> CONTEXT_PATHS;
    private static URL unregisterApplicationNodeInCollectServerUrl;
    private boolean instanceEnabled;
    private String applicationType = "Classic";
    private Counter httpCounter;
    private Counter errorCounter;
    private boolean monitoringDisabled;
    private boolean logEnabled;
    private boolean rumEnabled;
    private Pattern urlExcludePattern;
    private FilterContext filterContext;
    private HttpAuth httpAuth;
    private FilterConfig filterConfig;
    private String monitoringUrl;
    private boolean servletApi2;

    public MonitoringFilter() {
        if (instanceCreated) {
            this.instanceEnabled = false;
        } else {
            this.instanceEnabled = true;
            MonitoringFilter.setInstanceCreated(true);
        }
    }

    private static void setInstanceCreated(boolean newInstanceCreated) {
        instanceCreated = newInstanceCreated;
    }

    public String getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(String applicationType) {
        this.applicationType = applicationType;
    }

    public void init(FilterConfig config) throws ServletException {
        long start = System.currentTimeMillis();
        String contextPath = Parameters.getContextPath(config.getServletContext());
        if (!this.instanceEnabled) {
            if (!CONTEXT_PATHS.contains(contextPath)) {
                this.instanceEnabled = true;
            } else {
                return;
            }
        }
        CONTEXT_PATHS.add(contextPath);
        this.filterConfig = config;
        this.servletApi2 = config.getServletContext().getMajorVersion() < 3;
        Parameters.initialize(config);
        this.monitoringDisabled = Parameter.DISABLED.getValueAsBoolean();
        if (this.monitoringDisabled) {
            return;
        }
        LOG.debug("JavaMelody filter init started");
        this.filterContext = new FilterContext(this.getApplicationType());
        this.httpAuth = new HttpAuth();
        config.getServletContext().setAttribute("javamelody.filterContext", (Object)this.filterContext);
        Collector collector = this.filterContext.getCollector();
        this.httpCounter = collector.getCounterByName("http");
        this.errorCounter = collector.getCounterByName("error");
        this.logEnabled = Parameter.LOG.getValueAsBoolean();
        this.rumEnabled = Parameter.RUM_ENABLED.getValueAsBoolean();
        if (Parameter.URL_EXCLUDE_PATTERN.getValue() != null) {
            this.urlExcludePattern = Pattern.compile(Parameter.URL_EXCLUDE_PATTERN.getValue());
        }
        long duration = System.currentTimeMillis() - start;
        LOG.debug("JavaMelody filter init done in " + duration + " ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.monitoringDisabled || !this.instanceEnabled) {
            return;
        }
        long start = System.currentTimeMillis();
        try {
            if (this.filterContext != null) {
                this.filterContext.destroy();
            }
        }
        finally {
            String contextPath = Parameters.getContextPath(this.filterConfig.getServletContext());
            CONTEXT_PATHS.remove(contextPath);
            this.httpCounter = null;
            this.errorCounter = null;
            this.urlExcludePattern = null;
            this.filterConfig = null;
            this.filterContext = null;
        }
        long duration = System.currentTimeMillis() - start;
        LOG.debug("JavaMelody filter destroy done in " + duration + " ms");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse) || this.monitoringDisabled || !this.instanceEnabled) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (httpRequest.getRequestURI().equals(this.getMonitoringUrl(httpRequest))) {
            this.doMonitoring(httpRequest, httpResponse);
            return;
        }
        if (!this.httpCounter.isDisplayed() || this.isRequestExcluded((HttpServletRequest)request)) {
            chain.doFilter(request, response);
            return;
        }
        this.doFilter(chain, httpRequest, httpResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFilter(FilterChain chain, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        long start = System.currentTimeMillis();
        long startCpuTime = ThreadInformations.getCurrentThreadCpuTime();
        long startAllocatedBytes = ThreadInformations.getCurrentThreadAllocatedBytes();
        CounterServletResponseWrapper wrappedResponse = this.createResponseWrapper(httpRequest, httpResponse);
        HttpServletRequest wrappedRequest = this.createRequestWrapper(httpRequest, (HttpServletResponse)wrappedResponse);
        boolean systemError = false;
        Throwable systemException = null;
        String requestName = this.getRequestName(wrappedRequest);
        String completeRequestName = MonitoringFilter.getCompleteRequestName(wrappedRequest, true);
        try {
            JdbcWrapper.ACTIVE_THREAD_COUNT.incrementAndGet();
            this.httpCounter.bindContext(requestName, completeRequestName, httpRequest, startCpuTime, startAllocatedBytes);
            httpRequest.setAttribute("javamelody.request", (Object)completeRequestName);
            CounterError.bindRequest(httpRequest);
            chain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)wrappedResponse);
            if (this.servletApi2 || !httpRequest.isAsyncStarted()) {
                wrappedResponse.flushStream();
            }
        }
        catch (Throwable t) {
            systemException = t;
            MonitoringFilter.throwException(t);
        }
        finally {
            if (this.httpCounter == null) {
                return;
            }
            try {
                long duration = Math.max(System.currentTimeMillis() - start, 0L);
                int cpuUsedMillis = (int)((ThreadInformations.getCurrentThreadCpuTime() - startCpuTime) / 1000000L);
                int allocatedKBytes = startAllocatedBytes >= 0L ? (int)((ThreadInformations.getCurrentThreadAllocatedBytes() - startAllocatedBytes) / 1024L) : -1;
                JdbcWrapper.ACTIVE_THREAD_COUNT.decrementAndGet();
                this.putUserInfoInSession(httpRequest);
                if (systemException != null) {
                    systemError = true;
                    StringWriter stackTrace = new StringWriter(200);
                    systemException.printStackTrace(new PrintWriter(stackTrace));
                    this.errorCounter.addRequestForSystemError(systemException.toString(), duration, cpuUsedMillis, allocatedKBytes, stackTrace.toString());
                } else if (wrappedResponse.getCurrentStatus() >= 400 && wrappedResponse.getCurrentStatus() != 401) {
                    systemError = true;
                    this.errorCounter.addRequestForSystemError("Error" + wrappedResponse.getCurrentStatus(), duration, cpuUsedMillis, allocatedKBytes, null);
                }
                requestName = CounterRequestContext.getHttpRequestName(httpRequest, requestName);
                long responseSize = wrappedResponse.getDataLength();
                if (wrappedResponse.getCurrentStatus() == 404) {
                    requestName = "Error404";
                }
                this.httpCounter.addRequest(requestName, duration, cpuUsedMillis, allocatedKBytes, systemError, responseSize);
                this.log(httpRequest, requestName, duration, systemError, wrappedResponse.getCurrentStatus(), responseSize);
            }
            finally {
                this.httpCounter.unbindContext();
                CounterError.unbindRequest();
            }
        }
    }

    protected CounterServletResponseWrapper createResponseWrapper(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        HttpServletResponse httpResponse2 = httpResponse;
        if (this.rumEnabled) {
            httpResponse2 = RumInjector.createRumResponseWrapper(httpRequest, httpResponse, this.getRequestName(httpRequest));
        }
        return new CounterServletResponseWrapper(httpResponse2);
    }

    protected HttpServletRequest createRequestWrapper(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Object wrappedRequest = JspWrapper.createHttpRequestWrapper(request, response);
        PayloadNameRequestWrapper payloadNameRequestWrapper = new PayloadNameRequestWrapper((HttpServletRequest)wrappedRequest);
        payloadNameRequestWrapper.initialize();
        if (payloadNameRequestWrapper.getPayloadRequestType() != null) {
            wrappedRequest = payloadNameRequestWrapper;
        }
        return wrappedRequest;
    }

    protected String getRequestName(HttpServletRequest request) {
        return MonitoringFilter.getCompleteRequestName(request, false);
    }

    protected String getMonitoringUrl(HttpServletRequest httpRequest) {
        if (this.monitoringUrl == null) {
            this.monitoringUrl = httpRequest.getContextPath() + Parameters.getMonitoringPath();
        }
        return this.monitoringUrl;
    }

    private void putUserInfoInSession(HttpServletRequest httpRequest) {
        String remoteUser;
        HttpSession session = httpRequest.getSession(false);
        if (session == null) {
            return;
        }
        if (session.getAttribute("javamelody.country") == null) {
            Locale locale = httpRequest.getLocale();
            if (!locale.getCountry().isEmpty()) {
                session.setAttribute("javamelody.country", (Object)locale.getCountry());
            } else {
                session.setAttribute("javamelody.country", (Object)locale.getLanguage());
            }
        }
        if (session.getAttribute("javamelody.remoteAddr") == null) {
            String forwardedFor = httpRequest.getHeader("X-Forwarded-For");
            String remoteAddr = forwardedFor == null ? httpRequest.getRemoteAddr() : httpRequest.getRemoteAddr() + " forwarded for " + forwardedFor;
            session.setAttribute("javamelody.remoteAddr", (Object)remoteAddr);
        }
        if (session.getAttribute("javamelody.remoteUser") == null && (remoteUser = httpRequest.getRemoteUser()) != null) {
            session.setAttribute("javamelody.remoteUser", (Object)remoteUser);
        }
        if (session.getAttribute("javamelody.userAgent") == null) {
            String userAgent = httpRequest.getHeader("User-Agent");
            session.setAttribute("javamelody.userAgent", (Object)userAgent);
        }
    }

    private void doMonitoring(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        if (this.isRumMonitoring(httpRequest, httpResponse)) {
            return;
        }
        if (!this.isAllowed(httpRequest, httpResponse)) {
            return;
        }
        Collector collector = this.filterContext.getCollector();
        MonitoringController monitoringController = new MonitoringController(collector, null);
        monitoringController.doActionIfNeededAndReport(httpRequest, httpResponse, this.filterConfig.getServletContext());
        if ("stop".equalsIgnoreCase(HttpParameter.COLLECTOR.getParameterFrom(httpRequest))) {
            for (Counter counter : collector.getCounters()) {
                counter.clear();
            }
            if (!collector.isStopped()) {
                LOG.debug("Stopping the javamelody collector in this webapp, because a collector server from " + httpRequest.getRemoteAddr() + " wants to collect the data itself");
                this.filterContext.stopCollector();
            }
        }
    }

    protected final boolean isRumMonitoring(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        if (this.rumEnabled) {
            if (RumInjector.isRumResource(HttpParameter.RESOURCE.getParameterFrom(httpRequest))) {
                MonitoringController.doResource(httpResponse, HttpParameter.RESOURCE.getParameterFrom(httpRequest));
                return true;
            }
            if (HttpPart.RUM.isPart(httpRequest)) {
                MonitoringController.noCache(httpResponse);
                httpResponse.setContentType("image/png");
                RumInjector.addRumHit(httpRequest, this.httpCounter);
                return true;
            }
        }
        return false;
    }

    private static String getCompleteRequestName(HttpServletRequest httpRequest, boolean includeQueryString) {
        String tmp = httpRequest.getRequestURI().substring(httpRequest.getContextPath().length());
        int lastIndexOfSemiColon = tmp.lastIndexOf(59);
        if (lastIndexOfSemiColon != -1) {
            tmp = tmp.substring(0, lastIndexOfSemiColon);
        }
        String method = "XMLHttpRequest".equals(httpRequest.getHeader("X-Requested-With")) ? "ajax " + httpRequest.getMethod() : httpRequest.getMethod();
        if (!includeQueryString) {
            if (httpRequest instanceof PayloadNameRequestWrapper) {
                PayloadNameRequestWrapper wrapper = (PayloadNameRequestWrapper)httpRequest;
                return tmp + wrapper.getPayloadRequestName() + ' ' + wrapper.getPayloadRequestType();
            }
            return tmp + ' ' + method;
        }
        String queryString = httpRequest.getQueryString();
        if (queryString == null) {
            return tmp + ' ' + method;
        }
        return tmp + '?' + queryString + ' ' + method;
    }

    private boolean isRequestExcluded(HttpServletRequest httpRequest) {
        return this.urlExcludePattern != null && this.urlExcludePattern.matcher(httpRequest.getRequestURI().substring(httpRequest.getContextPath().length())).matches();
    }

    protected boolean isAllowed(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        return this.httpAuth.isAllowed(httpRequest, httpResponse);
    }

    protected void log(HttpServletRequest httpRequest, String requestName, long duration, boolean systemError, int responseStatus, long responseSize) {
        if (!this.logEnabled) {
            return;
        }
        String filterName = this.filterConfig.getFilterName();
        LOG.logHttpRequest(httpRequest, requestName, duration, systemError, responseStatus, responseSize, filterName);
    }

    private static void throwException(Throwable t) throws IOException, ServletException {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (t instanceof ServletException) {
            throw (ServletException)t;
        }
        throw new ServletException(t.getMessage(), t);
    }

    FilterContext getFilterContext() {
        return this.filterContext;
    }

    public static void registerApplicationNodeInCollectServer(String applicationName, URL collectServerUrl, URL applicationNodeUrl) {
        URL registerUrl;
        if (collectServerUrl == null || applicationNodeUrl == null) {
            throw new IllegalArgumentException("collectServerUrl and applicationNodeUrl must not be null");
        }
        String appName = applicationName == null ? Parameters.getCurrentApplication() : applicationName;
        try {
            registerUrl = new URL(collectServerUrl.toExternalForm() + "?appName=" + URLEncoder.encode(appName, "UTF-8") + "&appUrls=" + URLEncoder.encode(applicationNodeUrl.toExternalForm(), "UTF-8") + "&action=registerNode");
            unregisterApplicationNodeInCollectServerUrl = new URL(registerUrl.toExternalForm().replace("registerNode", "unregisterNode"));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        Thread thread = new Thread("javamelody registerApplicationNodeInCollectServer"){

            @Override
            public void run() {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException(e);
                }
                try {
                    new LabradorRetriever(registerUrl).post(null);
                    LOG.info("application node added to the collect server");
                }
                catch (IOException e) {
                    LOG.warn("Unable to register application's node in the collect server ( " + e + ')', e);
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    public static void unregisterApplicationNodeInCollectServer() throws IOException {
        if (unregisterApplicationNodeInCollectServerUrl != null) {
            new LabradorRetriever(unregisterApplicationNodeInCollectServerUrl).post(null);
            LOG.info("application node removed from the collect server");
        }
    }

    static {
        CONTEXT_PATHS = new ArrayList<String>();
    }
}

