/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.Serializable;
import java.lang.reflect.Method;
import javax.persistence.Query;

enum JpaMethod {
    OTHER(false, false, new NoMethodMatcher()),
    CREATE_QUERY(true, true, new ReturnQueryMethodMatcher("createQuery")),
    CREATE_NAMED_QUERY(true, true, new ReturnQueryMethodMatcher("createNamedQuery")),
    CREATE_NATIVE_QUERY(true, true, new ReturnQueryMethodMatcher("createNativeQuery")),
    CREATE_STORED_PROCEDURE_QUERY(true, true, new ReturnQueryMethodMatcher("createStoredProcedureQuery")),
    CREATE_NAMED_STORED_PROCEDURE_QUERY(true, true, new ReturnQueryMethodMatcher("createNamedStoredProcedureQuery")),
    FIND(true, false, new MethodWithArgsMethodMatcher("find")),
    MERGE(true, false, new MethodWithArgsMethodMatcher("merge")),
    PERSIST(true, false, new MethodWithArgsMethodMatcher("persist")),
    REFRESH(true, false, new MethodWithArgsMethodMatcher("refresh")),
    REMOVE(true, false, new MethodWithArgsMethodMatcher("remove")),
    DETACH(true, false, new MethodWithArgsMethodMatcher("detach")),
    LOCK(true, false, new MethodWithArgsMethodMatcher("lock")),
    FLUSH(true, false, new MethodNameMatcher("flush"));

    private final boolean monitored;
    private final boolean query;
    private final MethodMatcher matcher;

    private JpaMethod(boolean monitored, boolean query, MethodMatcher matcher) {
        this.monitored = monitored;
        this.query = query;
        this.matcher = matcher;
    }

    static JpaMethod forCall(Method method, Object[] args) {
        for (JpaMethod type : JpaMethod.values()) {
            if (!type.matcher.matches(type, method, args)) continue;
            return type;
        }
        return OTHER;
    }

    boolean isMonitored() {
        return this.monitored;
    }

    boolean isQuery() {
        return this.query;
    }

    private static interface MethodMatcher
    extends Serializable {
        public boolean matches(JpaMethod var1, Method var2, Object[] var3);
    }

    private static class NoMethodMatcher
    implements MethodMatcher {
        private static final long serialVersionUID = -7909606883659502100L;

        NoMethodMatcher() {
        }

        @Override
        public boolean matches(JpaMethod method, Method javaMethod, Object[] args) {
            return false;
        }
    }

    private static class ReturnQueryMethodMatcher
    extends MethodWithArgsMethodMatcher {
        private static final long serialVersionUID = 8359075693226965998L;

        ReturnQueryMethodMatcher(String methodName) {
            super(methodName);
        }

        @Override
        public boolean matches(JpaMethod method, Method javaMethod, Object[] args) {
            return super.matches(method, javaMethod, args) && javaMethod.getReturnType() != null && Query.class.isAssignableFrom(javaMethod.getReturnType());
        }
    }

    private static class MethodWithArgsMethodMatcher
    extends MethodNameMatcher {
        private static final long serialVersionUID = -6626632123950888074L;

        MethodWithArgsMethodMatcher(String methodName) {
            super(methodName);
        }

        @Override
        public boolean matches(JpaMethod method, Method javaMethod, Object[] args) {
            return super.matches(method, javaMethod, args) && args != null && args.length > 0;
        }
    }

    private static class MethodNameMatcher
    implements MethodMatcher {
        private static final long serialVersionUID = 3000368936257282142L;
        private final String methodName;

        MethodNameMatcher(String methodName) {
            this.methodName = methodName;
        }

        private boolean matchesName(Method javaMethod) {
            return this.methodName.equals(javaMethod.getName());
        }

        @Override
        public boolean matches(JpaMethod method, Method javaMethod, Object[] args) {
            return this.matchesName(javaMethod);
        }
    }
}

