/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import net.bull.javamelody.FilterContext;
import net.bull.javamelody.internal.common.LOG;
import net.bull.javamelody.internal.model.Collector;
import net.bull.javamelody.internal.web.HttpAuth;
import net.bull.javamelody.internal.web.MonitoringController;

public class ReportServlet
extends HttpServlet {
    static final String FILTER_CONTEXT_KEY = "javamelody.filterContext";
    private static final long serialVersionUID = 1L;
    private ServletConfig servletConfig;
    private transient HttpAuth httpAuth;

    public void init(ServletConfig config) {
        this.servletConfig = config;
        this.httpAuth = new HttpAuth();
        LOG.debug("JavaMelody report servlet initialized");
    }

    public void destroy() {
        this.servletConfig = null;
    }

    protected void doGet(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        FilterContext filterContext = (FilterContext)this.servletConfig.getServletContext().getAttribute(FILTER_CONTEXT_KEY);
        assert (filterContext != null);
        if (!this.httpAuth.isAllowed(httpRequest, httpResponse)) {
            return;
        }
        Collector collector = filterContext.getCollector();
        MonitoringController monitoringController = new MonitoringController(collector, null);
        monitoringController.doActionIfNeededAndReport(httpRequest, httpResponse, this.servletConfig.getServletContext());
    }
}

