/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.Date;

public class CounterError
implements Serializable {
    public static final String REQUEST_KEY = "javamelody.request";
    private static final long serialVersionUID = 5690702786722045646L;
    private static final ThreadLocal<HttpServletRequest> HTTP_SERVLET_REQUEST_CONTEXT = new ThreadLocal();
    private static final int MESSAGE_MAX_LENGTH = 1000;
    private static final int STACKTRACE_MAX_LENGTH = 50000;
    private final long time;
    private final String remoteUser;
    private final String httpRequest;
    private final String message;
    private final String stackTrace;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CounterError(String message, String stackTrace) {
        assert (message != null);
        this.time = System.currentTimeMillis();
        this.message = message.length() > 1000 ? message.substring(0, 1000) : message;
        this.stackTrace = stackTrace != null && stackTrace.length() > 50000 ? stackTrace.substring(0, 50000) : stackTrace;
        HttpServletRequest currentRequest = CounterError.getCurrentRequest();
        if (currentRequest == null) {
            this.remoteUser = null;
            this.httpRequest = null;
        } else {
            CounterError.unbindRequest();
            try {
                this.httpRequest = (String)currentRequest.getAttribute(REQUEST_KEY);
                this.remoteUser = currentRequest.getRemoteUser();
            }
            finally {
                CounterError.bindRequest(currentRequest);
            }
        }
    }

    public static void bindRequest(HttpServletRequest request) {
        if (request != null) {
            HTTP_SERVLET_REQUEST_CONTEXT.set(request);
        }
    }

    private static HttpServletRequest getCurrentRequest() {
        return HTTP_SERVLET_REQUEST_CONTEXT.get();
    }

    public static void unbindRequest() {
        HTTP_SERVLET_REQUEST_CONTEXT.remove();
    }

    long getTime() {
        return this.time;
    }

    public Date getDate() {
        return new Date(this.time);
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public String getHttpRequest() {
        return this.httpRequest;
    }

    public String getMessage() {
        return this.message;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[message=" + this.getMessage() + ']';
    }
}

