/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web;

import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import net.bull.javamelody.internal.web.FilterServletOutputStream;

public class CounterResponseStream
extends FilterServletOutputStream {
    private long dataLength;

    CounterResponseStream(HttpServletResponse response) throws IOException {
        super(response.getOutputStream());
    }

    public CounterResponseStream(OutputStream output) {
        super(output);
    }

    public long getDataLength() {
        return this.dataLength;
    }

    public void reset() {
        this.dataLength = 0L;
    }

    @Override
    public void write(int i) throws IOException {
        super.write(i);
        ++this.dataLength;
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        super.write(bytes);
        this.dataLength += (long)bytes.length;
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        super.write(bytes, off, len);
        this.dataLength += (long)len;
    }
}

