/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import net.bull.javamelody.MonitoringProxy;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.internal.common.LOG;
import net.bull.javamelody.internal.common.Parameters;
import net.bull.javamelody.internal.model.Counter;

public final class StrutsInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 6536441072950545240L;
    private static final Counter STRUTS_COUNTER = MonitoringProxy.getStrutsCounter();
    private static final boolean COUNTER_HIDDEN = Parameters.isCounterHidden(STRUTS_COUNTER.getName());
    private static final boolean DISABLED = Parameter.DISABLED.getValueAsBoolean();

    public StrutsInterceptor() {
        STRUTS_COUNTER.setDisplayed(!COUNTER_HIDDEN);
        STRUTS_COUNTER.setUsed(true);
        LOG.debug("struts interceptor initialized");
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        if (DISABLED || !STRUTS_COUNTER.isDisplayed()) {
            return invocation.invoke();
        }
        boolean systemError = false;
        try {
            String actionName = this.getRequestName(invocation);
            STRUTS_COUNTER.bindContextIncludingCpu(actionName);
            String string = invocation.invoke();
            return string;
        }
        catch (Error e) {
            systemError = true;
            throw e;
        }
        finally {
            STRUTS_COUNTER.addRequestForCurrentContext(systemError);
        }
    }

    protected String getRequestName(ActionInvocation invocation) {
        ActionProxy proxy = invocation.getProxy();
        String action = proxy.getActionName();
        String method = proxy.getMethod();
        String namespace = proxy.getNamespace();
        String actionName = method == null || "execute".equals(method) ? namespace + "/" + action : namespace + "/" + action + "!" + method;
        return actionName;
    }
}

