/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.internal.common.LOG;
import net.bull.javamelody.internal.common.Parameters;
import net.bull.javamelody.internal.model.Counter;
import net.bull.javamelody.internal.model.TransportFormat;

public class CounterStorage {
    private static final int DEFAULT_OBSOLETE_STATS_DAYS = 365;
    private static boolean storageDisabled;
    private final Counter counter;

    CounterStorage(Counter counter) {
        assert (counter != null);
        this.counter = counter;
    }

    int writeToFile() throws IOException {
        if (storageDisabled) {
            return -1;
        }
        File file = this.getFile();
        if (this.counter.getRequestsCount() == 0 && this.counter.getErrorsCount() == 0 && !file.exists()) {
            return -1;
        }
        File directory = file.getParentFile();
        if (!directory.mkdirs() && !directory.exists()) {
            throw new IOException("JavaMelody directory can't be created: " + directory.getPath());
        }
        return CounterStorage.writeToFile(this.counter, file);
    }

    static int writeToFile(Counter counter, File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            CounterOutputStream counterOutput = new CounterOutputStream(new GZIPOutputStream(new BufferedOutputStream(out)));
            try (ObjectOutputStream output = new ObjectOutputStream(counterOutput);){
                output.writeObject(counter);
            }
            int n = counterOutput.dataLength;
            return n;
        }
    }

    Counter readFromFile() throws IOException {
        if (storageDisabled) {
            return null;
        }
        File file = this.getFile();
        if (file.exists()) {
            return CounterStorage.readFromFile(file);
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static Counter readFromFile(File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            Counter counter;
            block14: {
                ObjectInputStream input = TransportFormat.createObjectInputStream(new GZIPInputStream(new BufferedInputStream(in)));
                try {
                    counter = (Counter)input.readObject();
                    if (input == null) break block14;
                }
                catch (Throwable throwable) {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                input.close();
            }
            return counter;
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (ClassCastException | IllegalStateException e) {
            LOG.warn("could not deserialize " + file.getName() + " , corrupted file will be deleted.", e);
            file.delete();
            return null;
        }
    }

    private File getFile() {
        File storageDirectory = Parameters.getStorageDirectory(this.counter.getApplication());
        return new File(storageDirectory, this.counter.getStorageName() + ".ser.gz");
    }

    static long deleteObsoleteCounterFiles(String application) {
        Calendar nowMinusOneYearAndADay = Calendar.getInstance();
        nowMinusOneYearAndADay.add(6, -CounterStorage.getObsoleteStatsDays());
        nowMinusOneYearAndADay.add(6, -1);
        long diskUsage = 0L;
        for (File file : CounterStorage.listSerGzFiles(application)) {
            boolean deleted = false;
            if (file.lastModified() < nowMinusOneYearAndADay.getTimeInMillis()) {
                deleted = file.delete();
            }
            if (deleted) continue;
            diskUsage += file.length();
        }
        return diskUsage;
    }

    private static int getObsoleteStatsDays() {
        String param = Parameter.OBSOLETE_STATS_DAYS.getValue();
        if (param != null) {
            int result = Integer.parseInt(param);
            if (result <= 0) {
                throw new IllegalStateException("The parameter obsolete-stats-days should be > 0 (365 recommended)");
            }
            return result;
        }
        return 365;
    }

    private static List<File> listSerGzFiles(String application) {
        FilenameFilter filenameFilter;
        File storageDir = Parameters.getStorageDirectory(application);
        File[] files = storageDir.listFiles(filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String fileName) {
                return fileName.endsWith(".ser.gz");
            }
        });
        if (files == null) {
            return Collections.emptyList();
        }
        return List.of(files);
    }

    public static void disableStorage() {
        storageDisabled = true;
    }

    private static class CounterOutputStream
    extends OutputStream {
        int dataLength;
        private final OutputStream output;

        CounterOutputStream(OutputStream output) {
            this.output = output;
        }

        @Override
        public void write(int b) throws IOException {
            this.output.write(b);
            ++this.dataLength;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.output.write(b);
            this.dataLength += b.length;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.output.write(b, off, len);
            this.dataLength += len;
        }

        @Override
        public void flush() throws IOException {
            this.output.flush();
        }

        @Override
        public void close() throws IOException {
            this.output.close();
        }
    }
}

