/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.util.Arrays;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import net.bull.javamelody.JavaMelodyConfigurationProperties;
import net.bull.javamelody.MonitoredWithAnnotationPointcut;
import net.bull.javamelody.MonitoringFilter;
import net.bull.javamelody.MonitoringSpringAdvisor;
import net.bull.javamelody.SessionListener;
import net.bull.javamelody.SpringContext;
import net.bull.javamelody.SpringDataSourceBeanPostProcessor;
import net.bull.javamelody.SpringRestTemplateBeanPostProcessor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator;
import org.springframework.aop.support.Pointcuts;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.annotation.Schedules;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RestController;

@Configuration
@EnableConfigurationProperties(value={JavaMelodyConfigurationProperties.class})
@ConditionalOnWebApplication
@ConditionalOnProperty(prefix="javamelody", name={"enabled"}, matchIfMissing=true)
public class JavaMelodyAutoConfiguration {
    public static final String REGISTRATION_BEAN_NAME = "javamelody-registration";

    @Bean
    public ServletListenerRegistrationBean<EventListener> monitoringSessionListener(ServletContext servletContext) {
        ServletListenerRegistrationBean servletListenerRegistrationBean = new ServletListenerRegistrationBean((EventListener)new SessionListener());
        if (servletContext.getFilterRegistration("javamelody") != null) {
            servletListenerRegistrationBean.setEnabled(false);
        }
        return servletListenerRegistrationBean;
    }

    @Bean(name={"javamelody-registration"})
    @ConditionalOnMissingBean(name={"javamelody-registration"})
    public FilterRegistrationBean monitoringFilter(JavaMelodyConfigurationProperties properties, ServletContext servletContext) {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        MonitoringFilter filter = new MonitoringFilter();
        filter.setApplicationType("Spring Boot");
        registrationBean.setFilter((Filter)filter);
        registrationBean.setAsyncSupported(true);
        registrationBean.setName("javamelody");
        registrationBean.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[]{DispatcherType.ASYNC});
        for (Map.Entry<String, String> parameter : properties.getInitParameters().entrySet()) {
            registrationBean.addInitParameter(parameter.getKey(), parameter.getValue());
        }
        registrationBean.addUrlPatterns(new String[]{"/*"});
        FilterRegistration filterRegistration = servletContext.getFilterRegistration("javamelody");
        if (filterRegistration != null) {
            registrationBean.setEnabled(false);
            for (Map.Entry entry : registrationBean.getInitParameters().entrySet()) {
                filterRegistration.setInitParameter((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return registrationBean;
    }

    @Bean
    @ConditionalOnMissingBean(value={DefaultAdvisorAutoProxyCreator.class})
    @ConditionalOnProperty(prefix="javamelody", name={"advisor-auto-proxy-creator-enabled"}, matchIfMissing=true)
    public DefaultAdvisorAutoProxyCreator defaultAdvisorAutoProxyCreator() {
        return new DefaultAdvisorAutoProxyCreator();
    }

    @Bean
    public SpringDataSourceBeanPostProcessor monitoringDataSourceBeanPostProcessor(@Value(value="${javamelody.excluded-datasources:}") String excludedDatasources) {
        SpringDataSourceBeanPostProcessor processor = new SpringDataSourceBeanPostProcessor();
        if (excludedDatasources != null && excludedDatasources.trim().length() > 0) {
            processor.setExcludedDatasources(new HashSet<String>(Arrays.asList(excludedDatasources.split(","))));
        }
        return processor;
    }

    @Bean
    @ConditionalOnProperty(prefix="javamelody", name={"spring-monitoring-enabled"}, matchIfMissing=true)
    public MonitoringSpringAdvisor monitoringSpringAdvisor() {
        return new MonitoringSpringAdvisor((Pointcut)new MonitoredWithAnnotationPointcut());
    }

    @Bean
    @ConditionalOnProperty(prefix="javamelody", name={"spring-monitoring-enabled"}, matchIfMissing=true)
    public MonitoringSpringAdvisor monitoringSpringServiceAdvisor() {
        return new MonitoringSpringAdvisor((Pointcut)new AnnotationMatchingPointcut(Service.class));
    }

    @Bean
    @ConditionalOnProperty(prefix="javamelody", name={"spring-monitoring-enabled"}, matchIfMissing=true)
    public MonitoringSpringAdvisor monitoringSpringControllerAdvisor() {
        return new MonitoringSpringAdvisor((Pointcut)new AnnotationMatchingPointcut(Controller.class));
    }

    @Bean
    @ConditionalOnProperty(prefix="javamelody", name={"spring-monitoring-enabled"}, matchIfMissing=true)
    public MonitoringSpringAdvisor monitoringSpringRestControllerAdvisor() {
        return new MonitoringSpringAdvisor((Pointcut)new AnnotationMatchingPointcut(RestController.class));
    }

    @Bean
    @ConditionalOnProperty(prefix="javamelody", name={"spring-monitoring-enabled"}, matchIfMissing=true)
    public MonitoringSpringAdvisor monitoringSpringAsyncAdvisor() {
        return new MonitoringSpringAdvisor(Pointcuts.union((Pointcut)new AnnotationMatchingPointcut(Async.class), (Pointcut)new AnnotationMatchingPointcut(null, Async.class)));
    }

    @Bean
    @ConditionalOnProperty(prefix="javamelody", name={"scheduled-monitoring-enabled"}, matchIfMissing=false)
    public MonitoringSpringAdvisor monitoringSpringScheduledAdvisor() {
        return new MonitoringSpringAdvisor(Pointcuts.union((Pointcut)new AnnotationMatchingPointcut(null, Scheduled.class), (Pointcut)new AnnotationMatchingPointcut(null, Schedules.class)));
    }

    @Bean
    @ConditionalOnProperty(prefix="javamelody", name={"spring-monitoring-enabled"}, matchIfMissing=true)
    public SpringRestTemplateBeanPostProcessor monitoringRestTemplateBeanPostProcessor() {
        return new SpringRestTemplateBeanPostProcessor();
    }

    @Bean
    public SpringContext javamelodySpringContext() {
        return new SpringContext();
    }
}

