/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.schema;

import com.google.common.base.Objects;
import net.conquiris.schema.AbstractIndexableSchemaItem;
import net.conquiris.schema.TextSchemaItem;

class DefaultTextSchemaItem
extends AbstractIndexableSchemaItem
implements TextSchemaItem {
    private final int hash;
    private final boolean tokenized;
    private final boolean norms;
    private final boolean vectors;
    private final boolean positions;
    private final boolean offsets;

    DefaultTextSchemaItem(String name, int minOccurs, int maxOccurs, boolean stored, boolean indexed, boolean tokenized, boolean norms, boolean vectors, boolean positions, boolean offsets) {
        super(name, minOccurs, maxOccurs, stored, indexed);
        this.tokenized = tokenized;
        this.norms = norms;
        this.vectors = indexed && vectors;
        this.positions = this.vectors && positions;
        this.offsets = this.vectors && offsets;
        this.hash = Objects.hashCode((Object[])new Object[]{this.getClass(), name, minOccurs, maxOccurs, stored, indexed, norms, this.vectors, this.positions, this.offsets});
    }

    @Override
    public final boolean isTokenized() {
        return this.tokenized;
    }

    @Override
    public final boolean isNorms() {
        return this.norms;
    }

    @Override
    public final boolean isVectors() {
        return this.vectors;
    }

    @Override
    public final boolean isPositions() {
        return this.positions;
    }

    @Override
    public final boolean isOffsets() {
        return this.offsets;
    }

    public final int hashCode() {
        return this.hash;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof DefaultTextSchemaItem) {
            DefaultTextSchemaItem other = (DefaultTextSchemaItem)obj;
            return this.hash == other.hash && this.getClass() == other.getClass() && this.getName().equals(other.getName()) && this.getMinOccurs() == other.getMinOccurs() && this.getMaxOccurs() == other.getMaxOccurs() && this.isStored() == other.isStored() && this.isIndexed() == other.isIndexed() && this.tokenized == other.tokenized && this.norms == other.norms && this.vectors == other.vectors && this.positions == other.positions && this.offsets == other.offsets;
        }
        return false;
    }
}

