/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.schema;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.conquiris.schema.Schema;
import net.conquiris.schema.SchemaItem;

final class SchemaImpl
extends ForwardingMap<String, SchemaItem>
implements Schema {
    private final ImmutableBiMap<String, SchemaItem> map;

    SchemaImpl(Map<String, SchemaItem> map) {
        this.map = ImmutableBiMap.copyOf(map);
    }

    protected BiMap<String, SchemaItem> delegate() {
        return this.map;
    }

    public SchemaItem forcePut(String key, SchemaItem value) {
        return (SchemaItem)this.delegate().forcePut((Object)key, (Object)value);
    }

    public BiMap<SchemaItem, String> inverse() {
        return this.delegate().inverse();
    }

    public Set<SchemaItem> values() {
        return this.delegate().values();
    }

    private Schema extendWithMap(Map<String, SchemaItem> items) {
        if (items.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return new SchemaImpl(items);
        }
        Sets.SetView intersect = Sets.intersection((Set)this.map.keySet(), items.keySet());
        Preconditions.checkArgument((boolean)intersect.isEmpty(), (String)"Extending with existing keys %s", (Object[])new Object[]{intersect});
        return this.putItems(items);
    }

    private Schema putItems(Map<String, SchemaItem> items) {
        HashMap newMap = Maps.newHashMap(this.map);
        newMap.putAll(items);
        return new SchemaImpl(newMap);
    }

    @Override
    public Schema extend(Iterable<? extends SchemaItem> items) {
        Iterable<? extends SchemaItem> i = items;
        ImmutableMap others = Maps.uniqueIndex(i, (Function)SchemaItem.NAME);
        if (others.isEmpty()) {
            return this;
        }
        return this.extendWithMap((Map<String, SchemaItem>)others);
    }

    @Override
    public Schema extend(SchemaItem ... items) {
        return this.extend(Arrays.asList(items));
    }

    @Override
    public Schema extend(Schema schema) {
        Preconditions.checkNotNull((Object)schema, (Object)"The schema must be provided");
        if (this.isEmpty()) {
            return schema;
        }
        return this.extendWithMap((Map<String, SchemaItem>)((Object)schema));
    }

    @Override
    public Schema override(Iterable<? extends SchemaItem> items) {
        Iterable<? extends SchemaItem> i = items;
        ImmutableMap others = Maps.uniqueIndex(i, (Function)SchemaItem.NAME);
        if (others.isEmpty()) {
            return this;
        }
        return this.putItems((Map<String, SchemaItem>)others);
    }

    @Override
    public Schema override(SchemaItem ... items) {
        return this.override(Arrays.asList(items));
    }

    @Override
    public Schema override(Schema schema) {
        Preconditions.checkNotNull((Object)schema, (Object)"The schema must be provided");
        if (this.isEmpty()) {
            return schema;
        }
        if (schema.isEmpty()) {
            return this;
        }
        return this.putItems((Map<String, SchemaItem>)((Object)schema));
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof Schema) {
            return this.map.equals(object);
        }
        return false;
    }
}

