/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.schema;

import com.google.common.base.Preconditions;
import net.conquiris.schema.AbstractWithFieldNameProperty;
import net.conquiris.schema.SchemaItem;

abstract class AbstractSchemaItem
extends AbstractWithFieldNameProperty
implements SchemaItem {
    private final int minOccurs;
    private final int maxOccurs;

    AbstractSchemaItem(String name, int minOccurs, int maxOccurs) {
        super(name);
        Preconditions.checkArgument((minOccurs >= 0 ? 1 : 0) != 0, (String)"The minimum number of occurrences of field %s must be >= 0", (Object[])new Object[]{name});
        Preconditions.checkArgument((maxOccurs >= minOccurs ? 1 : 0) != 0, (String)"The maximum number of occurrences of field %s must be >= minimum", (Object[])new Object[]{name});
        this.minOccurs = minOccurs;
        this.maxOccurs = maxOccurs;
    }

    @Override
    public final int getMinOccurs() {
        return this.minOccurs;
    }

    @Override
    public final int getMaxOccurs() {
        return this.maxOccurs;
    }

    @Override
    public final boolean isRequired() {
        return this.minOccurs > 0;
    }
}

