/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.schema;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import net.conquiris.schema.Schema;
import net.conquiris.schema.SchemaImpl;
import net.conquiris.schema.SchemaItem;

public final class Schemas {
    private static final Schema EMPTY = new SchemaImpl((Map<String, SchemaItem>)ImmutableBiMap.of());

    private Schemas() {
        throw new AssertionError();
    }

    public static Schema empty() {
        return EMPTY;
    }

    public static Schema of(Iterable<? extends SchemaItem> items) {
        return EMPTY.override(items);
    }

    public static Schema of(SchemaItem ... items) {
        return Schemas.of(Arrays.asList(items));
    }

    public static Schema of(SchemaItem item) {
        Preconditions.checkNotNull((Object)item, (Object)"The schema item must be provided");
        return new SchemaImpl((Map<String, SchemaItem>)ImmutableMap.of((Object)item.getName(), (Object)item));
    }
}

