/*
 * Decompiled with CFR 0.152.
 */
package net.corda.client.mock;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.SplittableRandom;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import kotlin.ranges.LongRange;
import net.corda.client.mock.Generator;
import net.corda.client.mock.GeneratorKt;
import net.corda.core.ErrorOr;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0010\u001e\n\u0000\u001a\u0018\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001*\u00020\u0003\u001a \u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001*\u00020\u00032\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007\u001aW\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\f0\u0001\"\b\b\u0000\u0010\f*\u00020\r*\u00020\u000326\u0010\u000e\u001a\u001c\u0012\u0018\b\u0001\u0012\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0\u00010\u00100\u000f\"\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0\u00010\u0010\u00a2\u0006\u0002\u0010\u0011\u001a1\u0010\u0012\u001a\u0002H\f\"\b\b\u0000\u0010\f*\u00020\r*\b\u0012\u0004\u0012\u0002H\f0\u00012\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0016\u001a\u0010\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0001*\u00020\u0003\u001a \u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0001*\u00020\u00032\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005\u001a\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0001*\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a\u001a \u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0001*\u00020\u00032\u0006\u0010\t\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\u001c\u001a\u0018\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0001*\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001d\u001a6\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0\u001f0\u0001\"\b\b\u0000\u0010\f*\u00020\r*\u00020\u00032\u0006\u0010 \u001a\u00020\u00052\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\f0\u001f\u001a(\u0010\"\u001a\b\u0012\u0004\u0012\u0002H\f0\u0001\"\b\b\u0000\u0010\f*\u00020\r*\u00020\u00032\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\f0\u001f\u001a6\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0\u001f0\u0001\"\b\b\u0000\u0010\f*\u00020\r*\u00020\u00032\u0006\u0010 \u001a\u00020\u00052\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H\f0\u0001\u001a6\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0\u001f0\u0001\"\b\b\u0000\u0010\f*\u00020\r*\u00020\u00032\u0006\u0010&\u001a\u00020\u00072\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H\f0\u0001\u001aG\u0010'\u001a\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\f0\u000f0\u001f0\u0001\"\u0004\b\u0000\u0010\f*\u00020\u00032\b\b\u0002\u0010(\u001a\u00020\u00072\u0012\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\f0\u000f\"\u0002H\f\u00a2\u0006\u0002\u0010*\u001a4\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0\u001f0\u0001\"\u0004\b\u0000\u0010\f*\u00020\u00032\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H\f0+2\b\b\u0002\u0010(\u001a\u00020\u0007\u00a8\u0006,"}, d2={"bytes", "Lnet/corda/client/mock/Generator;", "", "Lnet/corda/client/mock/Generator$Companion;", "size", "", "double", "", "doubleRange", "from", "to", "frequency", "A", "", "generators", "", "Lkotlin/Pair;", "(Lnet/corda/client/mock/Generator$Companion;[Lkotlin/Pair;)Lnet/corda/client/mock/Generator;", "generateOrFail", "random", "Ljava/util/SplittableRandom;", "numberOfTries", "(Lnet/corda/client/mock/Generator;Ljava/util/SplittableRandom;I)Ljava/lang/Object;", "int", "intRange", "range", "Lkotlin/ranges/IntRange;", "longRange", "", "Lkotlin/ranges/LongRange;", "pickN", "", "number", "list", "pickOne", "replicate", "generator", "replicatePoisson", "meanSize", "sampleBernoulli", "maxRatio", "collection", "(Lnet/corda/client/mock/Generator$Companion;D[Ljava/lang/Object;)Lnet/corda/client/mock/Generator;", "", "client_main"})
public final class GeneratorKt {
    @NotNull
    public static final <A> Generator<A> frequency(@NotNull Generator.Companion $receiver, Pair<Double, ? extends Generator<? extends A>> ... generators) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(generators, (String)"generators");
        return $receiver.frequency(ArraysKt.toList((Object[])generators));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <A> A generateOrFail(@NotNull Generator<? extends A> $receiver, @NotNull SplittableRandom random, int numberOfTries) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)random, (String)"random");
        Throwable error = null;
        int n = 0;
        int n2 = numberOfTries - 1;
        if (n <= n2) {
            while (true) {
                void i;
                ErrorOr result;
                Object v;
                if ((v = (result = (ErrorOr)$receiver.getGenerate().invoke((Object)random)).getValue()) != null) {
                    return (A)v;
                }
                error = result.getError();
                if (i == n2) break;
                ++i;
            }
        }
        if (error == null) {
            throw (Throwable)new IllegalArgumentException("numberOfTries cannot be <= 0");
        }
        throw (Throwable)new Exception("Failed to generate", error);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Object generateOrFail$default(Generator generator, SplittableRandom splittableRandom, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: generateOrFail");
        }
        if ((n2 & 2) != 0) {
            n = 1;
        }
        return GeneratorKt.generateOrFail(generator, splittableRandom, n);
    }

    @NotNull
    public static final Generator<Integer> int(@NotNull Generator.Companion $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Generator.Companion.success(int.1.INSTANCE);
    }

    @NotNull
    public static final Generator<byte[]> bytes(@NotNull Generator.Companion $receiver, int size) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Generator.Companion.success((Function1)new Function1<SplittableRandom, byte[]>(size){
            final /* synthetic */ int $size;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final byte[] invoke(@NotNull SplittableRandom random) {
                void var3_3;
                Intrinsics.checkParameterIsNotNull((Object)random, (String)"random");
                int size$iv = this.$size;
                byte[] result$iv = new byte[size$iv];
                int n = 0;
                int n2 = size$iv - 1;
                if (n <= n2) {
                    void i$iv;
                    do {
                        byte by;
                        void var6_6 = ++i$iv;
                        void var10_8 = i$iv;
                        byte[] byArray = result$iv;
                        byArray[var10_8] = by = (byte)random.nextInt();
                    } while (i$iv != n2);
                }
                return var3_3;
            }
            {
                this.$size = n;
                super(1);
            }
        });
    }

    @NotNull
    public static final Generator<Integer> intRange(@NotNull Generator.Companion $receiver, @NotNull IntRange range) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        return GeneratorKt.intRange($receiver, range.getFirst(), range.getLast());
    }

    @NotNull
    public static final Generator<Integer> intRange(@NotNull Generator.Companion $receiver, int from, int to) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Generator.Companion.success((Function1)new Function1<SplittableRandom, Integer>(from, to){
            final /* synthetic */ int $from;
            final /* synthetic */ int $to;

            public final int invoke(@NotNull SplittableRandom it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.$from + Math.abs(it.nextInt()) % (this.$to - this.$from + 1);
            }
            {
                this.$from = n;
                this.$to = n2;
                super(1);
            }
        });
    }

    @NotNull
    public static final Generator<Long> longRange(@NotNull Generator.Companion $receiver, @NotNull LongRange range) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        return GeneratorKt.longRange($receiver, range.getFirst(), range.getLast());
    }

    @NotNull
    public static final Generator<Long> longRange(@NotNull Generator.Companion $receiver, long from, long to) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Generator.Companion.success((Function1)new Function1<SplittableRandom, Long>(from, to){
            final /* synthetic */ long $from;
            final /* synthetic */ long $to;

            public final long invoke(@NotNull SplittableRandom it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.$from + Math.abs(it.nextLong()) % (this.$to - this.$from + (long)1);
            }
            {
                this.$from = l;
                this.$to = l2;
                super(1);
            }
        });
    }

    @NotNull
    public static final Generator<Double> double(@NotNull Generator.Companion $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Generator.Companion.success(double.1.INSTANCE);
    }

    @NotNull
    public static final Generator<Double> doubleRange(@NotNull Generator.Companion $receiver, double from, double to) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Generator.Companion.success((Function1)new Function1<SplittableRandom, Double>(from, to){
            final /* synthetic */ double $from;
            final /* synthetic */ double $to;

            public final double invoke(@NotNull SplittableRandom it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.$from + it.nextDouble() * (this.$to - this.$from);
            }
            {
                this.$from = d;
                this.$to = d2;
                super(1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <A> Generator<List<A>> replicate(@NotNull Generator.Companion $receiver, int number, @NotNull Generator<? extends A> generator) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(generator, (String)"generator");
        List generators = CollectionsKt.mutableListOf((Object[])new Generator[0]);
        int n = 1;
        int n2 = number;
        if (n <= n2) {
            while (true) {
                void i;
                generators.add(generator);
                if (i == n2) break;
                ++i;
            }
        }
        return $receiver.sequence(generators);
    }

    @NotNull
    public static final <A> Generator<List<A>> replicatePoisson(@NotNull Generator.Companion $receiver, double meanSize, @NotNull Generator<? extends A> generator) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(generator, (String)"generator");
        return new Generator<List<A>>((Function1)new Function1<SplittableRandom, ErrorOr<? extends List<A>>>(meanSize, generator){
            final /* synthetic */ double $meanSize;
            final /* synthetic */ Generator $generator;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ErrorOr<List<A>> invoke(@NotNull SplittableRandom it) {
                void finish;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                double chance = (this.$meanSize - 1.0) / this.$meanSize;
                List result = CollectionsKt.mutableListOf((Object[])new Object[0]);
                Ref.BooleanRef booleanRef = new Ref.BooleanRef();
                booleanRef.element = false;
                while (!finish.element) {
                    ErrorOr errorOr2 = ((ErrorOr)GeneratorKt.doubleRange(Generator.Companion, 0.0, 1.0).getGenerate().invoke((Object)it)).bind((Function1)new Function1<Double, ErrorOr<? extends Object>>(this, chance, it, result, (Ref.BooleanRef)finish){
                        final /* synthetic */ replicatePoisson.1 this$0;
                        final /* synthetic */ double $chance;
                        final /* synthetic */ SplittableRandom $it;
                        final /* synthetic */ List $result;
                        final /* synthetic */ Ref.BooleanRef $finish;

                        @NotNull
                        public final ErrorOr<Object> invoke(double value) {
                            ErrorOr errorOr2;
                            if (value < this.$chance) {
                                errorOr2 = ((ErrorOr)this.this$0.$generator.getGenerate().invoke((Object)this.$it)).map((Function1)new Function1<A, Boolean>(this){
                                    final /* synthetic */ replicatePoisson.errorOr.1 this$0;

                                    public final boolean invoke(@NotNull A it) {
                                        Intrinsics.checkParameterIsNotNull(it, (String)"it");
                                        return this.this$0.$result.add(it);
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        super(1);
                                    }
                                });
                            } else {
                                this.$finish.element = true;
                                errorOr2 = new ErrorOr((Object)Unit.INSTANCE);
                            }
                            return errorOr2;
                        }
                        {
                            this.this$0 = var1_1;
                            this.$chance = d;
                            this.$it = splittableRandom;
                            this.$result = list;
                            this.$finish = booleanRef;
                            super(1);
                        }
                    });
                    Throwable e = errorOr2.getError();
                    if (e == null) continue;
                    return ErrorOr.Companion.of(e);
                }
                booleanRef = null;
                return new ErrorOr((Object)result);
            }
            {
                this.$meanSize = d;
                this.$generator = generator;
                super(1);
            }
        });
    }

    @NotNull
    public static final <A> Generator<A> pickOne(@NotNull Generator.Companion $receiver, @NotNull List<? extends A> list) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        return GeneratorKt.intRange(Generator.Companion, 0, list.size() - 1).map((Function1)new Function1<Integer, A>(list){
            final /* synthetic */ List $list;

            @NotNull
            public final A invoke(int it) {
                return (A)this.$list.get(it);
            }
            {
                this.$list = list;
                super(1);
            }
        });
    }

    @NotNull
    public static final <A> Generator<List<A>> pickN(@NotNull Generator.Companion $receiver, int number, @NotNull List<? extends A> list) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        return new Generator<List<A>>((Function1)new Function1<SplittableRandom, ErrorOr<? extends ArrayList<A>>>(list, number){
            final /* synthetic */ List $list;
            final /* synthetic */ int $number;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ErrorOr<ArrayList<A>> invoke(@NotNull SplittableRandom it) {
                void $receiver$iv;
                int i;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                BitSet mask = new BitSet(this.$list.size());
                int n = 0;
                int n2 = Math.min(this.$list.size(), this.$number) - 1;
                if (n <= n2) {
                    while (true) {
                        mask.set(i, 1);
                        if (i == n2) break;
                        ++i;
                    }
                }
                if ((i = 0) <= (n2 = mask.size() - 1)) {
                    while (true) {
                        boolean bl = mask.get(i);
                        int swapIndex = i + it.nextInt(mask.size() - i);
                        mask.set(i, mask.get(swapIndex));
                        mask.set(swapIndex, bl);
                        if (i == n2) break;
                        ++i;
                    }
                }
                ArrayList<void> resultList = new ArrayList<void>();
                Iterable iterable = this.$list;
                int index$iv = 0;
                for (T item$iv : $receiver$iv) {
                    void a;
                    int n3 = index$iv++;
                    T t = item$iv;
                    int index2 = n3;
                    if (!mask.get(index2)) continue;
                    resultList.add(a);
                }
                return new ErrorOr(resultList);
            }
            {
                this.$list = list;
                this.$number = n;
                super(1);
            }
        });
    }

    @NotNull
    public static final <A> Generator<List<A[]>> sampleBernoulli(@NotNull Generator.Companion $receiver, double maxRatio, A ... collection) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(collection, (String)"collection");
        return GeneratorKt.sampleBernoulli($receiver, CollectionsKt.listOf(collection), maxRatio);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Generator sampleBernoulli$default(Generator.Companion companion, double d, Object[] objectArray, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sampleBernoulli");
        }
        if ((n & 1) != 0) {
            d = 1.0;
        }
        return GeneratorKt.sampleBernoulli(companion, d, objectArray);
    }

    @NotNull
    public static final <A> Generator<List<A>> sampleBernoulli(@NotNull Generator.Companion $receiver, @NotNull Collection<? extends A> collection, double maxRatio) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(collection, (String)"collection");
        return GeneratorKt.intRange($receiver, 0, (int)(maxRatio * (double)collection.size())).bind((Function1)new Function1<Integer, Generator<? extends List<A>>>($receiver, collection){
            final /* synthetic */ Generator.Companion receiver$0;
            final /* synthetic */ Collection $collection;

            @NotNull
            public final Generator<List<A>> invoke(int howMany) {
                return GeneratorKt.replicate(this.receiver$0, this.$collection.size(), GeneratorKt.doubleRange(Generator.Companion, 0.0, 1.0)).map((Function1)new Function1<List<? extends Double>, List<A>>(this, howMany){
                    final /* synthetic */ sampleBernoulli.1 this$0;
                    final /* synthetic */ int $howMany;

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final List<A> invoke(@NotNull List<Double> chances) {
                        void var2_2;
                        Intrinsics.checkParameterIsNotNull(chances, (String)"chances");
                        List result = CollectionsKt.mutableListOf((Object[])new Object[0]);
                        Iterable $receiver$iv = this.this$0.$collection;
                        int index$iv = 0;
                        for (T item$iv : $receiver$iv) {
                            void element;
                            int n = index$iv++;
                            T t = item$iv;
                            int index2 = n;
                            if (!(((Number)chances.get(index2)).doubleValue() < (double)this.$howMany / (double)this.this$0.$collection.size())) continue;
                            result.add(element);
                        }
                        return var2_2;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$howMany = n;
                        super(1);
                    }
                });
            }
            {
                this.receiver$0 = companion;
                this.$collection = collection;
                super(1);
            }
        });
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Generator sampleBernoulli$default(Generator.Companion companion, Collection collection, double d, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sampleBernoulli");
        }
        if ((n & 2) != 0) {
            d = 1.0;
        }
        return GeneratorKt.sampleBernoulli(companion, collection, d);
    }
}

