/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.io;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.covers1624.quack.io.DelegateFileSystem;

public class IOUtils {
    private static final ThreadLocal<byte[]> bufferCache = ThreadLocal.withInitial(() -> new byte[32768]);
    private static final Map<String, String> jfsArgsCreate = Collections.singletonMap("create", "true");

    public static void copy(InputStream is, OutputStream os) throws IOException {
        int len;
        byte[] buffer = bufferCache.get();
        while ((len = is.read(buffer)) != -1) {
            os.write(buffer, 0, len);
        }
    }

    public static byte[] toBytes(InputStream is) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        IOUtils.copy(is, os);
        return os.toByteArray();
    }

    public static List<String> readAll(byte[] bytes) throws IOException {
        return IOUtils.readAll(bytes, StandardCharsets.UTF_8);
    }

    public static List<String> readAll(byte[] bytes, Charset charset) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), charset));){
            List<String> list = reader.lines().collect(Collectors.toList());
            return list;
        }
    }

    public static FileSystem getJarFileSystem(Path path, boolean create) throws IOException {
        return IOUtils.getJarFileSystem(path.toUri(), create);
    }

    public static FileSystem getJarFileSystem(URI path, boolean create) throws IOException {
        URI jarURI;
        try {
            jarURI = new URI("jar:file", null, path.getPath(), "");
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        return IOUtils.getFileSystem(jarURI, create ? jfsArgsCreate : Collections.emptyMap());
    }

    public static FileSystem getFileSystem(URI uri) throws IOException {
        return IOUtils.getFileSystem(uri, Collections.emptyMap());
    }

    public static FileSystem getFileSystem(URI uri, Map<String, ?> env) throws IOException {
        FileSystem fs;
        boolean owner = true;
        try {
            fs = FileSystems.newFileSystem(uri, env);
        }
        catch (FileSystemAlreadyExistsException e) {
            fs = FileSystems.getFileSystem(uri);
            owner = false;
        }
        return owner ? fs : IOUtils.protectClose(fs);
    }

    public static FileSystem protectClose(FileSystem fs) {
        return new DelegateFileSystem(fs){

            @Override
            public void close() {
            }
        };
    }

    public static InputStream protectClose(InputStream is) {
        return new FilterInputStream(is){

            @Override
            public void close() {
            }
        };
    }

    public static OutputStream protectClose(OutputStream os) {
        return new FilterOutputStream(os){

            @Override
            public void close() {
            }
        };
    }
}

