/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.logging.log4j2;

import java.io.Serializable;
import java.util.Objects;
import javax.script.Bindings;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AppenderSet;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.script.AbstractScript;
import org.apache.logging.log4j.core.script.ScriptManager;
import org.apache.logging.log4j.core.script.ScriptRef;

@Plugin(name="BetterScriptAppenderSelector", category="Core", elementType="appender", printObject=true)
public class BetterScriptAppenderSelector
extends AbstractAppender {
    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    private BetterScriptAppenderSelector(String name, Filter filter, Layout<? extends Serializable> layout) {
        super(name, filter, layout);
    }

    public void append(LogEvent event) {
    }

    public static final class Builder
    implements org.apache.logging.log4j.core.util.Builder<Appender> {
        @PluginElement(value="AppenderSet")
        @Required
        private AppenderSet appenderSet;
        @PluginConfiguration
        @Required
        private Configuration configuration;
        @PluginBuilderAttribute
        @Required
        private String name;
        @PluginElement(value="Script")
        @Required
        private AbstractScript script;

        public Appender build() {
            if (this.name == null) {
                LOGGER.error("Name missing.");
                return null;
            }
            if (this.script == null) {
                LOGGER.error("Script missing for ScriptAppenderSelector appender {}", (Object)this.name);
                return null;
            }
            if (this.appenderSet == null) {
                LOGGER.error("AppenderSet missing for ScriptAppenderSelector appender {}", (Object)this.name);
                return null;
            }
            if (this.configuration == null) {
                LOGGER.error("Configuration missing for ScriptAppenderSelector appender {}", (Object)this.name);
                return null;
            }
            ScriptManager scriptManager = this.configuration.getScriptManager();
            if (!(this.script instanceof ScriptRef)) {
                scriptManager.addScript(this.script);
            }
            Bindings bindings = scriptManager.createBindings(this.script);
            Object object = scriptManager.execute(this.script.getName(), bindings);
            String appenderName = Objects.toString(object, null);
            Appender appender = this.appenderSet.createAppender(appenderName, this.name);
            return appender;
        }

        public AppenderSet getAppenderSet() {
            return this.appenderSet;
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public String getName() {
            return this.name;
        }

        public AbstractScript getScript() {
            return this.script;
        }

        public Builder withAppenderNodeSet(AppenderSet appenderSet) {
            this.appenderSet = appenderSet;
            return this;
        }

        public Builder withConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withScript(AbstractScript script) {
            this.script = script;
            return this;
        }
    }
}

