/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.logging.log4j2;

import java.io.PrintStream;
import net.covers1624.quack.io.NullOutputStream;
import org.apache.logging.log4j.Logger;

public class TracingPrintStream
extends PrintStream {
    private static final int BASE_DEPTH = 4;
    private final Logger logger;

    public TracingPrintStream(Logger logger) {
        super(NullOutputStream.INSTANCE);
        this.logger = logger;
    }

    private void log(String s) {
        this.logger.info("{}{}", (Object)TracingPrintStream.getPrefix(), (Object)s);
    }

    private static String getPrefix() {
        StackTraceElement[] elems = Thread.currentThread().getStackTrace();
        StackTraceElement elem = elems[Math.min(4, elems.length - 1)];
        if (elem.getClassName().startsWith("kotlin.io.")) {
            elem = elems[Math.min(6, elems.length - 1)];
        } else if (elem.getClassName().startsWith("java.lang.Throwable")) {
            elem = elems[Math.min(8, elems.length - 1)];
        }
        return "[" + elem.getClassName() + ":" + elem.getMethodName() + ":" + elem.getLineNumber() + "]: ";
    }

    @Override
    public void println(Object o) {
        this.log(String.valueOf(o));
    }

    @Override
    public void println(String s) {
        this.log(s);
    }

    @Override
    public void println(boolean x) {
        this.log(String.valueOf(x));
    }

    @Override
    public void println(char x) {
        this.log(String.valueOf(x));
    }

    @Override
    public void println(int x) {
        this.log(String.valueOf(x));
    }

    @Override
    public void println(long x) {
        this.log(String.valueOf(x));
    }

    @Override
    public void println(float x) {
        this.log(String.valueOf(x));
    }

    @Override
    public void println(double x) {
        this.log(String.valueOf(x));
    }

    @Override
    public void println(char[] x) {
        this.log(String.valueOf(x));
    }
}

