/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.io;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public class CopyingFileVisitor
extends SimpleFileVisitor<Path> {
    private final Path fromRoot;
    private final Path toRoot;

    public CopyingFileVisitor(Path fromRoot, Path toRoot) {
        this.fromRoot = fromRoot;
        this.toRoot = toRoot;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        Path to = this.toRoot.resolve(this.fromRoot.relativize(file).toString());
        Files.createDirectories(to.getParent(), new FileAttribute[0]);
        Files.copy(file, to, StandardCopyOption.REPLACE_EXISTING);
        return FileVisitResult.CONTINUE;
    }
}

