/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.gson;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import net.covers1624.quack.annotation.Requires;

@Requires(value="com.google.code.gson:gson")
public class LowerCaseEnumAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (!type.getRawType().isEnum()) {
            return null;
        }
        final HashMap lookup = new HashMap();
        for (Object e : type.getRawType().getEnumConstants()) {
            lookup.put(e.toString().toLowerCase(Locale.ROOT), e);
        }
        return new TypeAdapter<T>(){

            public void write(JsonWriter out, T value) throws IOException {
                if (value == null) {
                    out.nullValue();
                } else {
                    out.value(value.toString().toLowerCase());
                }
            }

            public T read(JsonReader in) throws IOException {
                if (in.peek() == JsonToken.NULL) {
                    in.nextNull();
                    return null;
                }
                String name = in.nextString();
                return name == null ? null : (Object)lookup.get(name.toLowerCase(Locale.ROOT));
            }
        };
    }
}

