/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.gson;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.annotation.WillNotClose;
import net.covers1624.quack.annotation.Requires;
import net.covers1624.quack.io.IOUtils;

@Requires(value="com.google.guava:guava")
public class HashUtils {
    public static HashCode hash(HashFunction func, Path path) throws IOException {
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            HashCode hashCode = HashUtils.hash(func, is);
            return hashCode;
        }
    }

    public static HashCode hash(HashFunction func, @WillNotClose InputStream is) throws IOException {
        Hasher hasher = func.newHasher();
        HashUtils.addToHasher(hasher, is);
        return hasher.hash();
    }

    public static void addToHasher(Hasher hasher, @WillNotClose InputStream is) throws IOException {
        int len;
        byte[] buffer = IOUtils.getCachedBuffer();
        while ((len = is.read(buffer)) != -1) {
            hasher.putBytes(buffer, 0, len);
        }
    }

    public static boolean equals(HashCode a, String b) {
        if (a == null || b == null) {
            return false;
        }
        try {
            return a.equals((Object)HashCode.fromString((String)b));
        }
        catch (Throwable ignored) {
            return false;
        }
    }
}

