/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.net.okhttp;

import java.io.IOException;
import net.covers1624.quack.annotation.Requires;
import net.covers1624.quack.net.okhttp.SniffingResponseBody;
import net.covers1624.quack.util.MultiHasher;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okio.Buffer;
import okio.ForwardingSource;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Requires.RequiresList(value={@Requires(value="com.google.guava:guava"), @Requires(value="com.squareup.okhttp3:okhttp")})
public class MultiHasherInterceptor
implements Interceptor {
    @NotNull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        MultiHasher hasher = (MultiHasher)request.tag(MultiHasher.class);
        Response response = chain.proceed(request);
        if (hasher == null) {
            return response;
        }
        return response.newBuilder().body(SniffingResponseBody.ofFunction(response.body(), source -> new HasherWrappedSource((Source)source, hasher))).build();
    }

    private static class HasherWrappedSource
    extends ForwardingSource {
        private final MultiHasher hasher;

        public HasherWrappedSource(Source delegate, MultiHasher hasher) {
            super(delegate);
            this.hasher = hasher;
        }

        public long read(Buffer sink, long byteCount) throws IOException {
            long bytesRead = super.read(sink, byteCount);
            if (bytesRead != 1L) {
                this.hasher.update(sink.peek().readByteArray());
            }
            return bytesRead;
        }
    }
}

