/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.net.okhttp;

import java.io.IOException;
import net.covers1624.quack.annotation.Requires;
import net.covers1624.quack.net.download.DownloadListener;
import net.covers1624.quack.net.okhttp.SniffingResponseBody;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okio.Buffer;
import okio.ForwardingSource;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Requires(value="com.squareup.okhttp3:okhttp")
public class ProgressInterceptor
implements Interceptor {
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        ProgressTag tag = (ProgressTag)request.tag(ProgressTag.class);
        if (tag == null) {
            return chain.proceed(request);
        }
        tag.listener.connecting();
        Response response = chain.proceed(request);
        return response.newBuilder().body(SniffingResponseBody.ofFunction(response.body(), e -> new ProgressForwardingSource((Source)e, tag))).build();
    }

    private static class ProgressForwardingSource
    extends ForwardingSource {
        private final ProgressTag tag;
        private long totalLen;

        public ProgressForwardingSource(Source delegate, ProgressTag tag) {
            super(delegate);
            this.tag = tag;
            this.totalLen = tag.existingLen;
        }

        public long read(@NotNull Buffer sink, long byteCount) throws IOException {
            long len = super.read(sink, byteCount);
            if (len == -1L) {
                this.tag.listener.finish(this.totalLen);
            } else {
                this.totalLen += len;
                this.tag.listener.update(this.totalLen);
            }
            return len;
        }
    }

    public static class ProgressTag {
        public final long existingLen;
        public final DownloadListener listener;

        public ProgressTag(DownloadListener listener) {
            this(0L, listener);
        }

        public ProgressTag(long existingLen, DownloadListener listener) {
            this.existingLen = existingLen;
            this.listener = listener;
        }
    }
}

