/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.collection;

import java.util.ArrayList;
import java.util.List;
import net.covers1624.quack.collection.ColUtils;

public class ColFormatter {
    public static List<String> format(List<List<String>> input) {
        List<List<String>> cols = ColFormatter.rotateLists(input);
        ArrayList<List<String>> newCols = new ArrayList<List<String>>();
        for (List<String> col : cols) {
            int max = ColUtils.maxBy(col, String::length).length();
            ArrayList<String> newCol = new ArrayList<String>();
            for (String cell : col) {
                StringBuilder str = new StringBuilder(cell);
                if (cell.length() < max) {
                    for (int i = cell.length(); i < max; ++i) {
                        str.append(" ");
                    }
                }
                newCol.add(str.toString());
            }
            newCols.add(newCol);
        }
        ArrayList<String> lines = new ArrayList<String>();
        List<List<String>> rows = ColFormatter.rotateLists(newCols);
        for (List<String> row : rows) {
            StringBuilder builder = new StringBuilder();
            for (String cell : row) {
                if (builder.capacity() != 0) {
                    builder.append(" ");
                }
                builder.append(cell);
            }
            lines.add(builder.toString());
        }
        return lines;
    }

    public static List<List<String>> rotateLists(List<List<String>> input) {
        if (input.isEmpty()) {
            return input;
        }
        List<List<String>> sqLst = ColFormatter.toSquare(input);
        ArrayList<List<String>> cols = new ArrayList<List<String>>();
        for (int colIndex = 0; colIndex < sqLst.get(0).size(); ++colIndex) {
            ArrayList<String> col = new ArrayList<String>();
            for (List<String> row : sqLst) {
                col.add(row.get(colIndex));
            }
            cols.add(col);
        }
        return cols;
    }

    public static List<List<String>> toSquare(List<List<String>> input) {
        int len = ColUtils.maxBy(input, List::size).size();
        if (ColUtils.forAll(input, e -> e.size() == len)) {
            return input;
        }
        ArrayList<List<String>> out = new ArrayList<List<String>>();
        for (List<String> row : input) {
            ArrayList<String> elm = new ArrayList<String>(row);
            if (row.size() != len) {
                for (int i = row.size(); i < len; ++i) {
                    elm.add(" ");
                }
            }
            out.add(elm);
        }
        return out;
    }
}

