/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.gradle.net.download;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.function.Predicate;
import net.covers1624.quack.annotation.Requires;
import net.covers1624.quack.gradle.net.download.ProgressLoggerListener;
import net.covers1624.quack.net.download.DownloadAction;
import net.covers1624.quack.net.download.DownloadListener;
import net.covers1624.quack.net.download.DownloadSpec;
import org.gradle.api.DefaultTask;
import org.gradle.api.internal.tasks.TaskExecutionOutcome;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskAction;

@Requires.RequiresList(value={@Requires(value="org.gradle:gradle-api"), @Requires(value="org.apache.commons:commons-lang3"), @Requires(value="org.apache.logging.log4j:log4j-api"), @Requires(value="org.apache.httpcomponents:httpclient")})
public class DownloadTask
extends DefaultTask
implements DownloadSpec {
    private final DownloadAction action = new DownloadAction();

    public DownloadTask() {
        this.getOutputs().upToDateWhen(e -> false);
    }

    @TaskAction
    public void doTask() throws IOException {
        if (this.getListener() == null && !this.isQuiet()) {
            this.setListener(ProgressLoggerListener.create(this.getProject(), this));
        }
        this.action.execute();
        if (this.isUpToDate()) {
            this.getState().setOutcome(TaskExecutionOutcome.UP_TO_DATE);
            this.setDidWork(false);
        }
    }

    public void fileUpToDateWhen(Spec<File> spec) {
        this.fileUpToDateWhen((Path e) -> spec.isSatisfiedBy((Object)e.toFile()));
    }

    @Override
    public void fileUpToDateWhen(Predicate<Path> spec) {
        this.action.fileUpToDateWhen(spec);
    }

    @Override
    public URL getSrc() {
        return this.action.getSrc();
    }

    @Override
    public Path getDest() {
        return this.action.getDest();
    }

    @Override
    public boolean getOnlyIfModified() {
        return this.action.getOnlyIfModified();
    }

    @Override
    public DownloadAction.UseETag getUseETag() {
        return this.action.getUseETag();
    }

    @Override
    public Path getETagFile() {
        return this.action.getETagFile();
    }

    @Override
    public String getUserAgent() {
        return this.action.getUserAgent();
    }

    @Override
    public boolean isQuiet() {
        return this.action.isQuiet();
    }

    @Override
    public boolean isUpToDate() {
        return this.action.isUpToDate();
    }

    @Override
    public DownloadListener getListener() {
        return this.action.getListener();
    }

    @Override
    public void setSrc(Object src) {
        this.action.setSrc(src);
    }

    @Override
    public void setDest(Path dest) {
        this.action.setDest(dest);
    }

    @Override
    public void setDest(File dest) {
        this.action.setDest(dest);
    }

    @Override
    public void setOnlyIfModified(boolean onlyIfModified) {
        this.action.setOnlyIfModified(onlyIfModified);
    }

    @Override
    public void setUseETag(Object useETag) {
        this.action.setUseETag(useETag);
    }

    @Override
    public void setETagFile(Path eTagFile) {
        this.action.setETagFile(eTagFile);
    }

    @Override
    public void setETagFile(File eTagFile) {
        this.action.setETagFile(eTagFile);
    }

    @Override
    public void setUserAgent(String userAgent) {
        this.action.setUserAgent(userAgent);
    }

    @Override
    public void setQuiet(boolean quiet) {
        this.action.setQuiet(quiet);
    }

    @Override
    public void setListener(DownloadListener listener) {
        this.action.setListener(listener);
    }
}

