/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.collection;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.covers1624.quack.annotation.ReplaceWith;
import net.covers1624.quack.annotation.ReplaceWithExpr;
import net.covers1624.quack.util.Copyable;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class ColUtils {
    @Deprecated
    @ReplaceWith(value="String#join()")
    @ApiStatus.ScheduledForRemoval(inVersion="0.4.0")
    public static String toString(Iterable<?> col) {
        return ColUtils.mkString(col, "[ ", ", ", " ]", ColUtils::toString_);
    }

    @Deprecated
    @ReplaceWith(value="String#join()")
    @ApiStatus.ScheduledForRemoval(inVersion="0.4.0")
    public static String toString(Object[] col) {
        return ColUtils.mkString(col, "[ ", ", ", " ]", ColUtils::toString_);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="0.4.0")
    private static String toString_(Object obj) {
        if (obj instanceof Iterable) {
            return ColUtils.toString((Iterable)obj);
        }
        if (obj instanceof Object[]) {
            return ColUtils.toString((Object[])obj);
        }
        return String.valueOf(obj);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="0.4.0")
    @ReplaceWithExpr(value="java.util.Arrays.stream(col).collect(Collectors.joining())")
    public static String mkString(String[] array) {
        return ColUtils.mkString(array, "");
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="0.4.0")
    @ReplaceWithExpr(value="java.util.Arrays.stream(col).collect(Collectors.joining(sep))")
    public static String mkString(String[] array, String sep) {
        return ColUtils.mkString(array, "", sep, "");
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="0.4.0")
    @ReplaceWithExpr(value="java.util.Arrays.stream(col).collect(Collectors.joining(sep, start, end))")
    public static String mkString(String[] array, String start, String sep, String end) {
        return ColUtils.mkString(Arrays.asList(array), start, sep, end);
    }

    @Deprecated
    @ReplaceWith(value="String#join()")
    @ApiStatus.ScheduledForRemoval(inVersion="0.4.0")
    public static String mkString(Iterable<String> col) {
        return ColUtils.mkString(col, "");
    }

    @Deprecated
    @ReplaceWith(value="String#join()")
    @ApiStatus.ScheduledForRemoval(inVersion="0.4.0")
    @ReplaceWithExpr(value="java.util.Arrays.stream(col).collect(Collectors.joining(sep, start, end))")
    public static String mkString(Iterable<String> col, String sep) {
        return ColUtils.mkString(col, "", sep, "");
    }

    @Deprecated
    @ReplaceWith(value="String#join()")
    @ApiStatus.ScheduledForRemoval(inVersion="0.4.0")
    @ReplaceWithExpr(value="ColUtils.stream(col).collect(Collectors.joining(sep, start, end))")
    public static String mkString(Iterable<String> col, String start, String sep, String end) {
        StringBuilder builder = new StringBuilder(start);
        boolean isFirst = true;
        for (String s : col) {
            if (!isFirst) {
                builder.append(sep);
            }
            isFirst = false;
            builder.append(s);
        }
        builder.append(end);
        return builder.toString();
    }

    @Deprecated
    @ReplaceWith(value="String#join()")
    @ApiStatus.ScheduledForRemoval(inVersion="0.4.0")
    @ReplaceWithExpr(value="java.util.Arrays.stream(col).map(func).collect(Collectors.joining(sep, start, end))")
    public static String mkString(Object[] col, String start, String sep, String end, Function<Object, String> func) {
        return ColUtils.mkString(Arrays.asList(col), start, sep, end, func);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="0.4.0")
    @ReplaceWithExpr(value="ColUtils.stream(col).map(func).collect(Collectors.joining(sep, start, end))")
    public static String mkString(Iterable<?> col, String start, String sep, String end, Function<Object, String> func) {
        StringBuilder builder = new StringBuilder(start);
        boolean isFirst = true;
        for (Object s : col) {
            if (!isFirst) {
                builder.append(sep);
            }
            isFirst = false;
            builder.append(func.apply(s));
        }
        builder.append(end);
        return builder.toString();
    }

    @Deprecated
    @ReplaceWith(value="#iterable(Enumeration)")
    @ApiStatus.ScheduledForRemoval(inVersion="0.4.0")
    public static <E> Iterable<E> toIterable(Enumeration<E> enumeration) {
        return ColUtils.iterable(enumeration);
    }

    @Deprecated
    @ReplaceWith(value="#allMatch(T[], Predicate)")
    public static <T> boolean forAll(T[] col, Predicate<T> func) {
        return ColUtils.allMatch(col, func);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="0.4.0")
    @ReplaceWith(value="#allMatch(Iterable, Predicate)")
    public static <T> boolean forAll(Iterable<T> col, Predicate<T> func) {
        return ColUtils.allMatch(col, func);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="0.4.0")
    @ReplaceWith(value="#anyMatch(Iterable, Predicate)")
    public static <T> boolean exists(Iterable<T> col, Predicate<T> func) {
        return ColUtils.anyMatch(col, func);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="0.4.0")
    @ReplaceWith(value="#findFirst(Iterable, Predicate)")
    public static <T> Optional<T> find(Iterable<T> col, Predicate<T> func) {
        return ColUtils.findFirst(col, func);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="0.4.0")
    @ReplaceWith(value="#headOption(Iterable, Predicate)")
    public static <T> T head(Iterable<T> col) {
        Iterator<T> itr = col.iterator();
        if (itr.hasNext()) {
            return itr.next();
        }
        throw new RuntimeException("Empty Iterable.");
    }

    public static <T> T[] slice(T[] arr, int from, int until) {
        int low = Math.max(from, 0);
        int high = Math.min(Math.max(until, 0), arr.length);
        int size = Math.max(high - low, 0);
        Object[] result = (Object[])Array.newInstance(arr.getClass().getComponentType(), size);
        if (size > 0) {
            System.arraycopy(arr, low, result, 0, size);
        }
        return result;
    }

    @Nullable
    public static <T> T maxBy(T[] col, ToIntFunction<T> func) {
        return ColUtils.maxBy(Arrays.asList(col), func);
    }

    @Nullable
    public static <T> T maxBy(Iterable<T> col, ToIntFunction<T> func) {
        int max = Integer.MIN_VALUE;
        T maxT = null;
        for (T t : col) {
            int x = func.applyAsInt(t);
            if (x <= max) continue;
            maxT = t;
            max = x;
        }
        return maxT;
    }

    public static <T> boolean allMatch(T[] col, Predicate<T> func) {
        return ColUtils.allMatch(Arrays.asList(col), func);
    }

    public static <T> boolean allMatch(Iterable<T> col, Predicate<T> func) {
        for (T t : col) {
            if (func.test(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean anyMatch(Iterable<T> col, Predicate<T> func) {
        for (T t : col) {
            if (!func.test(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> Optional<T> findFirst(Iterable<T> col, Predicate<T> func) {
        for (T t : col) {
            if (!func.test(t)) continue;
            return Optional.of(t);
        }
        return Optional.empty();
    }

    public static <T> Optional<T> headOption(Iterable<T> col) {
        Iterator<T> itr = col.iterator();
        if (itr.hasNext()) {
            return Optional.of(itr.next());
        }
        return Optional.empty();
    }

    @SafeVarargs
    public static <T> boolean containsKeys(Map<T, ?> map, T ... keys) {
        for (T object : keys) {
            if (map.containsKey(object)) continue;
            return false;
        }
        return true;
    }

    public static <T> T[] addToArrayFirstNull(T[] array, T value) {
        int nullIndex = -1;
        for (int i = 0; i < array.length; ++i) {
            T v = array[i];
            if (v != null) continue;
            nullIndex = i;
            break;
        }
        if (nullIndex == -1) {
            T[] copy = ColUtils.createNewArray(array, array.length + 1);
            System.arraycopy(array, 0, copy, 0, array.length);
            nullIndex = array.length;
            array = copy;
        }
        array[nullIndex] = value;
        return array;
    }

    public static <T> List<T> addAllNoNull(T[] array, List<T> list) {
        for (T value : array) {
            if (value == null) continue;
            list.add(value);
        }
        return list;
    }

    public static <T> boolean isEmpty(T[] array) {
        for (T value : array) {
            if (value == null) continue;
            return false;
        }
        return true;
    }

    public static <T> int countNonNull(T[] array) {
        return ColUtils.count(array, Objects::nonNull);
    }

    public static <T> int count(T[] array, Function<T, Boolean> check) {
        int counter = 0;
        for (T value : array) {
            if (!check.apply(value).booleanValue()) continue;
            ++counter;
        }
        return counter;
    }

    public static <T> T[] fill(T[] array, T value) {
        for (int i = 0; i < array.length; ++i) {
            T newValue = value;
            if (value instanceof Copyable) {
                Copyable copyable = (Copyable)SneakyUtils.unsafeCast(value);
                newValue = copyable.copy();
            }
            array[i] = newValue;
        }
        return array;
    }

    public static <T> void fillArray(T[] array, T value, Function<T, Boolean> check) {
        for (int i = 0; i < array.length; ++i) {
            if (!check.apply(array[i]).booleanValue()) continue;
            T newValue = value;
            if (value instanceof Copyable) {
                Copyable copyable = (Copyable)SneakyUtils.unsafeCast(value);
                newValue = copyable.copy();
            }
            array[i] = newValue;
        }
    }

    public static void arrayCopy(Object src, int srcPos, Object dst, int destPos, int length) {
        System.arraycopy(src, srcPos, dst, destPos, length);
        if (dst instanceof Copyable[]) {
            Object[] oa = (Object[])dst;
            Copyable[] c = (Copyable[])SneakyUtils.unsafeCast(dst);
            for (int i = destPos; i < destPos + length; ++i) {
                if (c[i] == null) continue;
                oa[i] = c[i].copy();
            }
        }
    }

    public static <T> int indexOf(T[] array, T object) {
        if (object == null) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < array.length; ++i) {
                if (!object.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> int indexOfRef(T[] array, T object) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != object) continue;
            return i;
        }
        return -1;
    }

    public static <T> T[] createNewArray(T[] array) {
        return ColUtils.createNewArray(array, array.length);
    }

    public static <T> T[] createNewArray(T[] array, int length) {
        Class newType = (Class)SneakyUtils.unsafeCast(array.getClass());
        Object[] copy = newType.equals(Object[].class) ? (Object[])SneakyUtils.unsafeCast(new Object[length]) : (Object[])SneakyUtils.unsafeCast(ColUtils.newArray(newType.getComponentType(), length));
        return copy;
    }

    public static <T> T[] newArray(Class<T> arrayClass, int length) {
        return (Object[])SneakyUtils.unsafeCast(Array.newInstance(arrayClass, length));
    }

    public static <T> T[] rollArray(T[] input, int shift) {
        T[] newArray = ColUtils.createNewArray(input);
        for (int i = 0; i < input.length; ++i) {
            int newPos = (i + shift) % input.length;
            if (newPos < 0) {
                newPos += input.length;
            }
            newArray[newPos] = input[i];
        }
        return newArray;
    }

    public static <T> boolean contains(T[] input, T element) {
        for (T test : input) {
            if (!Objects.equals(test, element)) continue;
            return true;
        }
        return false;
    }

    public static <T> T[] inverse(T[] input, T[] allElements) {
        LinkedList<T> list = new LinkedList<T>();
        for (T e : allElements) {
            if (ColUtils.contains(input, e)) continue;
            list.add(e);
        }
        return list.toArray(ColUtils.createNewArray(input, list.size()));
    }

    public static <T> boolean isNullOrContainsNull(T @Nullable [] input) {
        if (input == null) {
            return true;
        }
        for (T t : input) {
            if (t != null) continue;
            return true;
        }
        return false;
    }

    public static List<Integer> toList(int[] arr) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i : arr) {
            list.add(i);
        }
        return list;
    }

    public static <E> Iterable<E> iterable(final Enumeration<E> enumeration) {
        return () -> new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public E next() {
                return enumeration.nextElement();
            }
        };
    }

    public static <E> Iterable<E> iterable(Stream<E> stream) {
        return stream::iterator;
    }

    public static <E> Stream<E> stream(Iterable<E> iter) {
        return StreamSupport.stream(iter.spliterator(), false);
    }

    public static <E> Stream<E> parallelStream(Iterable<E> iter) {
        return StreamSupport.stream(iter.spliterator(), true);
    }

    @Nullable
    public static <T> T onlyOrDefault(Stream<T> stream) {
        return ColUtils.onlyOrDefault(stream, null);
    }

    @Nullable
    @Contract(value="_,!null -> !null")
    public static <T> T onlyOrDefault(Stream<T> stream, @Nullable T _default) {
        T thing = _default;
        boolean found = false;
        for (T t : ColUtils.iterable(stream)) {
            if (found) {
                return _default;
            }
            found = true;
            thing = t;
        }
        return thing;
    }

    public static <T> T only(Stream<T> stream) {
        T thing = null;
        boolean found = false;
        for (T t : ColUtils.iterable(stream)) {
            if (found) {
                throw new IllegalArgumentException("More than one element.");
            }
            found = true;
            thing = t;
        }
        if (!found) {
            throw new IllegalArgumentException("Not found.");
        }
        return thing;
    }
}

