/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.net.download;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Collections;
import java.util.Date;
import java.util.function.Predicate;
import net.covers1624.quack.annotation.Requires;
import net.covers1624.quack.collection.ColUtils;
import net.covers1624.quack.net.download.DownloadListener;
import net.covers1624.quack.net.download.DownloadSpec;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@Requires.RequiresList(value={@Requires(value="org.apache.commons:commons-lang3"), @Requires(value="org.apache.logging.log4j:log4j-api"), @Requires(value="org.apache.httpcomponents:httpclient")})
public class DownloadAction
implements DownloadSpec {
    private static final Logger logger = LogManager.getLogger((String)"DownloadAction");
    private Object src;
    private Path dest;
    private boolean onlyIfModified;
    private UseETag useETag = UseETag.FALSE;
    private Path eTagFile;
    private String userAgent;
    private boolean quiet;
    private Predicate<Path> fileUpToDate = e -> true;
    private DownloadListener listener;
    private boolean upToDate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws IOException {
        if (this.src == null) {
            throw new IllegalArgumentException("Download source not provided");
        }
        if (this.dest == null) {
            throw new IllegalArgumentException("Download destination not provided.");
        }
        URL src = this.getSrc();
        Path dest = this.getDest();
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            HttpGet request = new HttpGet(src.toString());
            long timestamp = 0L;
            if (Files.exists(dest, new LinkOption[0])) {
                timestamp = Files.getLastModifiedTime(dest, new LinkOption[0]).toMillis();
            }
            if (this.onlyIfModified && Files.exists(dest, new LinkOption[0])) {
                request.addHeader("If-Modified-Since", DateUtils.formatDate((Date)new Date(timestamp)));
            }
            if (this.getUseETag().isEnabled()) {
                String etag = this.loadETag(src);
                if (!this.getUseETag().weak && StringUtils.startsWith((CharSequence)etag, (CharSequence)"W/")) {
                    etag = null;
                }
                if (etag != null) {
                    request.addHeader("If-None-Match", etag);
                }
            }
            request.addHeader("Accept-Encoding", "gzip");
            if (this.getUserAgent() != null) {
                request.addHeader("User-Agent", this.getUserAgent());
            }
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)request);){
                long processed;
                long lastModified;
                block88: {
                    Path dstTmp;
                    block87: {
                        Date date;
                        String val;
                        int code = response.getStatusLine().getStatusCode();
                        if ((code < 200 || code > 299) && code != 304) {
                            throw new HttpResponseException(code, response.getStatusLine().getReasonPhrase());
                        }
                        lastModified = 0L;
                        Header lastModifiedHeader = response.getLastHeader("Last-Modified");
                        if (lastModifiedHeader != null && !StringUtils.isEmpty((CharSequence)(val = lastModifiedHeader.getValue())) && (date = DateUtils.parseDate((String)val)) != null) {
                            lastModified = date.getTime();
                        }
                        if ((code == 304 || lastModified != 0L && timestamp >= lastModified) && this.fileUpToDate.test(dest)) {
                            if (!this.isQuiet()) {
                                logger.info("Not Modified. Skipping '{}'.", (Object)src);
                            }
                            this.upToDate = true;
                            return;
                        }
                        HttpEntity entity = response.getEntity();
                        if (entity == null) {
                            return;
                        }
                        long contentLen = entity.getContentLength();
                        processed = 0L;
                        if (this.listener != null) {
                            this.listener.start(contentLen);
                        }
                        boolean finished = false;
                        dstTmp = dest.resolveSibling("__tmp_" + dest.getFileName());
                        if (Files.notExists(dstTmp.getParent(), new LinkOption[0])) {
                            Files.createDirectories(dstTmp.getParent(), new FileAttribute[0]);
                        }
                        try {
                            try (InputStream is = entity.getContent();
                                 OutputStream os = Files.newOutputStream(dstTmp, StandardOpenOption.CREATE);){
                                int len;
                                byte[] buffer = new byte[16384];
                                while ((len = is.read(buffer)) >= 0) {
                                    os.write(buffer, 0, len);
                                    processed += (long)len;
                                    if (this.listener == null) continue;
                                    this.listener.update(processed);
                                }
                                os.flush();
                                finished = true;
                            }
                            if (finished) break block87;
                        }
                        catch (Throwable throwable) {
                            if (!finished) {
                                Files.delete(dstTmp);
                            } else {
                                Files.move(dstTmp, dest, StandardCopyOption.REPLACE_EXISTING);
                                if (Files.notExists(dest.getParent(), new LinkOption[0])) {
                                    Files.createDirectories(dest.getParent(), new FileAttribute[0]);
                                }
                            }
                            if (this.listener == null) throw throwable;
                            this.listener.finish(processed);
                            throw throwable;
                        }
                        Files.delete(dstTmp);
                        break block88;
                    }
                    Files.move(dstTmp, dest, StandardCopyOption.REPLACE_EXISTING);
                    if (Files.notExists(dest.getParent(), new LinkOption[0])) {
                        Files.createDirectories(dest.getParent(), new FileAttribute[0]);
                    }
                }
                if (this.listener != null) {
                    this.listener.finish(processed);
                }
                if (this.onlyIfModified && lastModified > 0L) {
                    Files.setLastModifiedTime(dest, FileTime.fromMillis(lastModified));
                }
                if (!this.getUseETag().isEnabled()) return;
                Header eTagHeader = response.getFirstHeader("ETag");
                if (eTagHeader == null) return;
                String etag = eTagHeader.getValue();
                boolean isWeak = StringUtils.startsWith((CharSequence)etag, (CharSequence)"W/");
                if (isWeak && this.getUseETag().warnOnWeak && !this.quiet) {
                    logger.warn("Weak ETag found.");
                }
                if (isWeak) {
                    if (!this.getUseETag().weak) return;
                }
                this.saveETag(src, etag);
                return;
            }
        }
    }

    @Nullable
    protected String loadETag(URL url) {
        Path eTagFile = this.getETagFile();
        if (Files.notExists(eTagFile, new LinkOption[0])) {
            return null;
        }
        try {
            return ColUtils.headOption(Files.readAllLines(eTagFile)).orElse(null);
        }
        catch (IOException e) {
            logger.warn("Error reading ETag file '{}'.", (Object)eTagFile);
            return null;
        }
    }

    protected void saveETag(URL url, String eTag) {
        Path eTagFile = this.getETagFile();
        try {
            Path tmp = eTagFile.resolveSibling("__tmp_" + eTagFile.getFileName());
            Files.write(tmp, Collections.singleton(eTag), StandardOpenOption.CREATE);
            Files.move(tmp, eTagFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            logger.warn("Error saving ETag file '{}'.", (Object)eTagFile, (Object)e);
        }
    }

    public static String toLengthText(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return bytes / 1024L + " KB";
        }
        if (bytes < 0x40000000L) {
            return String.format("%.2f MB", (double)bytes / 1048576.0);
        }
        return String.format("%.2f GB", (double)bytes / 1.073741824E9);
    }

    @Override
    public void fileUpToDateWhen(Predicate<Path> spec) {
        this.fileUpToDate = this.fileUpToDate.and(spec);
    }

    @Override
    public URL getSrc() {
        return this.makeURL(this.src);
    }

    @Override
    public Path getDest() {
        return this.dest;
    }

    @Override
    public boolean getOnlyIfModified() {
        return this.onlyIfModified;
    }

    @Override
    public UseETag getUseETag() {
        return this.useETag;
    }

    @Override
    public Path getETagFile() {
        return this.getETagFile_();
    }

    @Override
    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    public DownloadListener getListener() {
        return this.listener;
    }

    @Override
    public boolean isQuiet() {
        return this.quiet;
    }

    @Override
    public boolean isUpToDate() {
        return this.upToDate;
    }

    @Override
    public void setSrc(Object src) {
        this.src = src;
    }

    @Override
    public void setDest(Path dest) {
        this.dest = dest;
    }

    @Override
    public void setOnlyIfModified(boolean onlyIfModified) {
        this.onlyIfModified = onlyIfModified;
    }

    @Override
    public void setUseETag(Object eTag) {
        this.useETag = UseETag.parse(eTag);
    }

    @Override
    public void setETagFile(Path eTagFile) {
        this.eTagFile = eTagFile;
    }

    @Override
    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    @Override
    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    @Override
    public void setListener(DownloadListener listener) {
        this.listener = listener;
    }

    private Path getETagFile_() {
        if (this.eTagFile == null) {
            Path dest = this.getDest();
            return dest.resolveSibling(dest.getFileName() + ".etag");
        }
        return this.eTagFile;
    }

    private URL makeURL(Object object) {
        if (object instanceof CharSequence) {
            try {
                return new URL(((CharSequence)object).toString());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid URL " + object, e);
            }
        }
        if (object instanceof URL) {
            return (URL)object;
        }
        throw new IllegalArgumentException("Expected CharSequence or URL. Got: " + object.getClass());
    }

    public static enum UseETag {
        FALSE(false, false),
        TRUE(true, true),
        ALL(true, false),
        STRONG(false, false);

        public final boolean weak;
        public final boolean warnOnWeak;

        private UseETag(boolean weak, boolean warnOnWeak) {
            this.weak = weak;
            this.warnOnWeak = warnOnWeak;
        }

        public boolean isEnabled() {
            return this != FALSE;
        }

        public static UseETag parse(Object value) {
            if (value instanceof UseETag) {
                return (UseETag)((Object)value);
            }
            if (value instanceof Boolean) {
                if (((Boolean)value).booleanValue()) {
                    return TRUE;
                }
                return FALSE;
            }
            if (value instanceof String) {
                switch ((String)value) {
                    case "true": {
                        return TRUE;
                    }
                    case "false": {
                        return FALSE;
                    }
                    case "all": {
                        return ALL;
                    }
                    case "strong": {
                        return STRONG;
                    }
                }
            }
            throw new IllegalArgumentException("Unable to parse ETag, Unknown value: " + value);
        }
    }
}

