/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.collection;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.covers1624.quack.annotation.Requires;
import net.covers1624.quack.collection.ColUtils;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

@Requires(value="com.google.guava:guava")
public interface StreamableIterable<T>
extends Iterable<T> {
    public static final StreamableIterable<?> EMPTY = StreamableIterable.of(Collections.emptyList());

    public static <T> StreamableIterable<T> empty() {
        return (StreamableIterable)SneakyUtils.unsafeCast(EMPTY);
    }

    public static <T> StreamableIterable<T> of(Iterable<T> itr) {
        return itr::iterator;
    }

    public static <T> StreamableIterable<T> of() {
        return (StreamableIterable)SneakyUtils.unsafeCast(EMPTY);
    }

    public static <T> StreamableIterable<T> of(T thing) {
        return StreamableIterable.of(Collections.singletonList(thing));
    }

    @SafeVarargs
    public static <T> StreamableIterable<T> of(T ... things) {
        return StreamableIterable.of(Arrays.asList(things));
    }

    @SafeVarargs
    public static <T> StreamableIterable<T> concat(StreamableIterable<T> ... iterables) {
        return StreamableIterable.of(Iterables.concat((Iterable[])iterables));
    }

    public static <T> StreamableIterable<T> concat(Iterable<StreamableIterable<T>> iterables) {
        return StreamableIterable.of(Iterables.concat(iterables));
    }

    default public StreamableIterable<T> concat(StreamableIterable<T> other) {
        return StreamableIterable.concat(this, other);
    }

    default public StreamableIterable<T> filter(final Predicate<? super T> pred) {
        return () -> new AbstractIterator<T>(){
            private final Iterator itr;
            {
                this.itr = StreamableIterable.this.iterator();
            }

            protected T computeNext() {
                while (this.itr.hasNext()) {
                    Object e = this.itr.next();
                    if (!pred.test(e)) continue;
                    return e;
                }
                return this.endOfData();
            }
        };
    }

    default public StreamableIterable<T> filterNot(Predicate<? super T> pred) {
        return this.filter(pred.negate());
    }

    default public <R> StreamableIterable<R> map(final Function<? super T, ? extends R> func) {
        return () -> new Iterator<R>(){
            private final Iterator itr;
            {
                this.itr = StreamableIterable.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }

            @Override
            public R next() {
                return func.apply(this.itr.next());
            }

            @Override
            public void remove() {
                this.itr.remove();
            }
        };
    }

    default public <R> StreamableIterable<R> flatMap(final Function<? super T, ? extends Iterable<? extends R>> func) {
        return () -> new AbstractIterator<R>(){
            private final Iterator itr;
            @Nullable
            Iterator working;
            {
                this.itr = StreamableIterable.this.iterator();
                this.working = null;
            }

            protected R computeNext() {
                while (true) {
                    if (this.working == null) {
                        if (!this.itr.hasNext()) break;
                        this.working = ((Iterable)func.apply(this.itr.next())).iterator();
                    }
                    if (this.working.hasNext()) {
                        return this.working.next();
                    }
                    this.working = null;
                }
                return this.endOfData();
            }
        };
    }

    default public StreamableIterable<T> distinct() {
        HashSet set = new HashSet();
        return this.filter(set::add);
    }

    default public StreamableIterable<T> peek(final Consumer<T> action) {
        return () -> new Iterator<T>(){
            private final Iterator itr;
            {
                this.itr = StreamableIterable.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }

            @Override
            public T next() {
                Object n = this.itr.next();
                action.accept(n);
                return n;
            }
        };
    }

    default public StreamableIterable<T> limit(final @Range(from=-1L, to=0x7FFFFFFFL) int max) {
        if (max == -1) {
            return this;
        }
        if (max == 0) {
            return Collections::emptyIterator;
        }
        return () -> new AbstractIterator<T>(){
            private int count;
            private final Iterator itr;
            {
                this.itr = StreamableIterable.this.iterator();
                this.count = 0;
            }

            protected T computeNext() {
                if (!this.itr.hasNext()) {
                    return this.endOfData();
                }
                if (this.count++ >= max) {
                    return this.endOfData();
                }
                return this.itr.next();
            }
        };
    }

    default public StreamableIterable<T> skip(final @Range(from=0L, to=0x7FFFFFFFL) int n) {
        if (n == 0) {
            return this;
        }
        return () -> new AbstractIterator<T>(){
            private int count;
            private final Iterator itr;
            {
                this.itr = StreamableIterable.this.iterator();
                this.count = 0;
            }

            protected T computeNext() {
                while (this.itr.hasNext()) {
                    Object next = this.itr.next();
                    if (this.count++ < n) continue;
                    return next;
                }
                return this.endOfData();
            }
        };
    }

    default public Object[] toArray() {
        return this.toList().toArray();
    }

    default public T[] toArray(T[] arr) {
        return this.toList().toArray(arr);
    }

    @Nullable
    @Contract(value="null,_->null")
    default public T fold(@Nullable T identity, BinaryOperator<@Nullable T> accumulator) {
        Object ret = identity;
        for (Object t : this) {
            ret = accumulator.apply(ret, t);
        }
        return ret;
    }

    default public Optional<T> fold(BinaryOperator<T> accumulator) {
        boolean found = false;
        Object ret = null;
        for (Object t : this) {
            ret = found ? (Object)accumulator.apply(ret, t) : (Object)t;
            found = true;
        }
        return found ? Optional.ofNullable(ret) : Optional.empty();
    }

    default public int count() {
        int i = 0;
        for (Object ignored : this) {
            ++i;
        }
        return i;
    }

    default public boolean anyMatch(Predicate<? super T> test) {
        for (Object t : this) {
            if (!test.test(t)) continue;
            return true;
        }
        return false;
    }

    default public boolean allMatch(Predicate<? super T> test) {
        for (Object t : this) {
            if (test.test(t)) continue;
            return false;
        }
        return true;
    }

    default public boolean noneMatch(Predicate<? super T> test) {
        for (Object t : this) {
            if (!test.test(t)) continue;
            return false;
        }
        return true;
    }

    default public Optional<T> findFirst() {
        return ColUtils.headOption(this);
    }

    default public Optional<T> findLast() {
        return ColUtils.tailOption(this);
    }

    default public ArrayList<T> toList() {
        return Lists.newArrayList((Iterable)this);
    }

    default public LinkedList<T> toLinkedList() {
        return Lists.newLinkedList((Iterable)this);
    }

    default public HashSet<T> toSet() {
        return Sets.newHashSet((Iterable)this);
    }

    default public <K, V> HashMap<K, V> toMap(Function<T, K> keyFunc, Function<T, V> valueFunc) {
        return this.toMap(new HashMap(), keyFunc, valueFunc);
    }

    default public <K, V> HashMap<K, V> toMap(Function<T, K> keyFunc, Function<T, V> valueFunc, BinaryOperator<V> mergeFunc) {
        return this.toMap(new HashMap(), keyFunc, valueFunc, mergeFunc);
    }

    default public <K, V> HashMap<K, V> toLinkedHashMap(Function<T, K> keyFunc, Function<T, V> valueFunc) {
        return this.toMap(new LinkedHashMap(), keyFunc, valueFunc);
    }

    default public <K, V> HashMap<K, V> toLinkedHashMap(Function<T, K> keyFunc, Function<T, V> valueFunc, BinaryOperator<V> mergeFunc) {
        return this.toMap(new LinkedHashMap(), keyFunc, valueFunc, mergeFunc);
    }

    default public <K, V, M extends Map<K, V>> M toMap(M map, Function<T, K> keyFunc, Function<T, V> valueFunc) {
        return this.toMap(map, keyFunc, valueFunc, SneakyUtils.first());
    }

    default public <K, V, M extends Map<K, V>> M toMap(M map, Function<T, K> keyFunc, Function<T, V> valueFunc, BinaryOperator<V> mergeFunc) {
        for (Object t : this) {
            K key = keyFunc.apply(t);
            V value = valueFunc.apply(t);
            V existing = map.get(key);
            if (existing == null) {
                map.put(key, valueFunc.apply(t));
                continue;
            }
            map.put(key, mergeFunc.apply(existing, value));
        }
        return map;
    }

    default public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public Stream<T> parallelStream() {
        return StreamSupport.stream(this.spliterator(), true);
    }
}

