/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.gradle.net.download;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.Objects;
import net.covers1624.quack.annotation.Requires;
import net.covers1624.quack.gradle.net.download.ProgressLoggerListener;
import net.covers1624.quack.net.DownloadAction;
import net.covers1624.quack.net.apache.ApacheHttpClientDownloadAction;
import net.covers1624.quack.net.download.DownloadListener;
import org.apache.http.impl.client.CloseableHttpClient;
import org.gradle.api.DefaultTask;
import org.gradle.api.internal.tasks.TaskExecutionOutcome;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.Nullable;

@Requires.RequiresList(value={@Requires(value="org.slf4j:slf4j-api"), @Requires(value="org.gradle:gradle-api"), @Requires(value="org.apache.httpcomponents:httpclient")})
public class ApacheHttpClientDownloadTask
extends DefaultTask
implements DownloadAction {
    private final ApacheHttpClientDownloadAction action = new ApacheHttpClientDownloadAction();

    public ApacheHttpClientDownloadTask() {
        this.getOutputs().upToDateWhen(e -> false);
    }

    @Override
    @TaskAction
    public void execute() throws IOException {
        if (this.getDownloadListener() == null && !this.getQuiet()) {
            this.setDownloadListener(Objects.requireNonNull(ProgressLoggerListener.create(this.getProject(), this)));
        }
        this.action.execute();
        if (this.isUpToDate()) {
            this.getState().setOutcome(TaskExecutionOutcome.UP_TO_DATE);
            this.setDidWork(false);
        }
    }

    public ApacheHttpClientDownloadTask setClient(CloseableHttpClient client) {
        this.action.setClient(client);
        return this;
    }

    @Override
    public ApacheHttpClientDownloadTask setUrl(String url) {
        this.action.setUrl(url);
        return this;
    }

    @Override
    public ApacheHttpClientDownloadTask setDest(DownloadAction.Dest dest) {
        this.action.setDest(dest);
        return this;
    }

    @Override
    public ApacheHttpClientDownloadTask setDest(StringWriter sw) {
        this.action.setDest(sw);
        return this;
    }

    @Override
    public ApacheHttpClientDownloadTask setDest(OutputStream os) {
        this.action.setDest(os);
        return this;
    }

    @Override
    public ApacheHttpClientDownloadTask setDest(File file) {
        this.action.setDest(file);
        return this;
    }

    @Override
    public ApacheHttpClientDownloadTask setDest(Path path) {
        this.action.setDest(path);
        return this;
    }

    @Override
    public ApacheHttpClientDownloadTask setOnlyIfModified(boolean onlyIfModified) {
        this.action.setOnlyIfModified(onlyIfModified);
        return this;
    }

    @Override
    public ApacheHttpClientDownloadTask setUseETag(boolean useETag) {
        this.action.setUseETag(useETag);
        return this;
    }

    @Override
    public ApacheHttpClientDownloadTask setQuiet(boolean quiet) {
        this.action.setQuiet(quiet);
        return this;
    }

    @Override
    public ApacheHttpClientDownloadTask setUserAgent(String userAgent) {
        this.action.setUserAgent(userAgent);
        return this;
    }

    @Override
    public ApacheHttpClientDownloadTask setDownloadListener(DownloadListener downloadListener) {
        this.action.setDownloadListener(downloadListener);
        return this;
    }

    public CloseableHttpClient getClient() {
        return this.action.getClient();
    }

    @Override
    @Nullable
    public String getUrl() {
        return this.action.getUrl();
    }

    @Override
    @Nullable
    public DownloadAction.Dest getDest() {
        return this.action.getDest();
    }

    @Override
    public boolean getOnlyIfModified() {
        return this.action.getOnlyIfModified();
    }

    @Override
    public boolean getUseETag() {
        return this.action.getUseETag();
    }

    @Override
    public boolean getQuiet() {
        return this.action.getQuiet();
    }

    @Override
    @Nullable
    public String getUserAgent() {
        return this.action.getUserAgent();
    }

    @Override
    @Nullable
    public DownloadListener getDownloadListener() {
        return this.action.getDownloadListener();
    }

    @Override
    public boolean isUpToDate() {
        return this.action.isUpToDate();
    }
}

