/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.net;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileTime;
import net.covers1624.quack.io.IOUtils;
import net.covers1624.quack.io.WriterOutputStream;
import net.covers1624.quack.net.download.DownloadListener;
import org.jetbrains.annotations.Nullable;

public interface DownloadAction {
    public void execute() throws IOException;

    public DownloadAction setUrl(String var1);

    public DownloadAction setDest(Dest var1);

    public DownloadAction setDest(StringWriter var1);

    public DownloadAction setDest(OutputStream var1);

    public DownloadAction setDest(File var1);

    public DownloadAction setDest(Path var1);

    public DownloadAction setOnlyIfModified(boolean var1);

    public DownloadAction setUseETag(boolean var1);

    public DownloadAction setQuiet(boolean var1);

    public DownloadAction setUserAgent(String var1);

    public DownloadAction setDownloadListener(DownloadListener var1);

    @Nullable
    public String getUrl();

    @Nullable
    public Dest getDest();

    public boolean getOnlyIfModified();

    public boolean getUseETag();

    public boolean getQuiet();

    @Nullable
    public String getUserAgent();

    @Nullable
    public DownloadListener getDownloadListener();

    public boolean isUpToDate();

    public static interface Dest {
        public OutputStream getOutputStream() throws IOException;

        @Nullable
        public String getEtag() throws IOException;

        public void setEtag(String var1) throws IOException;

        public long getLastModified() throws IOException;

        public void setLastModified(long var1) throws IOException;

        public void onFinished(boolean var1) throws IOException;

        public static Dest string(StringWriter sw) {
            return Dest.string(sw, StandardCharsets.UTF_8);
        }

        public static Dest string(StringWriter sw, Charset charset) {
            return Dest.stream(new WriterOutputStream((Writer)sw, charset));
        }

        public static Dest stream(final OutputStream os) {
            return new Dest(){

                @Override
                public OutputStream getOutputStream() {
                    return os;
                }

                @Override
                @Nullable
                public String getEtag() {
                    return null;
                }

                @Override
                public void setEtag(String etag) {
                }

                @Override
                public long getLastModified() {
                    return -1L;
                }

                @Override
                public void setLastModified(long time) {
                }

                @Override
                public void onFinished(boolean success) {
                }
            };
        }

        public static Dest file(File file) {
            return Dest.path(file.toPath());
        }

        public static Dest path(final Path path) {
            return new Dest(){
                private final Path tempFile;
                private final Path eTagFile;
                {
                    this.tempFile = path.resolveSibling("__tmp_" + path.getFileName());
                    this.eTagFile = path.resolveSibling(path.getFileName() + ".etag");
                }

                @Override
                public OutputStream getOutputStream() throws IOException {
                    return Files.newOutputStream(IOUtils.makeParents(this.tempFile), new OpenOption[0]);
                }

                @Override
                @Nullable
                public String getEtag() throws IOException {
                    if (Files.notExists(this.eTagFile, new LinkOption[0])) {
                        return null;
                    }
                    return new String(Files.readAllBytes(this.eTagFile), StandardCharsets.UTF_8);
                }

                @Override
                public void setEtag(String etag) throws IOException {
                    Files.write(IOUtils.makeParents(this.eTagFile), etag.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }

                @Override
                public long getLastModified() throws IOException {
                    if (Files.notExists(path, new LinkOption[0])) {
                        return -1L;
                    }
                    return Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
                }

                @Override
                public void setLastModified(long time) throws IOException {
                    Files.setLastModifiedTime(path, FileTime.fromMillis(time));
                }

                @Override
                public void onFinished(boolean success) throws IOException {
                    if (success) {
                        Files.move(this.tempFile, path, StandardCopyOption.REPLACE_EXISTING);
                    } else {
                        Files.deleteIfExists(this.tempFile);
                    }
                }
            };
        }
    }
}

