/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.net.apache;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.Date;
import java.util.Objects;
import net.covers1624.quack.annotation.Requires;
import net.covers1624.quack.io.IOUtils;
import net.covers1624.quack.io.ProgressInputStream;
import net.covers1624.quack.net.DownloadAction;
import net.covers1624.quack.net.HttpResponseException;
import net.covers1624.quack.net.download.DownloadListener;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires.RequiresList(value={@Requires(value="org.slf4j:slf4j-api"), @Requires(value="org.apache.httpcomponents:httpclient")})
public class ApacheHttpClientDownloadAction
implements DownloadAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApacheHttpClientDownloadAction.class);
    private static final CloseableHttpClient CLIENT = HttpClientBuilder.create().build();
    private CloseableHttpClient client = CLIENT;
    @Nullable
    private String url;
    @Nullable
    private DownloadAction.Dest dest;
    private boolean onlyIfModified;
    private boolean useETag;
    private boolean quiet = true;
    @Nullable
    private String userAgent;
    @Nullable
    private DownloadListener downloadListener;
    private boolean upToDate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws IOException {
        String url = Objects.requireNonNull(this.url, "URL not set");
        DownloadAction.Dest dest = Objects.requireNonNull(this.dest, "Dest not set");
        HttpGet get = new HttpGet(url);
        if (this.userAgent != null) {
            get.addHeader("User-Agent", this.userAgent);
        }
        String etag = dest.getEtag();
        if (this.useETag && etag != null) {
            get.addHeader("If-None-Match", etag.trim());
        }
        long lastModified = dest.getLastModified();
        if (this.onlyIfModified && lastModified != -1L) {
            get.addHeader("If-Modified-Since", DateUtils.formatDate((Date)new Date(lastModified)));
        }
        if (this.downloadListener != null) {
            this.downloadListener.connecting();
        }
        if (!this.quiet) {
            LOGGER.info("Connecting to {}.", (Object)url);
        }
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)get);){
            boolean timestampNotModified;
            boolean expectNotModified;
            StatusLine line = response.getStatusLine();
            int code = line.getStatusCode();
            boolean bl = expectNotModified = this.useETag || this.onlyIfModified;
            if (!(code >= 200 && code <= 299 || expectNotModified && code == 304)) {
                throw new HttpResponseException(code, line.getReasonPhrase());
            }
            Header lastModifiedHeader = response.getLastHeader("Last-Modified");
            Date lastModifiedHeaderDate = null;
            if (lastModifiedHeader != null) {
                lastModifiedHeaderDate = DateUtils.parseDate((String)lastModifiedHeader.getValue());
            }
            boolean notModified = expectNotModified && code == 304;
            boolean bl2 = timestampNotModified = this.onlyIfModified && lastModifiedHeader != null && lastModified >= lastModifiedHeaderDate.getTime();
            if (notModified || timestampNotModified) {
                if (!this.quiet) {
                    String reason = "";
                    if (code == 304) {
                        reason = reason + "304 not modified ";
                    }
                    if (timestampNotModified) {
                        reason = reason + "Last-Modified header";
                    }
                    LOGGER.info("Not Modified ({}). Skipping '{}'.", (Object)reason.trim(), (Object)url);
                }
                this.upToDate = true;
                return;
            }
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                return;
            }
            long contentLen = entity.getContentLength();
            if (this.downloadListener != null) {
                this.downloadListener.start(contentLen);
            }
            InputStream content = entity.getContent();
            if (this.downloadListener != null) {
                content = new ProgressInputStream(content, this.downloadListener);
            }
            if (!this.quiet) {
                LOGGER.info("Downloading '{}'.", (Object)url);
            }
            boolean success = false;
            try (InputStream is = content;
                 OutputStream os = dest.getOutputStream();){
                IOUtils.copy(is, os);
                success = true;
            }
            finally {
                if (!this.quiet) {
                    LOGGER.info("Finished '{}'. Success? {}", (Object)url, (Object)success);
                }
                dest.onFinished(success);
            }
            if (this.onlyIfModified && lastModifiedHeaderDate != null) {
                dest.setLastModified(lastModifiedHeaderDate.getTime());
            }
            Header eTagHeader = response.getFirstHeader("ETag");
            if (this.useETag && eTagHeader != null) {
                dest.setEtag(eTagHeader.getValue());
            }
        }
    }

    public ApacheHttpClientDownloadAction setClient(CloseableHttpClient client) {
        this.client = client;
        return this;
    }

    @Override
    public ApacheHttpClientDownloadAction setUrl(String url) {
        this.url = url;
        return this;
    }

    @Override
    public ApacheHttpClientDownloadAction setDest(DownloadAction.Dest dest) {
        this.dest = dest;
        return this;
    }

    @Override
    public ApacheHttpClientDownloadAction setDest(StringWriter sw) {
        return this.setDest(DownloadAction.Dest.string(sw));
    }

    @Override
    public DownloadAction setDest(OutputStream os) {
        return this.setDest(DownloadAction.Dest.stream(os));
    }

    @Override
    public ApacheHttpClientDownloadAction setDest(File file) {
        return this.setDest(DownloadAction.Dest.file(file));
    }

    @Override
    public ApacheHttpClientDownloadAction setDest(Path path) {
        return this.setDest(DownloadAction.Dest.path(path));
    }

    @Override
    public ApacheHttpClientDownloadAction setOnlyIfModified(boolean onlyIfModified) {
        this.onlyIfModified = onlyIfModified;
        return this;
    }

    @Override
    public ApacheHttpClientDownloadAction setUseETag(boolean useETag) {
        this.useETag = useETag;
        return this;
    }

    @Override
    public ApacheHttpClientDownloadAction setQuiet(boolean quiet) {
        this.quiet = quiet;
        return this;
    }

    @Override
    public ApacheHttpClientDownloadAction setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    @Override
    public ApacheHttpClientDownloadAction setDownloadListener(DownloadListener downloadListener) {
        this.downloadListener = downloadListener;
        return this;
    }

    @Override
    public boolean isUpToDate() {
        return this.upToDate;
    }

    public CloseableHttpClient getClient() {
        return this.client;
    }

    @Override
    @Nullable
    public String getUrl() {
        return this.url;
    }

    @Override
    @Nullable
    public DownloadAction.Dest getDest() {
        return this.dest;
    }

    @Override
    public boolean getOnlyIfModified() {
        return this.onlyIfModified;
    }

    @Override
    public boolean getUseETag() {
        return this.useETag;
    }

    @Override
    public boolean getQuiet() {
        return this.quiet;
    }

    @Override
    @Nullable
    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    @Nullable
    public DownloadListener getDownloadListener() {
        return this.downloadListener;
    }
}

