/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.net.httpapi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public final class HeaderList
implements Iterable<Entry> {
    private final List<String> headers = new ArrayList<String>();

    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    public int size() {
        return this.headers.size() / 2;
    }

    public void add(String name, String value) {
        if (name.isEmpty()) {
            throw new IllegalStateException("Key name must not be empty!");
        }
        HeaderList.checkNameChars(name);
        HeaderList.checkValueChars(name, value);
        this.headers.add(name);
        this.headers.add(value.trim());
    }

    public void addFirst(String name, String value) {
        if (name.isEmpty()) {
            throw new IllegalStateException("Key name must not be empty!");
        }
        HeaderList.checkNameChars(name);
        HeaderList.checkValueChars(name, value);
        this.headers.add(0, value.trim());
        this.headers.add(0, name);
    }

    public void addAll(Map<String, String> entries) {
        for (Map.Entry<String, String> entry : entries.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    public void addAllMulti(Map<String, List<String>> entries) {
        for (Map.Entry<String, List<String>> entry : entries.entrySet()) {
            for (String value : entry.getValue()) {
                this.add(entry.getKey(), value);
            }
        }
    }

    public void addAll(HeaderList other) {
        this.headers.addAll(other.headers);
    }

    public void set(String name, String value) {
        HeaderList.checkNameChars(name);
        HeaderList.checkValueChars(name, value);
        this.removeAll(name);
        this.add(name, value);
    }

    public boolean contains(String name, String value) {
        for (int i = 0; i < this.headers.size(); i += 2) {
            String v = this.headers.get(i);
            if (!v.equalsIgnoreCase(name) || !this.headers.get(i + 1).equals(value)) continue;
            return true;
        }
        return false;
    }

    public void removeAll(String name) {
        for (int i = 0; i < this.headers.size(); i += 2) {
            if (!this.headers.get(i).equalsIgnoreCase(name)) continue;
            this.headers.remove(i);
            this.headers.remove(i);
            i -= 2;
        }
    }

    @Nullable
    public String get(String name) {
        for (int i = 0; i < this.headers.size(); ++i) {
            if (!this.headers.get(i).equalsIgnoreCase(name)) continue;
            return this.headers.get(i + 1);
        }
        return null;
    }

    public List<String> getValues(String name) {
        LinkedList<String> values = new LinkedList<String>();
        for (int i = 0; i < this.headers.size(); ++i) {
            if (!this.headers.get(i).equalsIgnoreCase(name)) continue;
            values.add(this.headers.get(i + 1));
        }
        return values;
    }

    public void clear() {
        this.headers.clear();
    }

    public String[] toStrings() {
        if (this.headers.isEmpty()) {
            return new String[0];
        }
        int i = 0;
        String[] strings = new String[this.headers.size() / 2];
        for (Entry entry : this) {
            strings[i++] = entry.name + ": " + entry.value;
        }
        return strings;
    }

    public String[] toArray() {
        return this.headers.toArray(new String[0]);
    }

    @Override
    public Iterator<Entry> iterator() {
        final Iterator<String> backing = this.headers.iterator();
        return new Iterator<Entry>(){

            @Override
            public boolean hasNext() {
                return backing.hasNext();
            }

            @Override
            public Entry next() {
                return new Entry((String)backing.next(), (String)backing.next());
            }
        };
    }

    private static void checkNameChars(String name) {
        char[] charArray = name.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if ('!' <= c && c <= '~') continue;
            throw new IllegalArgumentException(String.format("Name '%s' Contains invalid character \\u%04X at %d", name, (int)c, i));
        }
    }

    private static void checkValueChars(String name, String value) {
        char[] charArray = value.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (c == '\t' || ' ' <= c && c <= '~') continue;
            throw new IllegalArgumentException(String.format("Value for name '%s' Contains invalid character \\u%04X at %d", name, (int)c, i));
        }
    }

    public static class Entry
    implements Map.Entry<String, String> {
        public final String name;
        public final String value;

        public Entry(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.name;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String setValue(String value) {
            throw new UnsupportedOperationException();
        }
    }
}

