/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.net.httpapi.curl4j;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import net.covers1624.curl4j.CURL;
import net.covers1624.curl4j.CURLMsg;
import net.covers1624.curl4j.CurlWriteCallback;
import net.covers1624.curl4j.core.Memory;
import net.covers1624.curl4j.core.Pointer;
import net.covers1624.curl4j.util.CurlHandle;
import net.covers1624.curl4j.util.CurlInput;
import net.covers1624.curl4j.util.CurlMimeBody;
import net.covers1624.curl4j.util.CurlMultiHandle;
import net.covers1624.curl4j.util.HeaderCollector;
import net.covers1624.curl4j.util.SListHeaderWrapper;
import net.covers1624.quack.net.httpapi.HeaderList;
import net.covers1624.quack.net.httpapi.WebBody;
import net.covers1624.quack.net.httpapi.curl4j.Curl4jEngineRequest;
import net.covers1624.quack.net.httpapi.curl4j.Curl4jEngineResponse;
import net.covers1624.quack.net.httpapi.curl4j.Curl4jHttpException;
import net.covers1624.quack.net.httpapi.curl4j.HandlePool;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.Nullable;

class IncrementalCurl4jResponse
extends Curl4jEngineResponse {
    private long buf = Memory.malloc((long)65536L);
    private ByteBuffer buffer = Memory.newDirectByteBuffer((long)this.buf, (int)65536);
    private boolean done;
    private boolean paused;
    private final Curl4jEngineRequest request;
    private final HandlePool.Entry handleEntry;
    private final CurlMultiHandle handle;
    @Nullable
    private final CurlInput input;
    @Nullable
    private final CurlMimeBody mimeBody;
    private final SListHeaderWrapper headers;
    private final int statusCode;
    private final HeaderList responseHeaders = new HeaderList();
    private final CurlWriteCallback writeCallback = new CurlWriteCallback((ptr, size, nmemb, userdata) -> {
        int rs = (int)(size * nmemb);
        if (rs == 0) {
            return rs;
        }
        if (this.buffer.remaining() < rs) {
            if (this.buffer.position() != 0) {
                this.paused = true;
                return 0x10000001L;
            }
            this.growBuffer(rs - this.buffer.remaining());
        }
        Memory.memcpy((long)ptr, (long)(this.buf + (long)this.buffer.position()), (long)rs);
        this.buffer.position(this.buffer.position() + rs);
        return rs;
    });
    private final InputStream is = new InputStream(){

        @Override
        public int read() throws IOException {
            if (IncrementalCurl4jResponse.this.buffer.remaining() == 0) {
                if (IncrementalCurl4jResponse.this.done) {
                    return -1;
                }
                IncrementalCurl4jResponse.this.fillBuffer();
            }
            return IncrementalCurl4jResponse.this.buffer.get() & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (IncrementalCurl4jResponse.this.buffer.remaining() == 0) {
                if (IncrementalCurl4jResponse.this.done) {
                    return -1;
                }
                IncrementalCurl4jResponse.this.fillBuffer();
            }
            int l = Math.min(len, IncrementalCurl4jResponse.this.buffer.remaining());
            IncrementalCurl4jResponse.this.buffer.get(b, off, l);
            return l;
        }
    };
    private final WebBody webBody;

    public IncrementalCurl4jResponse(Curl4jEngineRequest request, HandlePool.Entry handleEntry) throws IOException {
        this.request = request;
        this.handleEntry = handleEntry;
        this.handle = (CurlMultiHandle)handleEntry.handle;
        this.input = request.makeInput();
        this.mimeBody = request.buildMime((CurlHandle)this.handle);
        this.headers = new SListHeaderWrapper(request.headers().toStrings());
        try (HeaderCollector headerCollector = new HeaderCollector();){
            if (this.input != null) {
                this.input.apply((CurlHandle)this.handle);
            } else if (this.mimeBody != null) {
                this.mimeBody.apply((CurlHandle)this.handle);
            }
            this.headers.apply((CurlHandle)this.handle);
            headerCollector.apply((CurlHandle)this.handle);
            CURL.curl_easy_setopt((long)this.handle.curl, (int)20011, (long)this.writeCallback.getFunctionAddress());
            for (Consumer<CurlHandle> customOption : request.customOptions()) {
                customOption.accept((CurlHandle)this.handle);
            }
            CURL.curl_multi_add_handle((long)this.handle.multi, (long)this.handle.curl);
            this.fillBuffer();
            this.statusCode = (int)CURL.curl_easy_getinfo_long((long)this.handle.curl, (int)0x200002);
            this.responseHeaders.addAllMulti(headerCollector.getHeaders());
            final String contentType = this.responseHeaders.get("Content-Type");
            String len = this.responseHeaders.get("Content-Length");
            final long contentLength = len != null && !len.isEmpty() ? Long.parseLong(len) : -1L;
            this.webBody = new WebBody(){

                @Override
                public InputStream open() {
                    return IncrementalCurl4jResponse.this.is;
                }

                @Override
                public boolean multiOpenAllowed() {
                    return false;
                }

                @Override
                public long length() {
                    return contentLength;
                }

                @Override
                @Nullable
                public String contentType() {
                    return contentType;
                }
            };
        }
    }

    private void fillBuffer() throws IOException {
        assert (this.buffer.position() == 0 || this.buffer.position() == this.buffer.limit()) : "Buffer must either be empty or fully consumed.";
        this.buffer.position(0);
        this.buffer.limit(this.buffer.capacity());
        if (this.paused) {
            this.paused = false;
            CURL.curl_easy_pause((long)this.handle.curl, (int)0);
        }
        try (Memory.Stack stack = Memory.pushStack();){
            Pointer nHandles = stack.mallocPointer();
            while (!this.done && !this.paused) {
                int ret = CURL.curl_multi_perform((long)this.handle.multi, (Pointer)nHandles);
                if (ret != 0) {
                    throw new Curl4jHttpException("Curl multi returned error: " + this.handle.errorBuffer + "(" + CURL.curl_multi_strerror((int)ret) + ")");
                }
                this.done = nHandles.readInt() == 0;
            }
            if (this.done) {
                CURLMsg msg;
                while ((msg = CURL.curl_multi_info_read((long)this.handle.multi, (Pointer)nHandles)) != null) {
                    int ret;
                    if (msg.msg() != 1 || (ret = (int)msg.data()) == 0) continue;
                    throw new Curl4jHttpException("Curl returned error: " + this.handle.errorBuffer + "(" + CURL.curl_easy_strerror((int)ret) + ")");
                }
            }
        }
        this.buffer.flip();
    }

    private void growBuffer(int more) {
        int newSize = this.buffer.limit() + more;
        this.buf = Memory.realloc((long)this.buf, (long)newSize);
        ByteBuffer newBuf = Memory.newDirectByteBuffer((long)this.buf, (int)newSize);
        newBuf.position(this.buffer.position());
        this.buffer = newBuf;
    }

    @Override
    public void close() throws IOException {
        CURL.curl_multi_remove_handle((long)this.handle.multi, (long)this.handle.curl);
        IncrementalCurl4jResponse.closeSafe(new AutoCloseable[]{this.writeCallback, this.input, this.mimeBody, this.headers, this.handleEntry});
        Memory.free((long)this.buf);
    }

    private static void closeSafe(AutoCloseable ... closeables) {
        Throwable exception = null;
        for (AutoCloseable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (Throwable ex) {
                if (exception == null) {
                    exception = ex;
                    continue;
                }
                exception.addSuppressed(ex);
            }
        }
        if (exception != null) {
            SneakyUtils.throwUnchecked(exception);
        }
    }

    @Override
    public Curl4jEngineRequest request() {
        return this.request;
    }

    @Override
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    public String message() {
        return "";
    }

    @Override
    public HeaderList headers() {
        return this.responseHeaders;
    }

    @Override
    public WebBody body() {
        return this.webBody;
    }
}

