/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.net.httpapi.okhttp;

import java.io.IOException;
import java.io.InputStream;
import kotlin.Pair;
import net.covers1624.quack.annotation.Requires;
import net.covers1624.quack.net.httpapi.EngineRequest;
import net.covers1624.quack.net.httpapi.EngineResponse;
import net.covers1624.quack.net.httpapi.HeaderList;
import net.covers1624.quack.net.httpapi.WebBody;
import okhttp3.MediaType;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.Nullable;

@Requires(value="com.squareup.okhttp3:okhttp")
public class OkHttpEngineResponse
implements EngineResponse {
    private final EngineRequest request;
    private final Response response;
    private final HeaderList headers = new HeaderList();
    @Nullable
    private final WebBody body;

    public OkHttpEngineResponse(EngineRequest request, Response response) {
        this.request = request;
        this.response = response;
        for (Pair header : response.headers()) {
            this.headers.add((String)header.component1(), (String)header.component2());
        }
        ResponseBody respBody = response.body();
        this.body = respBody != null ? new ResponseBodyWrapper(respBody) : null;
    }

    @Override
    public EngineRequest request() {
        return this.request;
    }

    @Override
    public int statusCode() {
        return this.response.code();
    }

    @Override
    public String message() {
        return this.response.message();
    }

    @Override
    public HeaderList headers() {
        return this.headers;
    }

    @Override
    @Nullable
    public WebBody body() {
        return this.body;
    }

    @Override
    public void close() throws IOException {
        ResponseBody body = this.response.body();
        if (body != null) {
            body.close();
        }
    }

    private static class ResponseBodyWrapper
    implements WebBody {
        private final ResponseBody body;
        @Nullable
        private final String contentType;

        public ResponseBodyWrapper(ResponseBody body) {
            this.body = body;
            MediaType contentType = body.contentType();
            this.contentType = contentType != null ? contentType.toString() : null;
        }

        @Override
        public InputStream open() {
            return this.body.byteStream();
        }

        @Override
        public boolean multiOpenAllowed() {
            return false;
        }

        @Override
        public long length() {
            return this.body.contentLength();
        }

        @Override
        @Nullable
        public String contentType() {
            return this.contentType;
        }
    }
}

