/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.net.httpapi.okhttp;

import java.io.IOException;
import java.io.InputStream;
import net.covers1624.quack.annotation.Requires;
import net.covers1624.quack.net.httpapi.AbstractEngineRequest;
import net.covers1624.quack.net.httpapi.EngineRequest;
import net.covers1624.quack.net.httpapi.EngineResponse;
import net.covers1624.quack.net.httpapi.HeaderList;
import net.covers1624.quack.net.httpapi.MultipartBody;
import net.covers1624.quack.net.httpapi.WebBody;
import net.covers1624.quack.net.httpapi.okhttp.OkHttpEngine;
import net.covers1624.quack.net.httpapi.okhttp.OkHttpEngineResponse;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.Nullable;

@Requires(value="com.squareup.okhttp3:okhttp")
public class OkHttpEngineRequest
extends AbstractEngineRequest {
    private final OkHttpEngine engine;
    @Nullable
    private Request.Builder builder;

    public OkHttpEngineRequest(OkHttpEngine engine) {
        this.engine = engine;
    }

    @Override
    public EngineRequest method(String method, @Nullable WebBody body) {
        assert (this.builder == null) : "Method already set.";
        this.builder = new Request.Builder();
        RequestBody reqBody = null;
        if (body != null) {
            if (!(body instanceof MultipartBody)) {
                reqBody = OkHttpEngineRequest.toOkhttp(body);
            } else {
                MultipartBody.Builder bodyBuilder = new MultipartBody.Builder();
                bodyBuilder.setType(okhttp3.MultipartBody.FORM);
                for (MultipartBody.Part part : ((MultipartBody)body).getParts()) {
                    bodyBuilder.addFormDataPart(part.name, part.fileName, OkHttpEngineRequest.toOkhttp(part.body));
                }
                reqBody = bodyBuilder.build();
            }
        }
        this.builder.method(method, reqBody);
        return this;
    }

    @Override
    protected void assertState() {
        super.assertState();
        if (this.builder == null) {
            throw new IllegalStateException("method(String, Body) must be called first");
        }
    }

    @Override
    public EngineRequest url(String url) {
        super.url(url);
        this.builder.url(url);
        return this;
    }

    @Override
    public EngineResponse execute() throws IOException {
        this.assertState();
        if (this.url == null) {
            throw new IllegalStateException("Url not set.");
        }
        this.executed = true;
        for (HeaderList.Entry header : this.headers) {
            this.builder.addHeader(header.name, header.value);
        }
        Response response = this.engine.getClient().newCall(this.builder.build()).execute();
        return new OkHttpEngineResponse(this, response);
    }

    private static RequestBody toOkhttp(final WebBody body) {
        String contentTypeStr = body.contentType();
        final MediaType contentType = contentTypeStr != null ? MediaType.parse((String)contentTypeStr) : null;
        return new RequestBody(){

            public void writeTo(BufferedSink dst) throws IOException {
                try (Source src = Okio.source((InputStream)body.open());){
                    dst.writeAll(src);
                }
            }

            @Nullable
            public MediaType contentType() {
                return contentType;
            }

            public long contentLength() {
                return body.length();
            }

            public boolean isOneShot() {
                return true;
            }
        };
    }
}

