/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.net.httpapi;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.Nullable;

public interface WebBody {
    public InputStream open() throws IOException;

    public boolean multiOpenAllowed();

    public long length();

    @Nullable
    public String contentType();

    public static WebBody string(String str) {
        return WebBody.string(str, (String)null);
    }

    public static WebBody string(String str, @Nullable String contentType) {
        return WebBody.string(str, StandardCharsets.UTF_8, contentType);
    }

    public static WebBody string(String str, Charset charset) {
        return WebBody.string(str, charset, null);
    }

    public static WebBody string(String str, Charset charset, @Nullable String contentType) {
        return WebBody.bytes(str.getBytes(charset), contentType);
    }

    public static WebBody bytes(byte[] bytes) {
        return new BytesBody(bytes, null);
    }

    public static WebBody bytes(byte[] bytes, @Nullable String contentType) {
        return new BytesBody(bytes, contentType);
    }

    public static class BytesBody
    implements WebBody {
        private final byte[] bytes;
        @Nullable
        private final String contentType;

        public BytesBody(byte[] bytes, @Nullable String contentType) {
            this.bytes = bytes;
            this.contentType = contentType;
        }

        @Override
        public InputStream open() {
            return new ByteArrayInputStream(this.bytes);
        }

        @Override
        public boolean multiOpenAllowed() {
            return true;
        }

        @Override
        public long length() {
            return this.bytes.length;
        }

        @Override
        @Nullable
        public String contentType() {
            return this.contentType;
        }
    }
}

