/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.net.httpapi;

import java.util.Map;
import net.covers1624.quack.net.httpapi.EngineRequest;
import net.covers1624.quack.net.httpapi.HeaderList;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEngineRequest
implements EngineRequest {
    @Nullable
    protected String url;
    protected final HeaderList headers = new HeaderList();
    protected boolean executed = false;

    protected void assertState() {
        if (this.executed) {
            throw new IllegalStateException("Already executed.");
        }
    }

    @Override
    public EngineRequest url(String url) {
        this.assertState();
        this.url = url;
        return this;
    }

    @Override
    public EngineRequest header(String key, String value) {
        this.assertState();
        this.headers.add(key, value);
        return this;
    }

    @Override
    public EngineRequest headers(Map<String, String> headers) {
        this.assertState();
        this.headers.addAll(headers);
        return this;
    }

    @Override
    public EngineRequest headers(HeaderList headers) {
        this.assertState();
        this.headers.addAll(headers);
        return this;
    }

    @Override
    public EngineRequest removeHeader(String key) {
        this.assertState();
        this.headers.removeAll(key);
        return this;
    }

    @Override
    public String getUrl() {
        this.assertState();
        assert (this.url != null) : "Url not set";
        return this.url;
    }

    @Override
    public HeaderList getHeaders() {
        this.assertState();
        return this.headers;
    }
}

