/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.net.httpapi;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.covers1624.quack.net.httpapi.WebBody;
import org.jetbrains.annotations.Nullable;

public class MultipartBody
implements WebBody {
    private final List<Part> parts;

    public MultipartBody(List<Part> parts) {
        this.parts = new ArrayList<Part>(parts);
    }

    public List<Part> getParts() {
        return Collections.unmodifiableList(this.parts);
    }

    @Override
    public InputStream open() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean multiOpenAllowed() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long length() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public String contentType() {
        throw new UnsupportedOperationException();
    }

    public static class Builder {
        private final List<Part> parts = new ArrayList<Part>();

        public Builder addPart(String name, WebBody body) {
            return this.addPart(name, null, body);
        }

        public Builder addPart(String name, @Nullable String fileName, WebBody body) {
            this.parts.add(new Part(name, fileName, body));
            return this;
        }

        public MultipartBody build() {
            return new MultipartBody(this.parts);
        }
    }

    public static class Part {
        public final String name;
        @Nullable
        public final String fileName;
        public final WebBody body;

        public Part(String name, @Nullable String fileName, WebBody body) {
            this.name = name;
            this.fileName = fileName;
            this.body = body;
        }
    }
}

