/*
 * Decompiled with CFR 0.152.
 */
package net.dempsy.distconfig.classpath;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.dempsy.distconfig.PropertiesReader;
import net.dempsy.distconfig.PropertiesWatcher;
import net.dempsy.util.Functional;
import net.dempsy.util.SafeString;

public class ClasspathPropertiesReader
implements PropertiesReader {
    private final boolean actLikeYouSupportNotifications;
    private final String classpathUri;

    public ClasspathPropertiesReader(String classpathUri, boolean actLikeYouSupportNotifications) throws IOException {
        this.actLikeYouSupportNotifications = actLikeYouSupportNotifications;
        this.classpathUri = classpathUri;
    }

    public ClasspathPropertiesReader(String classpathUri) throws IOException {
        this(classpathUri, false);
    }

    private static String cleanPath(String path) {
        String trimmed = path.trim();
        if (trimmed.startsWith("/")) {
            trimmed = ClasspathPropertiesReader.cleanPath(trimmed.substring(1, trimmed.length()));
        }
        if (trimmed.endsWith("/")) {
            trimmed = trimmed.substring(0, trimmed.length() - 1);
        }
        return trimmed;
    }

    public PropertiesReader.VersionedProperties read(PropertiesWatcher watcher) throws IOException {
        if (watcher != null && !this.actLikeYouSupportNotifications) {
            throw new UnsupportedOperationException("Cannot add watch \"" + SafeString.objectDescription((Object)watcher) + " to a " + ClasspathPropertiesReader.class.getSimpleName());
        }
        String resource = this.classpathUri.startsWith("classpath:///") ? this.classpathUri.substring(14) : (this.classpathUri.startsWith("classpathUri:") ? this.classpathUri.substring(11) : ClasspathPropertiesReader.cleanPath(this.classpathUri));
        System.out.println("trying to read:" + resource);
        InputStream resAsStream = ClasspathPropertiesReader.class.getClassLoader().getResourceAsStream(resource);
        return resAsStream == null ? new PropertiesReader.VersionedProperties(-1, null) : new PropertiesReader.VersionedProperties(0, (Properties)Functional.chainThrows((Object)new Properties(), (Functional.ConsumerThrows[])new Functional.ConsumerThrows[]{p -> p.load(resAsStream)}));
    }

    public boolean supportsNotification() {
        return this.actLikeYouSupportNotifications;
    }
}

